/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF.  The full HDF copyright notice, including       *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF/releases/.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-----------------------------------------------------------------------------
 * File:    cnbit_priv.h
 * Purpose: Header file for N-bit encoding information.
 * Dependencies: should only be included from hcomp_priv.h
 *---------------------------------------------------------------------------*/

#ifndef H4_CNBIT_PRIV_H
#define H4_CNBIT_PRIV_H

#include "hdf_priv.h"

/* size of the N-bit buffer */
#define NBIT_BUF_SIZE (MAX_NT_SIZE * 64)

/* size of the N-bit mask buffer (same as buffer size for now) */
#define NBIT_MASK_SIZE (MAX_NT_SIZE)

typedef struct {  /* structure to hold bit vector info */
    int   offset; /* offset of the bit information */
    int   length; /* number of bits in the information */
    uint8 mask;   /* mask for this bit vector */
} nbit_mask_info_t;

/* N-bit [en|de]coding information */
typedef struct {
    int32            nt;                        /* number type of data we are encoding */
    int              nt_size;                   /* size of the number-type in the file */
    int              fill_one;                  /* whether to fill with 1's or not (0's) */
    int              sign_ext;                  /* whether to sign extend or not */
    uint8            buffer[NBIT_BUF_SIZE];     /* buffer for expanding n-bit data in */
    int              buf_pos;                   /* current offset in the expansion buffer */
    int              mask_off;                  /* offset of the bit to start masking with */
    int              mask_len;                  /* number of bits to mask */
    int32            offset;                    /* offset in the file in terms of bytes */
    uint8            mask_buf[NBIT_MASK_SIZE];  /* buffer to hold the bitmask */
    nbit_mask_info_t mask_info[NBIT_MASK_SIZE]; /* information about the mask */
    int              nt_pos;                    /* current byte to read or write */
} comp_coder_nbit_info_t;

#ifdef __cplusplus
extern "C" {
#endif

HDFLIBAPI funclist_t cnbit_funcs; /* functions to perform N-bit encoding */

/*
 ** from cnbit.c
 */

HDFLIBAPI int32 HCPcnbit_stread(accrec_t *rec);

HDFLIBAPI int32 HCPcnbit_stwrite(accrec_t *rec);

HDFLIBAPI int32 HCPcnbit_seek(accrec_t *access_rec, int32 offset, int origin);

HDFLIBAPI int32 HCPcnbit_inquire(accrec_t *access_rec, int32 *pfile_id, uint16 *ptag, uint16 *pref,
                                 int32 *plength, int32 *poffset, int32 *pposn, int16 *paccess,
                                 int16 *pspecial);

HDFLIBAPI int32 HCPcnbit_read(accrec_t *access_rec, int32 length, void *data);

HDFLIBAPI int32 HCPcnbit_write(accrec_t *access_rec, int32 length, const void *data);

HDFLIBAPI int HCPcnbit_endaccess(accrec_t *access_rec);

#ifdef __cplusplus
}
#endif

#endif /* H4_CNBIT_PRIV_H */
