// Copyright 2023 The Fuchsia Authors
//
// Licensed under a BSD-style license <LICENSE-BSD>, Apache License, Version 2.0
// <LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0>, or the MIT
// license <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your option.
// This file may not be copied, modified, or distributed except according to
// those terms.

extern crate zerocopy;

use zerocopy::KnownLayout;

fn main() {}

// These tests cause errors which are generated by a later compilation pass than
// the other errors we generate, and so if they're compiled in the same file,
// the compiler will never get to that pass, and so we won't get the errors.

//
// KnownLayout errors
//

fn assert_kl<T: ?Sized + KnownLayout>(_: &T) {}

// | `repr(C)`? | generic? | `KnownLayout`? | `Sized`? | Type Name |
// |          N |        Y |              N |        N |      KL04 |
#[derive(KnownLayout)]
struct KL04<T: ?Sized>(u8, T);

fn test_kl04<T: ?Sized>(kl: &KL04<T>) {
    assert_kl(kl);
}

// | `repr(C)`? | generic? | `KnownLayout`? | `Sized`? | Type Name |
// |          N |        Y |              Y |        N |      KL06 |
#[derive(KnownLayout)]
struct KL06<T: ?Sized + KnownLayout>(u8, T);

fn test_kl06<T: ?Sized + KnownLayout>(kl: &KL06<T>) {
    assert_kl(kl);
}

// | `repr(C)`? | generic? | `KnownLayout`? | `Sized`? | Type Name |
// |          Y |        Y |              N |        N |      KL12 |
#[derive(KnownLayout)]
#[repr(C)]
struct KL12<T: ?Sized>(u8, T);

fn test_kl12<T: ?Sized>(kl: &KL12<T>) {
    assert_kl(kl)
}

// | `repr(C)`? | generic? | `KnownLayout`? | `Sized`? | Type Name |
// |          Y |        Y |              N |        Y |      KL13 |
#[derive(KnownLayout)]
#[repr(C)]
struct KL13<T>(u8, T);

fn test_kl13<T>(t: T) -> impl KnownLayout {
    KL13(0u8, t)
}
