# Contributing to librtpi

A big welcome and thanks for taking an interest in contributing to the project!

## Project Information

The canonical upstream for this project is:
[gitlab.com/linux-rt/librtpi](https://gitlab.com/linux-rt/librtpi). Please use
that repository for bug reports and pull requests.

A backup mirror is also available at:
[github.com/linux-rt/librtpi](https://github.com/linux-rt/librtpi).

Current Project Maintainers:
* Gratian Crisan <[gratian@gmail.com](mailto:gratian@gmail.com)>
  [[GitLab](https://gitlab.com/gratian.crisan),
  [GitHub](https://github.com/gratian/)]

### Contributing Patches

We follow the GitLab
[forking-workflow](https://docs.gitlab.com/ee/user/project/repository/forking_workflow.html).
Please submit all patches as GitLab merge requests.

All commits have to include, at a minimum, one 'Signed-off-by:' line from the
author of the patch. See the "Developer Certificate of Origin" section below

### Coding Style

The preferred coding style for librtpi follows the Linux kernel [coding
style](https://www.kernel.org/doc/html/latest/process/coding-style.html).

### Issues

Issues should be used to report problems with the library, request a new
feature, or to discuss potential changes before a PR is created. They should be
filed using the [Issues tracker](https://gitlab.com/linux-rt/librtpi/-/issues)
on GitLab.

## Developer Certificate of Origin (DCO)

   [Developer's Certificate of Origin](https://developercertificate.org/)

   By making a contribution to this project, I certify that:

   (a) The contribution was created in whole or in part by me and I
       have the right to submit it under the open source license
       indicated in the file; or

   (b) The contribution is based upon previous work that, to the best
       of my knowledge, is covered under an appropriate open source
       license and I have the right under that license to submit that
       work with modifications, whether created in whole or in part
       by me, under the same open source license (unless I am
       permitted to submit under a different license), as indicated
       in the file; or

   (c) The contribution was provided directly to me by some other
       person who certified (a), (b) or (c) and I have not modified
       it.

   (d) I understand and agree that this project and the contribution
       are public and that a record of the contribution (including all
       personal information I submit with it, including my sign-off) is
       maintained indefinitely and may be redistributed consistent with
       this project or the open source license(s) involved.

_Then add a line to your commit message saying:_  
    Signed-off-by: Random J Developer \<random@developer.example.org\> 

The Real-Time Priority Inheritance Library is licensed under the Lesser GNU
Public License version 2.1.

[logo]: logo.png
