/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_bkl.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t29, t30, t31, t32, t34;
  double t36, t39, t40, t41, t44, t47, t51, tzk0;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t21 = params->alpha * params->mu1;
  t22 = M_CBRT6;
  t23 = t21 * t22;
  t24 = M_PI * M_PI;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = 0.1e1 / t26;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t36 = t27 * sigma[0] * t30 * t34;
  t39 = exp(-t23 * t36 / 0.24e2);
  t40 = params->beta * params->mu1;
  t41 = t40 * t22;
  t44 = exp(-t41 * t36 / 0.24e2);
  t47 = 0.1e1 + params->gamma * params->kappa * (t39 - t44);
  t51 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t47);
  tzk0 = 0.2e1 * t51;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t29, t30, t31, t32, t34;
  double t36, t39, t40, t41, t44, t47, t51, tzk0;

  double t52, t57, t58, t59, t60, t61, t62, t64;
  double t65, t68, t69, t74, t79, tvrho0, t82, t91;
  double t95, tvsigma0;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t21 = params->alpha * params->mu1;
  t22 = M_CBRT6;
  t23 = t21 * t22;
  t24 = M_PI * M_PI;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = 0.1e1 / t26;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t36 = t27 * sigma[0] * t30 * t34;
  t39 = exp(-t23 * t36 / 0.24e2);
  t40 = params->beta * params->mu1;
  t41 = t40 * t22;
  t44 = exp(-t41 * t36 / 0.24e2);
  t47 = 0.1e1 + params->gamma * params->kappa * (t39 - t44);
  t51 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t47);
  tzk0 = 0.2e1 * t51;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t52 = 0.1e1 / t32;
  t57 = t6 * t17;
  t58 = t18 * params->gamma;
  t59 = t22 * t27;
  t60 = t21 * t59;
  t61 = sigma[0] * t30;
  t62 = t31 * rho[0];
  t64 = 0.1e1 / t32 / t62;
  t65 = t64 * t39;
  t68 = t40 * t59;
  t69 = t64 * t44;
  t74 = params->kappa * (t60 * t61 * t65 / 0.9e1 - t68 * t61 * t69 / 0.9e1);
  t79 = my_piecewise3(t2, 0, -t6 * t17 * t52 * t47 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t74);
  tvrho0 = 0.2e1 * rho[0] * t79 + 0.2e1 * t51;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t82 = t27 * t30;
  t91 = params->kappa * (-t23 * t82 * t34 * t39 / 0.24e2 + t41 * t82 * t34 * t44 / 0.24e2);
  t95 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t91);
  tvsigma0 = 0.2e1 * rho[0] * t95;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t29, t30, t31, t32, t34;
  double t36, t39, t40, t41, t44, t47, t51, tzk0;

  double t52, t57, t58, t59, t60, t61, t62, t64;
  double t65, t68, t69, t74, t79, tvrho0, t82, t91;
  double t95, tvsigma0;

  double t99, t104, t108, t110, t111, t115, t116, t117;
  double t118, t120, t121, t122, t123, t124, t127, t128;
  double t132, t136, t137, t138, t139, t144, t149, tv2rho20;
  double t158, t160, t161, t162, t169, t174, t179, tv2rhosigma0;
  double t182, t183, t184, t186, t190, t196, t200, tv2sigma20;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t21 = params->alpha * params->mu1;
  t22 = M_CBRT6;
  t23 = t21 * t22;
  t24 = M_PI * M_PI;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = 0.1e1 / t26;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t36 = t27 * sigma[0] * t30 * t34;
  t39 = exp(-t23 * t36 / 0.24e2);
  t40 = params->beta * params->mu1;
  t41 = t40 * t22;
  t44 = exp(-t41 * t36 / 0.24e2);
  t47 = 0.1e1 + params->gamma * params->kappa * (t39 - t44);
  t51 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t47);
  tzk0 = 0.2e1 * t51;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t52 = 0.1e1 / t32;
  t57 = t6 * t17;
  t58 = t18 * params->gamma;
  t59 = t22 * t27;
  t60 = t21 * t59;
  t61 = sigma[0] * t30;
  t62 = t31 * rho[0];
  t64 = 0.1e1 / t32 / t62;
  t65 = t64 * t39;
  t68 = t40 * t59;
  t69 = t64 * t44;
  t74 = params->kappa * (t60 * t61 * t65 / 0.9e1 - t68 * t61 * t69 / 0.9e1);
  t79 = my_piecewise3(t2, 0, -t6 * t17 * t52 * t47 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t74);
  tvrho0 = 0.2e1 * rho[0] * t79 + 0.2e1 * t51;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t82 = t27 * t30;
  t91 = params->kappa * (-t23 * t82 * t34 * t39 / 0.24e2 + t41 * t82 * t34 * t44 / 0.24e2);
  t95 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t91);
  tvsigma0 = 0.2e1 * rho[0] * t95;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t99 = 0.1e1 / t32 / rho[0];
  t104 = t52 * params->gamma;
  t108 = t31 * t31;
  t110 = 0.1e1 / t32 / t108;
  t111 = t110 * t39;
  t115 = params->alpha * params->alpha;
  t116 = params->mu1 * params->mu1;
  t117 = t115 * t116;
  t118 = t22 * t22;
  t120 = 0.1e1 / t25 / t24;
  t121 = t118 * t120;
  t122 = t117 * t121;
  t123 = sigma[0] * sigma[0];
  t124 = t123 * t29;
  t127 = 0.1e1 / t18 / t108 / t62;
  t128 = t127 * t39;
  t132 = t110 * t44;
  t136 = params->beta * params->beta;
  t137 = t136 * t116;
  t138 = t137 * t121;
  t139 = t127 * t44;
  t144 = params->kappa * (-0.11e2 / 0.27e2 * t60 * t61 * t111 + 0.2e1 / 0.81e2 * t122 * t124 * t128 + 0.11e2 / 0.27e2 * t68 * t61 * t132 - 0.2e1 / 0.81e2 * t138 * t124 * t139);
  t149 = my_piecewise3(t2, 0, t6 * t17 * t99 * t47 / 0.12e2 - t57 * t104 * t74 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t58 * t144);
  tv2rho20 = 0.2e1 * rho[0] * t149 + 0.4e1 * t79;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t158 = t108 * t31;
  t160 = 0.1e1 / t18 / t158;
  t161 = t29 * t160;
  t162 = sigma[0] * t39;
  t169 = sigma[0] * t44;
  t174 = params->kappa * (t23 * t82 * t65 / 0.9e1 - t122 * t161 * t162 / 0.108e3 - t41 * t82 * t69 / 0.9e1 + t138 * t161 * t169 / 0.108e3);
  t179 = my_piecewise3(t2, 0, -t57 * t104 * t91 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t174);
  tv2rhosigma0 = 0.2e1 * rho[0] * t179 + 0.2e1 * t95;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t182 = t117 * t118;
  t183 = t120 * t29;
  t184 = t108 * rho[0];
  t186 = 0.1e1 / t18 / t184;
  t190 = t137 * t118;
  t196 = params->kappa * (t182 * t183 * t186 * t39 / 0.288e3 - t190 * t183 * t186 * t44 / 0.288e3);
  t200 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t196);
  tv2sigma20 = 0.2e1 * rho[0] * t200;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t29, t30, t31, t32, t34;
  double t36, t39, t40, t41, t44, t47, t51, tzk0;

  double t52, t57, t58, t59, t60, t61, t62, t64;
  double t65, t68, t69, t74, t79, tvrho0, t82, t91;
  double t95, tvsigma0;

  double t99, t104, t108, t110, t111, t115, t116, t117;
  double t118, t120, t121, t122, t123, t124, t127, t128;
  double t132, t136, t137, t138, t139, t144, t149, tv2rho20;
  double t158, t160, t161, t162, t169, t174, t179, tv2rhosigma0;
  double t182, t183, t184, t186, t190, t196, t200, tv2sigma20;

  double t207, t215, t216, t220, t222, t228, t229, t230;
  double t231, t232, t233, t234, t235, t236, t240, t249;
  double t250, t255, t260, tv3rho30, t273, t277, t278, t279;
  double t293, t298, tv3rho2sigma0, t308, t309, t310, t322, t327;
  double tv3rhosigma20, t331, t338, t342, tv3sigma30;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t21 = params->alpha * params->mu1;
  t22 = M_CBRT6;
  t23 = t21 * t22;
  t24 = M_PI * M_PI;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = 0.1e1 / t26;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t36 = t27 * sigma[0] * t30 * t34;
  t39 = exp(-t23 * t36 / 0.24e2);
  t40 = params->beta * params->mu1;
  t41 = t40 * t22;
  t44 = exp(-t41 * t36 / 0.24e2);
  t47 = 0.1e1 + params->gamma * params->kappa * (t39 - t44);
  t51 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t47);
  tzk0 = 0.2e1 * t51;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t52 = 0.1e1 / t32;
  t57 = t6 * t17;
  t58 = t18 * params->gamma;
  t59 = t22 * t27;
  t60 = t21 * t59;
  t61 = sigma[0] * t30;
  t62 = t31 * rho[0];
  t64 = 0.1e1 / t32 / t62;
  t65 = t64 * t39;
  t68 = t40 * t59;
  t69 = t64 * t44;
  t74 = params->kappa * (t60 * t61 * t65 / 0.9e1 - t68 * t61 * t69 / 0.9e1);
  t79 = my_piecewise3(t2, 0, -t6 * t17 * t52 * t47 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t74);
  tvrho0 = 0.2e1 * rho[0] * t79 + 0.2e1 * t51;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t82 = t27 * t30;
  t91 = params->kappa * (-t23 * t82 * t34 * t39 / 0.24e2 + t41 * t82 * t34 * t44 / 0.24e2);
  t95 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t91);
  tvsigma0 = 0.2e1 * rho[0] * t95;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t99 = 0.1e1 / t32 / rho[0];
  t104 = t52 * params->gamma;
  t108 = t31 * t31;
  t110 = 0.1e1 / t32 / t108;
  t111 = t110 * t39;
  t115 = params->alpha * params->alpha;
  t116 = params->mu1 * params->mu1;
  t117 = t115 * t116;
  t118 = t22 * t22;
  t120 = 0.1e1 / t25 / t24;
  t121 = t118 * t120;
  t122 = t117 * t121;
  t123 = sigma[0] * sigma[0];
  t124 = t123 * t29;
  t127 = 0.1e1 / t18 / t108 / t62;
  t128 = t127 * t39;
  t132 = t110 * t44;
  t136 = params->beta * params->beta;
  t137 = t136 * t116;
  t138 = t137 * t121;
  t139 = t127 * t44;
  t144 = params->kappa * (-0.11e2 / 0.27e2 * t60 * t61 * t111 + 0.2e1 / 0.81e2 * t122 * t124 * t128 + 0.11e2 / 0.27e2 * t68 * t61 * t132 - 0.2e1 / 0.81e2 * t138 * t124 * t139);
  t149 = my_piecewise3(t2, 0, t6 * t17 * t99 * t47 / 0.12e2 - t57 * t104 * t74 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t58 * t144);
  tv2rho20 = 0.2e1 * rho[0] * t149 + 0.4e1 * t79;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t158 = t108 * t31;
  t160 = 0.1e1 / t18 / t158;
  t161 = t29 * t160;
  t162 = sigma[0] * t39;
  t169 = sigma[0] * t44;
  t174 = params->kappa * (t23 * t82 * t65 / 0.9e1 - t122 * t161 * t162 / 0.108e3 - t41 * t82 * t69 / 0.9e1 + t138 * t161 * t169 / 0.108e3);
  t179 = my_piecewise3(t2, 0, -t57 * t104 * t91 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t174);
  tv2rhosigma0 = 0.2e1 * rho[0] * t179 + 0.2e1 * t95;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t182 = t117 * t118;
  t183 = t120 * t29;
  t184 = t108 * rho[0];
  t186 = 0.1e1 / t18 / t184;
  t190 = t137 * t118;
  t196 = params->kappa * (t182 * t183 * t186 * t39 / 0.288e3 - t190 * t183 * t186 * t44 / 0.288e3);
  t200 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t196);
  tv2sigma20 = 0.2e1 * rho[0] * t200;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t207 = t99 * params->gamma;
  t215 = 0.1e1 / t32 / t184;
  t216 = t215 * t39;
  t220 = t108 * t108;
  t222 = 0.1e1 / t18 / t220;
  t228 = t116 * params->mu1;
  t229 = t115 * params->alpha * t228;
  t230 = t24 * t24;
  t231 = 0.1e1 / t230;
  t232 = t229 * t231;
  t233 = t123 * sigma[0];
  t234 = t220 * t62;
  t235 = 0.1e1 / t234;
  t236 = t233 * t235;
  t240 = t215 * t44;
  t249 = t136 * params->beta * t228;
  t250 = t249 * t231;
  t255 = params->kappa * (0.154e3 / 0.81e2 * t60 * t61 * t216 - 0.22e2 / 0.81e2 * t122 * t124 * t222 * t39 + 0.8e1 / 0.243e3 * t232 * t236 * t39 - 0.154e3 / 0.81e2 * t68 * t61 * t240 + 0.22e2 / 0.81e2 * t138 * t124 * t222 * t44 - 0.8e1 / 0.243e3 * t250 * t236 * t44);
  t260 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t47 + t57 * t207 * t74 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t104 * t144 - 0.3e1 / 0.8e1 * t57 * t58 * t255);
  tv3rho30 = 0.2e1 * rho[0] * t260 + 0.6e1 * t149;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t273 = t29 * t127;
  t277 = t220 * t31;
  t278 = 0.1e1 / t277;
  t279 = t278 * t123;
  t293 = params->kappa * (-0.11e2 / 0.27e2 * t23 * t82 * t111 + t122 * t273 * t162 / 0.12e2 - t232 * t279 * t39 / 0.81e2 + 0.11e2 / 0.27e2 * t41 * t82 * t132 - t138 * t273 * t169 / 0.12e2 + t250 * t279 * t44 / 0.81e2);
  t298 = my_piecewise3(t2, 0, t57 * t207 * t91 / 0.12e2 - t57 * t104 * t174 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t58 * t293);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t298 + 0.4e1 * t179;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t308 = t220 * rho[0];
  t309 = 0.1e1 / t308;
  t310 = t309 * sigma[0];
  t322 = params->kappa * (-t182 * t183 * t160 * t39 / 0.54e2 + t232 * t310 * t39 / 0.216e3 + t190 * t183 * t160 * t44 / 0.54e2 - t250 * t310 * t44 / 0.216e3);
  t327 = my_piecewise3(t2, 0, -t57 * t104 * t196 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t322);
  tv3rhosigma20 = 0.2e1 * rho[0] * t327 + 0.2e1 * t200;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t331 = t231 / t220;
  t338 = params->kappa * (-t229 * t331 * t39 / 0.576e3 + t249 * t331 * t44 / 0.576e3);
  t342 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t338);
  tv3sigma30 = 0.2e1 * rho[0] * t342;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t29, t30, t31, t32, t34;
  double t36, t39, t40, t41, t44, t47, t51, tzk0;

  double t52, t57, t58, t59, t60, t61, t62, t64;
  double t65, t68, t69, t74, t79, tvrho0, t82, t91;
  double t95, tvsigma0;

  double t99, t104, t108, t110, t111, t115, t116, t117;
  double t118, t120, t121, t122, t123, t124, t127, t128;
  double t132, t136, t137, t138, t139, t144, t149, tv2rho20;
  double t158, t160, t161, t162, t169, t174, t179, tv2rhosigma0;
  double t182, t183, t184, t186, t190, t196, t200, tv2sigma20;

  double t207, t215, t216, t220, t222, t228, t229, t230;
  double t231, t232, t233, t234, t235, t236, t240, t249;
  double t250, t255, t260, tv3rho30, t273, t277, t278, t279;
  double t293, t298, tv3rho2sigma0, t308, t309, t310, t322, t327;
  double tv3rhosigma20, t331, t338, t342, tv3sigma30;

  double t349, t360, t366, t371, t373, t377, t378, t379;
  double t380, t381, t386, t387, t402, t403, t405, t415;
  double tv4rho40, t431, t435, t442, t444, t467, tv4rho3sigma0, t480;
  double t486, t488, t508, tv4rho2sigma20, t514, t520, t540, tv4rhosigma30;
  double t545, t560, tv4sigma40;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t21 = params->alpha * params->mu1;
  t22 = M_CBRT6;
  t23 = t21 * t22;
  t24 = M_PI * M_PI;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = 0.1e1 / t26;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t36 = t27 * sigma[0] * t30 * t34;
  t39 = exp(-t23 * t36 / 0.24e2);
  t40 = params->beta * params->mu1;
  t41 = t40 * t22;
  t44 = exp(-t41 * t36 / 0.24e2);
  t47 = 0.1e1 + params->gamma * params->kappa * (t39 - t44);
  t51 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t47);
  tzk0 = 0.2e1 * t51;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t52 = 0.1e1 / t32;
  t57 = t6 * t17;
  t58 = t18 * params->gamma;
  t59 = t22 * t27;
  t60 = t21 * t59;
  t61 = sigma[0] * t30;
  t62 = t31 * rho[0];
  t64 = 0.1e1 / t32 / t62;
  t65 = t64 * t39;
  t68 = t40 * t59;
  t69 = t64 * t44;
  t74 = params->kappa * (t60 * t61 * t65 / 0.9e1 - t68 * t61 * t69 / 0.9e1);
  t79 = my_piecewise3(t2, 0, -t6 * t17 * t52 * t47 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t74);
  tvrho0 = 0.2e1 * rho[0] * t79 + 0.2e1 * t51;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t82 = t27 * t30;
  t91 = params->kappa * (-t23 * t82 * t34 * t39 / 0.24e2 + t41 * t82 * t34 * t44 / 0.24e2);
  t95 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t91);
  tvsigma0 = 0.2e1 * rho[0] * t95;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t99 = 0.1e1 / t32 / rho[0];
  t104 = t52 * params->gamma;
  t108 = t31 * t31;
  t110 = 0.1e1 / t32 / t108;
  t111 = t110 * t39;
  t115 = params->alpha * params->alpha;
  t116 = params->mu1 * params->mu1;
  t117 = t115 * t116;
  t118 = t22 * t22;
  t120 = 0.1e1 / t25 / t24;
  t121 = t118 * t120;
  t122 = t117 * t121;
  t123 = sigma[0] * sigma[0];
  t124 = t123 * t29;
  t127 = 0.1e1 / t18 / t108 / t62;
  t128 = t127 * t39;
  t132 = t110 * t44;
  t136 = params->beta * params->beta;
  t137 = t136 * t116;
  t138 = t137 * t121;
  t139 = t127 * t44;
  t144 = params->kappa * (-0.11e2 / 0.27e2 * t60 * t61 * t111 + 0.2e1 / 0.81e2 * t122 * t124 * t128 + 0.11e2 / 0.27e2 * t68 * t61 * t132 - 0.2e1 / 0.81e2 * t138 * t124 * t139);
  t149 = my_piecewise3(t2, 0, t6 * t17 * t99 * t47 / 0.12e2 - t57 * t104 * t74 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t58 * t144);
  tv2rho20 = 0.2e1 * rho[0] * t149 + 0.4e1 * t79;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t158 = t108 * t31;
  t160 = 0.1e1 / t18 / t158;
  t161 = t29 * t160;
  t162 = sigma[0] * t39;
  t169 = sigma[0] * t44;
  t174 = params->kappa * (t23 * t82 * t65 / 0.9e1 - t122 * t161 * t162 / 0.108e3 - t41 * t82 * t69 / 0.9e1 + t138 * t161 * t169 / 0.108e3);
  t179 = my_piecewise3(t2, 0, -t57 * t104 * t91 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t174);
  tv2rhosigma0 = 0.2e1 * rho[0] * t179 + 0.2e1 * t95;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t182 = t117 * t118;
  t183 = t120 * t29;
  t184 = t108 * rho[0];
  t186 = 0.1e1 / t18 / t184;
  t190 = t137 * t118;
  t196 = params->kappa * (t182 * t183 * t186 * t39 / 0.288e3 - t190 * t183 * t186 * t44 / 0.288e3);
  t200 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t196);
  tv2sigma20 = 0.2e1 * rho[0] * t200;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t207 = t99 * params->gamma;
  t215 = 0.1e1 / t32 / t184;
  t216 = t215 * t39;
  t220 = t108 * t108;
  t222 = 0.1e1 / t18 / t220;
  t228 = t116 * params->mu1;
  t229 = t115 * params->alpha * t228;
  t230 = t24 * t24;
  t231 = 0.1e1 / t230;
  t232 = t229 * t231;
  t233 = t123 * sigma[0];
  t234 = t220 * t62;
  t235 = 0.1e1 / t234;
  t236 = t233 * t235;
  t240 = t215 * t44;
  t249 = t136 * params->beta * t228;
  t250 = t249 * t231;
  t255 = params->kappa * (0.154e3 / 0.81e2 * t60 * t61 * t216 - 0.22e2 / 0.81e2 * t122 * t124 * t222 * t39 + 0.8e1 / 0.243e3 * t232 * t236 * t39 - 0.154e3 / 0.81e2 * t68 * t61 * t240 + 0.22e2 / 0.81e2 * t138 * t124 * t222 * t44 - 0.8e1 / 0.243e3 * t250 * t236 * t44);
  t260 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t47 + t57 * t207 * t74 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t104 * t144 - 0.3e1 / 0.8e1 * t57 * t58 * t255);
  tv3rho30 = 0.2e1 * rho[0] * t260 + 0.6e1 * t149;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t273 = t29 * t127;
  t277 = t220 * t31;
  t278 = 0.1e1 / t277;
  t279 = t278 * t123;
  t293 = params->kappa * (-0.11e2 / 0.27e2 * t23 * t82 * t111 + t122 * t273 * t162 / 0.12e2 - t232 * t279 * t39 / 0.81e2 + 0.11e2 / 0.27e2 * t41 * t82 * t132 - t138 * t273 * t169 / 0.12e2 + t250 * t279 * t44 / 0.81e2);
  t298 = my_piecewise3(t2, 0, t57 * t207 * t91 / 0.12e2 - t57 * t104 * t174 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t58 * t293);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t298 + 0.4e1 * t179;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t308 = t220 * rho[0];
  t309 = 0.1e1 / t308;
  t310 = t309 * sigma[0];
  t322 = params->kappa * (-t182 * t183 * t160 * t39 / 0.54e2 + t232 * t310 * t39 / 0.216e3 + t190 * t183 * t160 * t44 / 0.54e2 - t250 * t310 * t44 / 0.216e3);
  t327 = my_piecewise3(t2, 0, -t57 * t104 * t196 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * t322);
  tv3rhosigma20 = 0.2e1 * rho[0] * t327 + 0.2e1 * t200;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t331 = t231 / t220;
  t338 = params->kappa * (-t229 * t331 * t39 / 0.576e3 + t249 * t331 * t44 / 0.576e3);
  t342 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * t338);
  tv3sigma30 = 0.2e1 * rho[0] * t342;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t349 = t34 * params->gamma;
  t360 = 0.1e1 / t32 / t158;
  t366 = 0.1e1 / t18 / t308;
  t371 = t220 * t108;
  t373 = t233 / t371;
  t377 = t115 * t115;
  t378 = t116 * t116;
  t379 = t377 * t378;
  t380 = t123 * t123;
  t381 = t231 * t380;
  t386 = 0.1e1 / t32 / t220 / t158 * t22;
  t387 = t82 * t39;
  t402 = t136 * t136;
  t403 = t402 * t378;
  t405 = t82 * t44;
  t415 = my_piecewise3(t2, 0, 0.1e2 / 0.27e2 * t6 * t17 * t64 * t47 - 0.5e1 / 0.9e1 * t57 * t349 * t74 + t57 * t207 * t144 / 0.2e1 - t57 * t104 * t255 / 0.2e1 - 0.3e1 / 0.8e1 * t57 * t58 * params->kappa * (-0.2618e4 / 0.243e3 * t60 * t61 * t360 * t39 + 0.1958e4 / 0.729e3 * t122 * t124 * t366 * t39 - 0.176e3 / 0.243e3 * t232 * t373 * t39 + 0.8e1 / 0.2187e4 * t379 * t381 * t386 * t387 + 0.2618e4 / 0.243e3 * t68 * t61 * t360 * t44 - 0.1958e4 / 0.729e3 * t138 * t124 * t366 * t44 + 0.176e3 / 0.243e3 * t250 * t373 * t44 - 0.8e1 / 0.2187e4 * t403 * t381 * t386 * t405));
  tv4rho40 = 0.2e1 * rho[0] * t415 + 0.8e1 * t260;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t431 = t29 * t222;
  t435 = t235 * t123;
  t442 = t231 / t32 / t220 / t184;
  t444 = t233 * t22;
  t467 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t57 * t349 * t91 + t57 * t207 * t174 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t104 * t293 - 0.3e1 / 0.8e1 * t57 * t58 * params->kappa * (0.154e3 / 0.81e2 * t23 * t82 * t216 - 0.341e3 / 0.486e3 * t122 * t431 * t162 + 0.19e2 / 0.81e2 * t232 * t435 * t39 - t379 * t442 * t444 * t387 / 0.729e3 - 0.154e3 / 0.81e2 * t41 * t82 * t240 + 0.341e3 / 0.486e3 * t138 * t431 * t169 - 0.19e2 / 0.81e2 * t250 * t435 * t44 + t403 * t442 * t444 * t405 / 0.729e3));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t467 + 0.6e1 * t298;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t480 = t278 * sigma[0];
  t486 = t231 / t32 / t371;
  t488 = t123 * t22;
  t508 = my_piecewise3(t2, 0, t57 * t207 * t196 / 0.12e2 - t57 * t104 * t322 / 0.4e1 - 0.3e1 / 0.8e1 * t57 * t58 * params->kappa * (0.19e2 / 0.162e3 * t182 * t183 * t128 - 0.43e2 / 0.648e3 * t232 * t480 * t39 + t379 * t486 * t488 * t387 / 0.1944e4 - 0.19e2 / 0.162e3 * t190 * t183 * t139 + 0.43e2 / 0.648e3 * t250 * t480 * t44 - t403 * t486 * t488 * t405 / 0.1944e4));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t508 + 0.4e1 * t327;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t514 = t231 * t309;
  t520 = t231 / t32 / t234;
  t540 = my_piecewise3(t2, 0, -t57 * t104 * t338 / 0.8e1 - 0.3e1 / 0.8e1 * t57 * t58 * params->kappa * (t229 * t514 * t39 / 0.72e2 - t379 * t520 * t59 * t61 * t39 / 0.5184e4 - t249 * t514 * t44 / 0.72e2 + t403 * t520 * t59 * t61 * t44 / 0.5184e4));
  tv4rhosigma30 = 0.2e1 * rho[0] * t540 + 0.2e1 * t342;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t545 = t231 / t32 / t277;
  t560 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t57 * t58 * params->kappa * (t379 * t545 * t59 * t30 * t39 / 0.13824e5 - t403 * t545 * t59 * t30 * t44 / 0.13824e5));
  tv4sigma40 = 0.2e1 * rho[0] * t560;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t28, t30, t31, t32, t33;
  double t34, t35, t36, t37, t38, t39, t41, t42;
  double t45, t47, t50, t53, t57, t58, t59, t61;
  double t62, t63, t64, t66, t68, t69, t70, t71;
  double t73, t74, t77, t80, t83, t87, tzk0;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t28 = params->gamma * params->kappa;
  t30 = M_CBRT6;
  t31 = params->alpha * params->mu1 * t30;
  t32 = M_PI * M_PI;
  t33 = POW_1_3(t32);
  t34 = t33 * t33;
  t35 = 0.1e1 / t34;
  t36 = t35 * sigma[0];
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t41 = 0.1e1 / t39 / t37;
  t42 = t36 * t41;
  t45 = exp(-t31 * t42 / 0.24e2);
  t47 = params->beta * params->mu1 * t30;
  t50 = exp(-t47 * t42 / 0.24e2);
  t53 = 0.1e1 + t28 * (t45 - t50);
  t57 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t25 * t26 * t53);
  t58 = rho[1] <= p->dens_threshold;
  t59 = -t16;
  t61 = my_piecewise5(t14, t11, t10, t15, t59 * t7);
  t62 = 0.1e1 + t61;
  t63 = t62 <= p->zeta_threshold;
  t64 = POW_1_3(t62);
  t66 = my_piecewise3(t63, t22, t64 * t62);
  t68 = t35 * sigma[2];
  t69 = rho[1] * rho[1];
  t70 = POW_1_3(rho[1]);
  t71 = t70 * t70;
  t73 = 0.1e1 / t71 / t69;
  t74 = t68 * t73;
  t77 = exp(-t31 * t74 / 0.24e2);
  t80 = exp(-t47 * t74 / 0.24e2);
  t83 = 0.1e1 + t28 * (t77 - t80);
  t87 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t66 * t26 * t83);
  tzk0 = t57 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t28, t30, t31, t32, t33;
  double t34, t35, t36, t37, t38, t39, t41, t42;
  double t45, t47, t50, t53, t57, t58, t59, t61;
  double t62, t63, t64, t66, t68, t69, t70, t71;
  double t73, t74, t77, t80, t83, t87, tzk0;

  double t88, t89, t90, t92, t95, t100, t101, t105;
  double t106, t107, t108, t110, t119, t120, t124, t125;
  double t127, t130, t138, t140, tvrho0, t144, t147, t153;
  double t155, t158, t163, t164, t166, t175, t176, t180;
  double tvrho1, t183, t190, t191, t194, tvsigma0, tvsigma1, t195;
  double t202, t203, t206, tvsigma2;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t28 = params->gamma * params->kappa;
  t30 = M_CBRT6;
  t31 = params->alpha * params->mu1 * t30;
  t32 = M_PI * M_PI;
  t33 = POW_1_3(t32);
  t34 = t33 * t33;
  t35 = 0.1e1 / t34;
  t36 = t35 * sigma[0];
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t41 = 0.1e1 / t39 / t37;
  t42 = t36 * t41;
  t45 = exp(-t31 * t42 / 0.24e2);
  t47 = params->beta * params->mu1 * t30;
  t50 = exp(-t47 * t42 / 0.24e2);
  t53 = 0.1e1 + t28 * (t45 - t50);
  t57 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t25 * t26 * t53);
  t58 = rho[1] <= p->dens_threshold;
  t59 = -t16;
  t61 = my_piecewise5(t14, t11, t10, t15, t59 * t7);
  t62 = 0.1e1 + t61;
  t63 = t62 <= p->zeta_threshold;
  t64 = POW_1_3(t62);
  t66 = my_piecewise3(t63, t22, t64 * t62);
  t68 = t35 * sigma[2];
  t69 = rho[1] * rho[1];
  t70 = POW_1_3(rho[1]);
  t71 = t70 * t70;
  t73 = 0.1e1 / t71 / t69;
  t74 = t68 * t73;
  t77 = exp(-t31 * t74 / 0.24e2);
  t80 = exp(-t47 * t74 / 0.24e2);
  t83 = 0.1e1 + t28 * (t77 - t80);
  t87 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t66 * t26 * t83);
  tzk0 = t57 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t88 = t6 * t6;
  t89 = 0.1e1 / t88;
  t90 = t16 * t89;
  t92 = my_piecewise5(t10, 0, t14, 0, t7 - t90);
  t95 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92);
  t100 = t26 * t26;
  t101 = 0.1e1 / t100;
  t105 = t5 * t25 * t101 * t53 / 0.8e1;
  t106 = t5 * t25;
  t107 = t26 * params->gamma;
  t108 = t37 * rho[0];
  t110 = 0.1e1 / t39 / t108;
  t119 = params->kappa * (t31 * t36 * t110 * t45 / 0.9e1 - t47 * t36 * t110 * t50 / 0.9e1);
  t120 = t107 * t119;
  t124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t95 * t26 * t53 - t105 - 0.3e1 / 0.8e1 * t106 * t120);
  t125 = t59 * t89;
  t127 = my_piecewise5(t14, 0, t10, 0, -t7 - t125);
  t130 = my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t127);
  t138 = t5 * t66 * t101 * t83 / 0.8e1;
  t140 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t130 * t26 * t83 - t138);
  tvrho0 = t57 + t87 + t6 * (t124 + t140);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t144 = my_piecewise5(t10, 0, t14, 0, -t7 - t90);
  t147 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t144);
  t153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t147 * t26 * t53 - t105);
  t155 = my_piecewise5(t14, 0, t10, 0, t7 - t125);
  t158 = my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t155);
  t163 = t5 * t66;
  t164 = t69 * rho[1];
  t166 = 0.1e1 / t71 / t164;
  t175 = params->kappa * (t31 * t68 * t166 * t77 / 0.9e1 - t47 * t68 * t166 * t80 / 0.9e1);
  t176 = t107 * t175;
  t180 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t158 * t26 * t83 - t138 - 0.3e1 / 0.8e1 * t163 * t176);
  tvrho1 = t57 + t87 + t6 * (t153 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t183 = t35 * t41;
  t190 = params->kappa * (-t31 * t183 * t45 / 0.24e2 + t47 * t183 * t50 / 0.24e2);
  t191 = t107 * t190;
  t194 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t191);
  tvsigma0 = t6 * t194;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t195 = t35 * t73;
  t202 = params->kappa * (-t31 * t195 * t77 / 0.24e2 + t47 * t195 * t80 / 0.24e2);
  t203 = t107 * t202;
  t206 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t203);
  tvsigma2 = t6 * t206;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t28, t30, t31, t32, t33;
  double t34, t35, t36, t37, t38, t39, t41, t42;
  double t45, t47, t50, t53, t57, t58, t59, t61;
  double t62, t63, t64, t66, t68, t69, t70, t71;
  double t73, t74, t77, t80, t83, t87, tzk0;

  double t88, t89, t90, t92, t95, t100, t101, t105;
  double t106, t107, t108, t110, t119, t120, t124, t125;
  double t127, t130, t138, t140, tvrho0, t144, t147, t153;
  double t155, t158, t163, t164, t166, t175, t176, t180;
  double tvrho1, t183, t190, t191, t194, tvsigma0, tvsigma1, t195;
  double t202, t203, t206, tvsigma2;

  double t209, t210, t211, t214, t215, t216, t219, t223;
  double t230, t232, t236, t240, t241, t242, t243, t245;
  double t247, t252, t253, t255, t256, t258, t259, t260;
  double t263, t272, t274, t280, t281, t285, t286, t287;
  double t288, t291, t294, t298, t305, t310, t312, tv2rho20;
  double t315, t319, t323, t330, t332, t338, t339, t343;
  double t347, t354, t357, t360, t361, t364, tv2rho21, t369;
  double t374, t378, t385, t386, t391, t395, t401, t405;
  double t407, t412, t413, t416, t430, t431, t435, tv2rho22;
  double t440, t442, t443, t447, t450, t451, t458, t463;
  double t464, t468, tv2rhosigma0, tv2rhosigma1, t472, t474, t476, tv2rhosigma2;
  double t481, tv2rhosigma3, tv2rhosigma4, t485, t489, t492, t493, t500;
  double t505, t506, t510, tv2rhosigma5, t512, t515, t522, t523;
  double t526, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t527, t530;
  double t537, t538, t541, tv2sigma25;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t28 = params->gamma * params->kappa;
  t30 = M_CBRT6;
  t31 = params->alpha * params->mu1 * t30;
  t32 = M_PI * M_PI;
  t33 = POW_1_3(t32);
  t34 = t33 * t33;
  t35 = 0.1e1 / t34;
  t36 = t35 * sigma[0];
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t41 = 0.1e1 / t39 / t37;
  t42 = t36 * t41;
  t45 = exp(-t31 * t42 / 0.24e2);
  t47 = params->beta * params->mu1 * t30;
  t50 = exp(-t47 * t42 / 0.24e2);
  t53 = 0.1e1 + t28 * (t45 - t50);
  t57 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t25 * t26 * t53);
  t58 = rho[1] <= p->dens_threshold;
  t59 = -t16;
  t61 = my_piecewise5(t14, t11, t10, t15, t59 * t7);
  t62 = 0.1e1 + t61;
  t63 = t62 <= p->zeta_threshold;
  t64 = POW_1_3(t62);
  t66 = my_piecewise3(t63, t22, t64 * t62);
  t68 = t35 * sigma[2];
  t69 = rho[1] * rho[1];
  t70 = POW_1_3(rho[1]);
  t71 = t70 * t70;
  t73 = 0.1e1 / t71 / t69;
  t74 = t68 * t73;
  t77 = exp(-t31 * t74 / 0.24e2);
  t80 = exp(-t47 * t74 / 0.24e2);
  t83 = 0.1e1 + t28 * (t77 - t80);
  t87 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t66 * t26 * t83);
  tzk0 = t57 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t88 = t6 * t6;
  t89 = 0.1e1 / t88;
  t90 = t16 * t89;
  t92 = my_piecewise5(t10, 0, t14, 0, t7 - t90);
  t95 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92);
  t100 = t26 * t26;
  t101 = 0.1e1 / t100;
  t105 = t5 * t25 * t101 * t53 / 0.8e1;
  t106 = t5 * t25;
  t107 = t26 * params->gamma;
  t108 = t37 * rho[0];
  t110 = 0.1e1 / t39 / t108;
  t119 = params->kappa * (t31 * t36 * t110 * t45 / 0.9e1 - t47 * t36 * t110 * t50 / 0.9e1);
  t120 = t107 * t119;
  t124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t95 * t26 * t53 - t105 - 0.3e1 / 0.8e1 * t106 * t120);
  t125 = t59 * t89;
  t127 = my_piecewise5(t14, 0, t10, 0, -t7 - t125);
  t130 = my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t127);
  t138 = t5 * t66 * t101 * t83 / 0.8e1;
  t140 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t130 * t26 * t83 - t138);
  tvrho0 = t57 + t87 + t6 * (t124 + t140);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t144 = my_piecewise5(t10, 0, t14, 0, -t7 - t90);
  t147 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t144);
  t153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t147 * t26 * t53 - t105);
  t155 = my_piecewise5(t14, 0, t10, 0, t7 - t125);
  t158 = my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t155);
  t163 = t5 * t66;
  t164 = t69 * rho[1];
  t166 = 0.1e1 / t71 / t164;
  t175 = params->kappa * (t31 * t68 * t166 * t77 / 0.9e1 - t47 * t68 * t166 * t80 / 0.9e1);
  t176 = t107 * t175;
  t180 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t158 * t26 * t83 - t138 - 0.3e1 / 0.8e1 * t163 * t176);
  tvrho1 = t57 + t87 + t6 * (t153 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t183 = t35 * t41;
  t190 = params->kappa * (-t31 * t183 * t45 / 0.24e2 + t47 * t183 * t50 / 0.24e2);
  t191 = t107 * t190;
  t194 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t191);
  tvsigma0 = t6 * t194;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t195 = t35 * t73;
  t202 = params->kappa * (-t31 * t195 * t77 / 0.24e2 + t47 * t195 * t80 / 0.24e2);
  t203 = t107 * t202;
  t206 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t203);
  tvsigma2 = t6 * t206;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t209 = t23 * t23;
  t210 = 0.1e1 / t209;
  t211 = t92 * t92;
  t214 = t88 * t6;
  t215 = 0.1e1 / t214;
  t216 = t16 * t215;
  t219 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t89 + 0.2e1 * t216);
  t223 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t210 * t211 + 0.4e1 / 0.3e1 * t23 * t219);
  t230 = t5 * t95 * t101 * t53;
  t232 = t5 * t95;
  t236 = 0.1e1 / t100 / t6;
  t240 = t5 * t25 * t236 * t53 / 0.12e2;
  t241 = t101 * params->gamma;
  t242 = t241 * t119;
  t243 = t106 * t242;
  t245 = t37 * t37;
  t247 = 0.1e1 / t39 / t245;
  t252 = params->alpha * params->alpha;
  t253 = params->mu1 * params->mu1;
  t255 = t30 * t30;
  t256 = t252 * t253 * t255;
  t258 = 0.1e1 / t33 / t32;
  t259 = sigma[0] * sigma[0];
  t260 = t258 * t259;
  t263 = 0.1e1 / t38 / t245 / t108;
  t272 = params->beta * params->beta;
  t274 = t272 * t253 * t255;
  t280 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t36 * t247 * t45 + t256 * t260 * t263 * t45 / 0.81e2 + 0.11e2 / 0.27e2 * t47 * t36 * t247 * t50 - t274 * t260 * t263 * t50 / 0.81e2);
  t281 = t107 * t280;
  t285 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t223 * t26 * t53 - t230 / 0.4e1 - 0.3e1 / 0.4e1 * t232 * t120 + t240 - t243 / 0.4e1 - 0.3e1 / 0.8e1 * t106 * t281);
  t286 = t64 * t64;
  t287 = 0.1e1 / t286;
  t288 = t127 * t127;
  t291 = t59 * t215;
  t294 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t89 + 0.2e1 * t291);
  t298 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t287 * t288 + 0.4e1 / 0.3e1 * t64 * t294);
  t305 = t5 * t130 * t101 * t83;
  t310 = t5 * t66 * t236 * t83 / 0.12e2;
  t312 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t298 * t26 * t83 - t305 / 0.4e1 + t310);
  tv2rho20 = 0.2e1 * t124 + 0.2e1 * t140 + t6 * (t285 + t312);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t315 = t210 * t144;
  t319 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t216);
  t323 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t315 * t92 + 0.4e1 / 0.3e1 * t23 * t319);
  t330 = t5 * t147 * t101 * t53;
  t332 = t5 * t147;
  t338 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t323 * t26 * t53 - t330 / 0.8e1 - 0.3e1 / 0.8e1 * t332 * t120 - t230 / 0.8e1 + t240 - t243 / 0.8e1);
  t339 = t287 * t155;
  t343 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t291);
  t347 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t339 * t127 + 0.4e1 / 0.3e1 * t64 * t343);
  t354 = t5 * t158 * t101 * t83;
  t357 = t5 * t130;
  t360 = t241 * t175;
  t361 = t163 * t360;
  t364 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t347 * t26 * t83 - t354 / 0.8e1 - t305 / 0.8e1 + t310 - 0.3e1 / 0.8e1 * t357 * t176 - t361 / 0.8e1);
  tv2rho21 = t124 + t140 + t153 + t180 + t6 * (t338 + t364);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t369 = t144 * t144;
  t374 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t89 + 0.2e1 * t216);
  t378 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t210 * t369 + 0.4e1 / 0.3e1 * t23 * t374);
  t385 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t378 * t26 * t53 - t330 / 0.4e1 + t240);
  t386 = t155 * t155;
  t391 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t89 + 0.2e1 * t291);
  t395 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t287 * t386 + 0.4e1 / 0.3e1 * t64 * t391);
  t401 = t5 * t158;
  t405 = t69 * t69;
  t407 = 0.1e1 / t71 / t405;
  t412 = sigma[2] * sigma[2];
  t413 = t258 * t412;
  t416 = 0.1e1 / t70 / t405 / t164;
  t430 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t68 * t407 * t77 + t256 * t413 * t416 * t77 / 0.81e2 + 0.11e2 / 0.27e2 * t47 * t68 * t407 * t80 - t274 * t413 * t416 * t80 / 0.81e2);
  t431 = t107 * t430;
  t435 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t395 * t26 * t83 - t354 / 0.4e1 - 0.3e1 / 0.4e1 * t401 * t176 + t310 - t361 / 0.4e1 - 0.3e1 / 0.8e1 * t163 * t431);
  tv2rho22 = 0.2e1 * t153 + 0.2e1 * t180 + t6 * (t385 + t435);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t440 = t241 * t190;
  t442 = t106 * t440 / 0.8e1;
  t443 = t35 * t110;
  t447 = t245 * t37;
  t450 = t258 / t38 / t447;
  t451 = sigma[0] * t45;
  t458 = sigma[0] * t50;
  t463 = params->kappa * (t31 * t443 * t45 / 0.9e1 - t256 * t450 * t451 / 0.216e3 - t47 * t443 * t50 / 0.9e1 + t274 * t450 * t458 / 0.216e3);
  t464 = t107 * t463;
  t468 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t232 * t191 - t442 - 0.3e1 / 0.8e1 * t106 * t464);
  tv2rhosigma0 = t6 * t468 + t194;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t472 = t241 * t202;
  t474 = t163 * t472 / 0.8e1;
  t476 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t357 * t203 - t474);
  tv2rhosigma2 = t6 * t476 + t206;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t481 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t332 * t191 - t442);
  tv2rhosigma3 = t6 * t481 + t194;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t485 = t35 * t166;
  t489 = t405 * t69;
  t492 = t258 / t70 / t489;
  t493 = sigma[2] * t77;
  t500 = sigma[2] * t80;
  t505 = params->kappa * (t31 * t485 * t77 / 0.9e1 - t256 * t492 * t493 / 0.216e3 - t47 * t485 * t80 / 0.9e1 + t274 * t492 * t500 / 0.216e3);
  t506 = t107 * t505;
  t510 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t401 * t203 - t474 - 0.3e1 / 0.8e1 * t163 * t506);
  tv2rhosigma5 = t6 * t510 + t206;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t512 = t245 * rho[0];
  t515 = t258 / t38 / t512;
  t522 = params->kappa * (t256 * t515 * t45 / 0.576e3 - t274 * t515 * t50 / 0.576e3);
  t523 = t107 * t522;
  t526 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t523);
  tv2sigma20 = t6 * t526;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t527 = t405 * rho[1];
  t530 = t258 / t70 / t527;
  t537 = params->kappa * (t256 * t530 * t77 / 0.576e3 - t274 * t530 * t80 / 0.576e3);
  t538 = t107 * t537;
  t541 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t538);
  tv2sigma25 = t6 * t541;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t28, t30, t31, t32, t33;
  double t34, t35, t36, t37, t38, t39, t41, t42;
  double t45, t47, t50, t53, t57, t58, t59, t61;
  double t62, t63, t64, t66, t68, t69, t70, t71;
  double t73, t74, t77, t80, t83, t87, tzk0;

  double t88, t89, t90, t92, t95, t100, t101, t105;
  double t106, t107, t108, t110, t119, t120, t124, t125;
  double t127, t130, t138, t140, tvrho0, t144, t147, t153;
  double t155, t158, t163, t164, t166, t175, t176, t180;
  double tvrho1, t183, t190, t191, t194, tvsigma0, tvsigma1, t195;
  double t202, t203, t206, tvsigma2;

  double t209, t210, t211, t214, t215, t216, t219, t223;
  double t230, t232, t236, t240, t241, t242, t243, t245;
  double t247, t252, t253, t255, t256, t258, t259, t260;
  double t263, t272, t274, t280, t281, t285, t286, t287;
  double t288, t291, t294, t298, t305, t310, t312, tv2rho20;
  double t315, t319, t323, t330, t332, t338, t339, t343;
  double t347, t354, t357, t360, t361, t364, tv2rho21, t369;
  double t374, t378, t385, t386, t391, t395, t401, t405;
  double t407, t412, t413, t416, t430, t431, t435, tv2rho22;
  double t440, t442, t443, t447, t450, t451, t458, t463;
  double t464, t468, tv2rhosigma0, tv2rhosigma1, t472, t474, t476, tv2rhosigma2;
  double t481, tv2rhosigma3, tv2rhosigma4, t485, t489, t492, t493, t500;
  double t505, t506, t510, tv2rhosigma5, t512, t515, t522, t523;
  double t526, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t527, t530;
  double t537, t538, t541, tv2sigma25;

  double t545, t546, t549, t552, t553, t554, t557, t561;
  double t568, t570, t575, t577, t582, t586, t587, t588;
  double t589, t591, t592, t595, t600, t602, t608, t609;
  double t610, t611, t612, t613, t614, t615, t616, t629;
  double t630, t635, t636, t640, t642, t643, t646, t649;
  double t652, t656, t663, t667, t672, t674, tv3rho30, t677;
  double t678, t679, t682, t687, t688, t690, t694, t702;
  double t703, t708, t711, t719, t720, t721, t724, t729;
  double t731, t735, t743, t746, t750, t754, t755, t756;
  double t759, tv3rho31, t762, t767, t771, t775, t782, t784;
  double t791, t792, t797, t801, t805, t812, t815, t818;
  double t824, t825, t827, t828, tv3rho32, t833, t840, t844;
  double t852, t853, t860, t864, t870, t880, t885, t887;
  double t892, t893, t894, t895, t911, t912, t916, tv3rho33;
  double t922, t926, t928, t929, t930, t932, t936, t940;
  double t941, t942, t956, t957, t961, tv3rho2sigma0, tv3rho2sigma1, t966;
  double t968, t970, t972, tv3rho2sigma2, t976, t983, tv3rho2sigma3, tv3rho2sigma4;
  double t987, t992, t993, t996, tv3rho2sigma5, t1003, tv3rho2sigma6, tv3rho2sigma7;
  double t1012, t1016, t1020, t1021, t1022, t1036, t1037, t1041;
  double tv3rho2sigma8, t1045, t1047, t1051, t1052, t1053, t1064, t1065;
  double t1069, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1073, t1075;
  double t1077, tv3rhosigma25, t1082, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t1089, t1090, t1091, t1102, t1103, t1107, tv3rhosigma211, t1110;
  double t1117, t1118, t1121, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1123, t1130, t1131, t1134;
  double tv3sigma39;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t28 = params->gamma * params->kappa;
  t30 = M_CBRT6;
  t31 = params->alpha * params->mu1 * t30;
  t32 = M_PI * M_PI;
  t33 = POW_1_3(t32);
  t34 = t33 * t33;
  t35 = 0.1e1 / t34;
  t36 = t35 * sigma[0];
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t41 = 0.1e1 / t39 / t37;
  t42 = t36 * t41;
  t45 = exp(-t31 * t42 / 0.24e2);
  t47 = params->beta * params->mu1 * t30;
  t50 = exp(-t47 * t42 / 0.24e2);
  t53 = 0.1e1 + t28 * (t45 - t50);
  t57 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t25 * t26 * t53);
  t58 = rho[1] <= p->dens_threshold;
  t59 = -t16;
  t61 = my_piecewise5(t14, t11, t10, t15, t59 * t7);
  t62 = 0.1e1 + t61;
  t63 = t62 <= p->zeta_threshold;
  t64 = POW_1_3(t62);
  t66 = my_piecewise3(t63, t22, t64 * t62);
  t68 = t35 * sigma[2];
  t69 = rho[1] * rho[1];
  t70 = POW_1_3(rho[1]);
  t71 = t70 * t70;
  t73 = 0.1e1 / t71 / t69;
  t74 = t68 * t73;
  t77 = exp(-t31 * t74 / 0.24e2);
  t80 = exp(-t47 * t74 / 0.24e2);
  t83 = 0.1e1 + t28 * (t77 - t80);
  t87 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t66 * t26 * t83);
  tzk0 = t57 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t88 = t6 * t6;
  t89 = 0.1e1 / t88;
  t90 = t16 * t89;
  t92 = my_piecewise5(t10, 0, t14, 0, t7 - t90);
  t95 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92);
  t100 = t26 * t26;
  t101 = 0.1e1 / t100;
  t105 = t5 * t25 * t101 * t53 / 0.8e1;
  t106 = t5 * t25;
  t107 = t26 * params->gamma;
  t108 = t37 * rho[0];
  t110 = 0.1e1 / t39 / t108;
  t119 = params->kappa * (t31 * t36 * t110 * t45 / 0.9e1 - t47 * t36 * t110 * t50 / 0.9e1);
  t120 = t107 * t119;
  t124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t95 * t26 * t53 - t105 - 0.3e1 / 0.8e1 * t106 * t120);
  t125 = t59 * t89;
  t127 = my_piecewise5(t14, 0, t10, 0, -t7 - t125);
  t130 = my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t127);
  t138 = t5 * t66 * t101 * t83 / 0.8e1;
  t140 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t130 * t26 * t83 - t138);
  tvrho0 = t57 + t87 + t6 * (t124 + t140);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t144 = my_piecewise5(t10, 0, t14, 0, -t7 - t90);
  t147 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t144);
  t153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t147 * t26 * t53 - t105);
  t155 = my_piecewise5(t14, 0, t10, 0, t7 - t125);
  t158 = my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t155);
  t163 = t5 * t66;
  t164 = t69 * rho[1];
  t166 = 0.1e1 / t71 / t164;
  t175 = params->kappa * (t31 * t68 * t166 * t77 / 0.9e1 - t47 * t68 * t166 * t80 / 0.9e1);
  t176 = t107 * t175;
  t180 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t158 * t26 * t83 - t138 - 0.3e1 / 0.8e1 * t163 * t176);
  tvrho1 = t57 + t87 + t6 * (t153 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t183 = t35 * t41;
  t190 = params->kappa * (-t31 * t183 * t45 / 0.24e2 + t47 * t183 * t50 / 0.24e2);
  t191 = t107 * t190;
  t194 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t191);
  tvsigma0 = t6 * t194;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t195 = t35 * t73;
  t202 = params->kappa * (-t31 * t195 * t77 / 0.24e2 + t47 * t195 * t80 / 0.24e2);
  t203 = t107 * t202;
  t206 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t203);
  tvsigma2 = t6 * t206;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t209 = t23 * t23;
  t210 = 0.1e1 / t209;
  t211 = t92 * t92;
  t214 = t88 * t6;
  t215 = 0.1e1 / t214;
  t216 = t16 * t215;
  t219 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t89 + 0.2e1 * t216);
  t223 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t210 * t211 + 0.4e1 / 0.3e1 * t23 * t219);
  t230 = t5 * t95 * t101 * t53;
  t232 = t5 * t95;
  t236 = 0.1e1 / t100 / t6;
  t240 = t5 * t25 * t236 * t53 / 0.12e2;
  t241 = t101 * params->gamma;
  t242 = t241 * t119;
  t243 = t106 * t242;
  t245 = t37 * t37;
  t247 = 0.1e1 / t39 / t245;
  t252 = params->alpha * params->alpha;
  t253 = params->mu1 * params->mu1;
  t255 = t30 * t30;
  t256 = t252 * t253 * t255;
  t258 = 0.1e1 / t33 / t32;
  t259 = sigma[0] * sigma[0];
  t260 = t258 * t259;
  t263 = 0.1e1 / t38 / t245 / t108;
  t272 = params->beta * params->beta;
  t274 = t272 * t253 * t255;
  t280 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t36 * t247 * t45 + t256 * t260 * t263 * t45 / 0.81e2 + 0.11e2 / 0.27e2 * t47 * t36 * t247 * t50 - t274 * t260 * t263 * t50 / 0.81e2);
  t281 = t107 * t280;
  t285 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t223 * t26 * t53 - t230 / 0.4e1 - 0.3e1 / 0.4e1 * t232 * t120 + t240 - t243 / 0.4e1 - 0.3e1 / 0.8e1 * t106 * t281);
  t286 = t64 * t64;
  t287 = 0.1e1 / t286;
  t288 = t127 * t127;
  t291 = t59 * t215;
  t294 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t89 + 0.2e1 * t291);
  t298 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t287 * t288 + 0.4e1 / 0.3e1 * t64 * t294);
  t305 = t5 * t130 * t101 * t83;
  t310 = t5 * t66 * t236 * t83 / 0.12e2;
  t312 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t298 * t26 * t83 - t305 / 0.4e1 + t310);
  tv2rho20 = 0.2e1 * t124 + 0.2e1 * t140 + t6 * (t285 + t312);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t315 = t210 * t144;
  t319 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t216);
  t323 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t315 * t92 + 0.4e1 / 0.3e1 * t23 * t319);
  t330 = t5 * t147 * t101 * t53;
  t332 = t5 * t147;
  t338 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t323 * t26 * t53 - t330 / 0.8e1 - 0.3e1 / 0.8e1 * t332 * t120 - t230 / 0.8e1 + t240 - t243 / 0.8e1);
  t339 = t287 * t155;
  t343 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t291);
  t347 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t339 * t127 + 0.4e1 / 0.3e1 * t64 * t343);
  t354 = t5 * t158 * t101 * t83;
  t357 = t5 * t130;
  t360 = t241 * t175;
  t361 = t163 * t360;
  t364 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t347 * t26 * t83 - t354 / 0.8e1 - t305 / 0.8e1 + t310 - 0.3e1 / 0.8e1 * t357 * t176 - t361 / 0.8e1);
  tv2rho21 = t124 + t140 + t153 + t180 + t6 * (t338 + t364);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t369 = t144 * t144;
  t374 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t89 + 0.2e1 * t216);
  t378 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t210 * t369 + 0.4e1 / 0.3e1 * t23 * t374);
  t385 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t378 * t26 * t53 - t330 / 0.4e1 + t240);
  t386 = t155 * t155;
  t391 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t89 + 0.2e1 * t291);
  t395 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t287 * t386 + 0.4e1 / 0.3e1 * t64 * t391);
  t401 = t5 * t158;
  t405 = t69 * t69;
  t407 = 0.1e1 / t71 / t405;
  t412 = sigma[2] * sigma[2];
  t413 = t258 * t412;
  t416 = 0.1e1 / t70 / t405 / t164;
  t430 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t68 * t407 * t77 + t256 * t413 * t416 * t77 / 0.81e2 + 0.11e2 / 0.27e2 * t47 * t68 * t407 * t80 - t274 * t413 * t416 * t80 / 0.81e2);
  t431 = t107 * t430;
  t435 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t395 * t26 * t83 - t354 / 0.4e1 - 0.3e1 / 0.4e1 * t401 * t176 + t310 - t361 / 0.4e1 - 0.3e1 / 0.8e1 * t163 * t431);
  tv2rho22 = 0.2e1 * t153 + 0.2e1 * t180 + t6 * (t385 + t435);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t440 = t241 * t190;
  t442 = t106 * t440 / 0.8e1;
  t443 = t35 * t110;
  t447 = t245 * t37;
  t450 = t258 / t38 / t447;
  t451 = sigma[0] * t45;
  t458 = sigma[0] * t50;
  t463 = params->kappa * (t31 * t443 * t45 / 0.9e1 - t256 * t450 * t451 / 0.216e3 - t47 * t443 * t50 / 0.9e1 + t274 * t450 * t458 / 0.216e3);
  t464 = t107 * t463;
  t468 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t232 * t191 - t442 - 0.3e1 / 0.8e1 * t106 * t464);
  tv2rhosigma0 = t6 * t468 + t194;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t472 = t241 * t202;
  t474 = t163 * t472 / 0.8e1;
  t476 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t357 * t203 - t474);
  tv2rhosigma2 = t6 * t476 + t206;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t481 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t332 * t191 - t442);
  tv2rhosigma3 = t6 * t481 + t194;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t485 = t35 * t166;
  t489 = t405 * t69;
  t492 = t258 / t70 / t489;
  t493 = sigma[2] * t77;
  t500 = sigma[2] * t80;
  t505 = params->kappa * (t31 * t485 * t77 / 0.9e1 - t256 * t492 * t493 / 0.216e3 - t47 * t485 * t80 / 0.9e1 + t274 * t492 * t500 / 0.216e3);
  t506 = t107 * t505;
  t510 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t401 * t203 - t474 - 0.3e1 / 0.8e1 * t163 * t506);
  tv2rhosigma5 = t6 * t510 + t206;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t512 = t245 * rho[0];
  t515 = t258 / t38 / t512;
  t522 = params->kappa * (t256 * t515 * t45 / 0.576e3 - t274 * t515 * t50 / 0.576e3);
  t523 = t107 * t522;
  t526 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t523);
  tv2sigma20 = t6 * t526;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t527 = t405 * rho[1];
  t530 = t258 / t70 / t527;
  t537 = params->kappa * (t256 * t530 * t77 / 0.576e3 - t274 * t530 * t80 / 0.576e3);
  t538 = t107 * t537;
  t541 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t538);
  tv2sigma25 = t6 * t541;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t545 = 0.1e1 / t209 / t19;
  t546 = t211 * t92;
  t549 = t210 * t92;
  t552 = t88 * t88;
  t553 = 0.1e1 / t552;
  t554 = t16 * t553;
  t557 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t215 - 0.6e1 * t554);
  t561 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t545 * t546 + 0.4e1 / 0.3e1 * t549 * t219 + 0.4e1 / 0.3e1 * t23 * t557);
  t568 = t5 * t223 * t101 * t53;
  t570 = t5 * t223;
  t575 = t5 * t95 * t236 * t53;
  t577 = t232 * t242;
  t582 = 0.1e1 / t100 / t88;
  t586 = 0.5e1 / 0.36e2 * t5 * t25 * t582 * t53;
  t587 = t236 * params->gamma;
  t588 = t587 * t119;
  t589 = t106 * t588;
  t591 = t241 * t280;
  t592 = t106 * t591;
  t595 = 0.1e1 / t39 / t512;
  t600 = t245 * t245;
  t602 = 0.1e1 / t38 / t600;
  t608 = t253 * params->mu1;
  t609 = t252 * params->alpha * t608;
  t610 = t32 * t32;
  t611 = 0.1e1 / t610;
  t612 = t609 * t611;
  t613 = t259 * sigma[0];
  t614 = t600 * t108;
  t615 = 0.1e1 / t614;
  t616 = t613 * t615;
  t629 = t272 * params->beta * t608;
  t630 = t629 * t611;
  t635 = params->kappa * (0.154e3 / 0.81e2 * t31 * t36 * t595 * t45 - 0.11e2 / 0.81e2 * t256 * t260 * t602 * t45 + 0.2e1 / 0.243e3 * t612 * t616 * t45 - 0.154e3 / 0.81e2 * t47 * t36 * t595 * t50 + 0.11e2 / 0.81e2 * t274 * t260 * t602 * t50 - 0.2e1 / 0.243e3 * t630 * t616 * t50);
  t636 = t107 * t635;
  t640 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t561 * t26 * t53 - 0.3e1 / 0.8e1 * t568 - 0.9e1 / 0.8e1 * t570 * t120 + t575 / 0.4e1 - 0.3e1 / 0.4e1 * t577 - 0.9e1 / 0.8e1 * t232 * t281 - t586 + t589 / 0.4e1 - 0.3e1 / 0.8e1 * t592 - 0.3e1 / 0.8e1 * t106 * t636);
  t642 = 0.1e1 / t286 / t62;
  t643 = t288 * t127;
  t646 = t287 * t127;
  t649 = t59 * t553;
  t652 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t215 - 0.6e1 * t649);
  t656 = my_piecewise3(t63, 0, -0.8e1 / 0.27e2 * t642 * t643 + 0.4e1 / 0.3e1 * t646 * t294 + 0.4e1 / 0.3e1 * t64 * t652);
  t663 = t5 * t298 * t101 * t83;
  t667 = t5 * t130 * t236 * t83;
  t672 = 0.5e1 / 0.36e2 * t5 * t66 * t582 * t83;
  t674 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t656 * t26 * t83 - 0.3e1 / 0.8e1 * t663 + t667 / 0.4e1 - t672);
  tv3rho30 = 0.3e1 * t285 + 0.3e1 * t312 + t6 * (t640 + t674);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t677 = 0.2e1 * t338;
  t678 = 0.2e1 * t364;
  t679 = t545 * t144;
  t682 = t210 * t319;
  t687 = 0.2e1 * t215;
  t688 = 0.6e1 * t554;
  t690 = my_piecewise5(t10, 0, t14, 0, t687 - t688);
  t694 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t679 * t211 + 0.8e1 / 0.9e1 * t682 * t92 + 0.4e1 / 0.9e1 * t315 * t219 + 0.4e1 / 0.3e1 * t23 * t690);
  t702 = t5 * t323 * t101 * t53 / 0.4e1;
  t703 = t5 * t323;
  t708 = t5 * t147 * t236 * t53;
  t711 = t332 * t242 / 0.4e1;
  t719 = -0.3e1 / 0.8e1 * t5 * t694 * t26 * t53 - t702 - 0.3e1 / 0.4e1 * t703 * t120 + t708 / 0.12e2 - t711 - 0.3e1 / 0.8e1 * t332 * t281 - t568 / 0.8e1 + t575 / 0.6e1 - t577 / 0.4e1 - t586 + t589 / 0.6e1 - t592 / 0.8e1;
  t720 = my_piecewise3(t1, 0, t719);
  t721 = t642 * t155;
  t724 = t287 * t343;
  t729 = 0.6e1 * t649;
  t731 = my_piecewise5(t14, 0, t10, 0, -t687 - t729);
  t735 = my_piecewise3(t63, 0, -0.8e1 / 0.27e2 * t721 * t288 + 0.8e1 / 0.9e1 * t724 * t127 + 0.4e1 / 0.9e1 * t339 * t294 + 0.4e1 / 0.3e1 * t64 * t731);
  t743 = t5 * t347 * t101 * t83 / 0.4e1;
  t746 = t5 * t158 * t236 * t83;
  t750 = t5 * t298;
  t754 = t357 * t360 / 0.4e1;
  t755 = t587 * t175;
  t756 = t163 * t755;
  t759 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t735 * t26 * t83 - t743 + t746 / 0.12e2 - t663 / 0.8e1 + t667 / 0.6e1 - t672 - 0.3e1 / 0.8e1 * t750 * t176 - t754 + t756 / 0.12e2);
  tv3rho31 = t285 + t312 + t677 + t678 + t6 * (t720 + t759);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t762 = t545 * t369;
  t767 = t210 * t374;
  t771 = my_piecewise5(t10, 0, t14, 0, -t687 - t688);
  t775 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t762 * t92 + 0.8e1 / 0.9e1 * t315 * t319 + 0.4e1 / 0.9e1 * t767 * t92 + 0.4e1 / 0.3e1 * t23 * t771);
  t782 = t5 * t378 * t101 * t53;
  t784 = t5 * t378;
  t791 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t775 * t26 * t53 - t782 / 0.8e1 - 0.3e1 / 0.8e1 * t784 * t120 - t702 + t708 / 0.6e1 - t711 + t575 / 0.12e2 - t586 + t589 / 0.12e2);
  t792 = t642 * t386;
  t797 = t287 * t391;
  t801 = my_piecewise5(t14, 0, t10, 0, t687 - t729);
  t805 = my_piecewise3(t63, 0, -0.8e1 / 0.27e2 * t792 * t127 + 0.8e1 / 0.9e1 * t339 * t343 + 0.4e1 / 0.9e1 * t797 * t127 + 0.4e1 / 0.3e1 * t64 * t801);
  t812 = t5 * t395 * t101 * t83;
  t815 = t5 * t347;
  t818 = t401 * t360;
  t824 = t241 * t430;
  t825 = t163 * t824;
  t827 = -0.3e1 / 0.8e1 * t5 * t805 * t26 * t83 - t812 / 0.8e1 - t743 + t746 / 0.6e1 - 0.3e1 / 0.4e1 * t815 * t176 - t818 / 0.4e1 + t667 / 0.12e2 - t672 - t754 + t756 / 0.6e1 - 0.3e1 / 0.8e1 * t357 * t431 - t825 / 0.8e1;
  t828 = my_piecewise3(t58, 0, t827);
  tv3rho32 = t677 + t678 + t385 + t435 + t6 * (t791 + t828);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t833 = t369 * t144;
  t840 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t215 - 0.6e1 * t554);
  t844 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t545 * t833 + 0.4e1 / 0.3e1 * t315 * t374 + 0.4e1 / 0.3e1 * t23 * t840);
  t852 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t844 * t26 * t53 - 0.3e1 / 0.8e1 * t782 + t708 / 0.4e1 - t586);
  t853 = t386 * t155;
  t860 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t215 - 0.6e1 * t649);
  t864 = my_piecewise3(t63, 0, -0.8e1 / 0.27e2 * t642 * t853 + 0.4e1 / 0.3e1 * t339 * t391 + 0.4e1 / 0.3e1 * t64 * t860);
  t870 = t5 * t395;
  t880 = 0.1e1 / t71 / t527;
  t885 = t405 * t405;
  t887 = 0.1e1 / t70 / t885;
  t892 = t412 * sigma[2];
  t893 = t885 * t164;
  t894 = 0.1e1 / t893;
  t895 = t892 * t894;
  t911 = params->kappa * (0.154e3 / 0.81e2 * t31 * t68 * t880 * t77 - 0.11e2 / 0.81e2 * t256 * t413 * t887 * t77 + 0.2e1 / 0.243e3 * t612 * t895 * t77 - 0.154e3 / 0.81e2 * t47 * t68 * t880 * t80 + 0.11e2 / 0.81e2 * t274 * t413 * t887 * t80 - 0.2e1 / 0.243e3 * t630 * t895 * t80);
  t912 = t107 * t911;
  t916 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t864 * t26 * t83 - 0.3e1 / 0.8e1 * t812 - 0.9e1 / 0.8e1 * t870 * t176 + t746 / 0.4e1 - 0.3e1 / 0.4e1 * t818 - 0.9e1 / 0.8e1 * t401 * t431 - t672 + t756 / 0.4e1 - 0.3e1 / 0.8e1 * t825 - 0.3e1 / 0.8e1 * t163 * t912);
  tv3rho33 = 0.3e1 * t385 + 0.3e1 * t435 + t6 * (t852 + t916);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t922 = t232 * t440;
  t926 = t587 * t190;
  t928 = t106 * t926 / 0.12e2;
  t929 = t241 * t463;
  t930 = t106 * t929;
  t932 = t35 * t247;
  t936 = t258 * t263;
  t940 = t600 * t37;
  t941 = 0.1e1 / t940;
  t942 = t941 * t259;
  t956 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t932 * t45 + t256 * t936 * t451 / 0.24e2 - t612 * t942 * t45 / 0.324e3 + 0.11e2 / 0.27e2 * t47 * t932 * t50 - t274 * t936 * t458 / 0.24e2 + t630 * t942 * t50 / 0.324e3);
  t957 = t107 * t956;
  t961 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t570 * t191 - t922 / 0.4e1 - 0.3e1 / 0.4e1 * t232 * t464 + t928 - t930 / 0.4e1 - 0.3e1 / 0.8e1 * t106 * t957);
  tv3rho2sigma0 = t6 * t961 + 0.2e1 * t468;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t966 = t357 * t472;
  t968 = t587 * t202;
  t970 = t163 * t968 / 0.12e2;
  t972 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t750 * t203 - t966 / 0.4e1 + t970);
  tv3rho2sigma2 = t6 * t972 + 0.2e1 * t476;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t976 = t332 * t440;
  t983 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t703 * t191 - t976 / 0.8e1 - 0.3e1 / 0.8e1 * t332 * t464 - t922 / 0.8e1 + t928 - t930 / 0.8e1);
  tv3rho2sigma3 = t6 * t983 + t468 + t481;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t987 = t401 * t472;
  t992 = t241 * t505;
  t993 = t163 * t992;
  t996 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t815 * t203 - t987 / 0.8e1 - t966 / 0.8e1 + t970 - 0.3e1 / 0.8e1 * t357 * t506 - t993 / 0.8e1);
  tv3rho2sigma5 = t6 * t996 + t476 + t510;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1003 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t784 * t191 - t976 / 0.4e1 + t928);
  tv3rho2sigma6 = t6 * t1003 + 0.2e1 * t481;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1012 = t35 * t407;
  t1016 = t258 * t416;
  t1020 = t885 * t69;
  t1021 = 0.1e1 / t1020;
  t1022 = t1021 * t412;
  t1036 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t1012 * t77 + t256 * t1016 * t493 / 0.24e2 - t612 * t1022 * t77 / 0.324e3 + 0.11e2 / 0.27e2 * t47 * t1012 * t80 - t274 * t1016 * t500 / 0.24e2 + t630 * t1022 * t80 / 0.324e3);
  t1037 = t107 * t1036;
  t1041 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t870 * t203 - t987 / 0.4e1 - 0.3e1 / 0.4e1 * t401 * t506 + t970 - t993 / 0.4e1 - 0.3e1 / 0.8e1 * t163 * t1037);
  tv3rho2sigma8 = t6 * t1041 + 0.2e1 * t510;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1045 = t241 * t522;
  t1047 = t106 * t1045 / 0.8e1;
  t1051 = t600 * rho[0];
  t1052 = 0.1e1 / t1051;
  t1053 = t1052 * sigma[0];
  t1064 = params->kappa * (-t256 * t450 * t45 / 0.108e3 + t612 * t1053 * t45 / 0.864e3 + t274 * t450 * t50 / 0.108e3 - t630 * t1053 * t50 / 0.864e3);
  t1065 = t107 * t1064;
  t1069 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t232 * t523 - t1047 - 0.3e1 / 0.8e1 * t106 * t1065);
  tv3rhosigma20 = t6 * t1069 + t526;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1073 = t241 * t537;
  t1075 = t163 * t1073 / 0.8e1;
  t1077 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t357 * t538 - t1075);
  tv3rhosigma25 = t6 * t1077 + t541;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1082 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t332 * t523 - t1047);
  tv3rhosigma26 = t6 * t1082 + t526;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1089 = t885 * rho[1];
  t1090 = 0.1e1 / t1089;
  t1091 = t1090 * sigma[2];
  t1102 = params->kappa * (-t256 * t492 * t77 / 0.108e3 + t612 * t1091 * t77 / 0.864e3 + t274 * t492 * t80 / 0.108e3 - t630 * t1091 * t80 / 0.864e3);
  t1103 = t107 * t1102;
  t1107 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t401 * t538 - t1075 - 0.3e1 / 0.8e1 * t163 * t1103);
  tv3rhosigma211 = t6 * t1107 + t541;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1110 = t611 / t600;
  t1117 = params->kappa * (-t609 * t1110 * t45 / 0.2304e4 + t629 * t1110 * t50 / 0.2304e4);
  t1118 = t107 * t1117;
  t1121 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t1118);
  tv3sigma30 = t6 * t1121;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1123 = t611 / t885;
  t1130 = params->kappa * (-t609 * t1123 * t77 / 0.2304e4 + t629 * t1123 * t80 / 0.2304e4);
  t1131 = t107 * t1130;
  t1134 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t1131);
  tv3sigma39 = t6 * t1134;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t28, t30, t31, t32, t33;
  double t34, t35, t36, t37, t38, t39, t41, t42;
  double t45, t47, t50, t53, t57, t58, t59, t61;
  double t62, t63, t64, t66, t68, t69, t70, t71;
  double t73, t74, t77, t80, t83, t87, tzk0;

  double t88, t89, t90, t92, t95, t100, t101, t105;
  double t106, t107, t108, t110, t119, t120, t124, t125;
  double t127, t130, t138, t140, tvrho0, t144, t147, t153;
  double t155, t158, t163, t164, t166, t175, t176, t180;
  double tvrho1, t183, t190, t191, t194, tvsigma0, tvsigma1, t195;
  double t202, t203, t206, tvsigma2;

  double t209, t210, t211, t214, t215, t216, t219, t223;
  double t230, t232, t236, t240, t241, t242, t243, t245;
  double t247, t252, t253, t255, t256, t258, t259, t260;
  double t263, t272, t274, t280, t281, t285, t286, t287;
  double t288, t291, t294, t298, t305, t310, t312, tv2rho20;
  double t315, t319, t323, t330, t332, t338, t339, t343;
  double t347, t354, t357, t360, t361, t364, tv2rho21, t369;
  double t374, t378, t385, t386, t391, t395, t401, t405;
  double t407, t412, t413, t416, t430, t431, t435, tv2rho22;
  double t440, t442, t443, t447, t450, t451, t458, t463;
  double t464, t468, tv2rhosigma0, tv2rhosigma1, t472, t474, t476, tv2rhosigma2;
  double t481, tv2rhosigma3, tv2rhosigma4, t485, t489, t492, t493, t500;
  double t505, t506, t510, tv2rhosigma5, t512, t515, t522, t523;
  double t526, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t527, t530;
  double t537, t538, t541, tv2sigma25;

  double t545, t546, t549, t552, t553, t554, t557, t561;
  double t568, t570, t575, t577, t582, t586, t587, t588;
  double t589, t591, t592, t595, t600, t602, t608, t609;
  double t610, t611, t612, t613, t614, t615, t616, t629;
  double t630, t635, t636, t640, t642, t643, t646, t649;
  double t652, t656, t663, t667, t672, t674, tv3rho30, t677;
  double t678, t679, t682, t687, t688, t690, t694, t702;
  double t703, t708, t711, t719, t720, t721, t724, t729;
  double t731, t735, t743, t746, t750, t754, t755, t756;
  double t759, tv3rho31, t762, t767, t771, t775, t782, t784;
  double t791, t792, t797, t801, t805, t812, t815, t818;
  double t824, t825, t827, t828, tv3rho32, t833, t840, t844;
  double t852, t853, t860, t864, t870, t880, t885, t887;
  double t892, t893, t894, t895, t911, t912, t916, tv3rho33;
  double t922, t926, t928, t929, t930, t932, t936, t940;
  double t941, t942, t956, t957, t961, tv3rho2sigma0, tv3rho2sigma1, t966;
  double t968, t970, t972, tv3rho2sigma2, t976, t983, tv3rho2sigma3, tv3rho2sigma4;
  double t987, t992, t993, t996, tv3rho2sigma5, t1003, tv3rho2sigma6, tv3rho2sigma7;
  double t1012, t1016, t1020, t1021, t1022, t1036, t1037, t1041;
  double tv3rho2sigma8, t1045, t1047, t1051, t1052, t1053, t1064, t1065;
  double t1069, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1073, t1075;
  double t1077, tv3rhosigma25, t1082, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t1089, t1090, t1091, t1102, t1103, t1107, tv3rhosigma211, t1110;
  double t1117, t1118, t1121, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1123, t1130, t1131, t1134;
  double tv3sigma39;

  double t1138, t1141, t1147, t1152, t1154, t1158, t1159, t1160;
  double t1161, t1162, t1167, t1168, t1183, t1184, t1186, t1195;
  double t1198, t1202, t1203, t1207, t1209, t1212, t1216, t1220;
  double t1224, t1227, t1231, t1232, t1234, t1235, t1241, t1247;
  double t1248, t1251, t1255, t1260, t1261, t1262, t1264, t1265;
  double t1271, t1276, t1279, t1283, t1290, t1294, t1298, t1303;
  double t1305, tv4rho40, t1310, t1313, t1317, t1318, t1319, t1331;
  double t1335, t1336, t1339, t1360, t1361, t1363, t1367, t1372;
  double t1373, t1390, t1392, t1396, t1403, t1407, t1408, t1411;
  double t1416, t1419, t1421, t1422, t1424, t1426, t1427, tv4rho41;
  double t1434, t1437, t1449, t1453, t1468, t1481, t1485, t1490;
  double t1491, t1500, t1513, t1517, t1524, t1528, t1533, t1536;
  double t1538, t1547, t1550, t1552, t1553, tv4rho42, t1574, t1578;
  double t1585, t1587, t1596, t1597, t1614, t1618, t1625, t1629;
  double t1632, t1639, t1648, t1650, t1651, tv4rho43, t1656, t1661;
  double t1668, t1672, t1681, t1691, t1697, t1702, t1704, t1708;
  double t1709, t1714, t1715, t1731, t1740, t1747, t1752, t1759;
  double t1763, t1768, t1769, tv4rho44, t1775, t1779, t1781, t1787;
  double t1789, t1792, t1794, t1798, t1802, t1809, t1811, t1834;
  double tv4rho3sigma0, tv4rho3sigma1, t1839, t1841, t1845, t1847, tv4rho3sigma2, t1849;
  double t1853, t1856, t1859, t1867, t1868, tv4rho3sigma3, tv4rho3sigma4, t1870;
  double t1874, t1875, t1882, t1884, t1887, tv4rho3sigma5, t1891, t1899;
  double tv4rho3sigma6, tv4rho3sigma7, t1903, t1908, t1915, t1917, t1918, tv4rho3sigma8;
  double t1926, tv4rho3sigma9, tv4rho3sigma10, t1940, t1944, t1948, t1955, t1957;
  double t1980, tv4rho3sigma11, t1985, t1991, t1993, t1998, t2004, t2006;
  double t2026, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t2031, t2035;
  double t2037, tv4rho2sigma25, t2041, t2048, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29;
  double tv4rho2sigma210, t2052, t2058, t2061, tv4rho2sigma211, t2068, tv4rho2sigma212, tv4rho2sigma213;
  double tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t2080, t2086, t2088, t2108, tv4rho2sigma217;
  double t2114, t2115, t2121, t2123, t2140, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32;
  double tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t2146, t2148;
  double tv4rhosigma39, t2153, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315;
  double tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t2157, t2163, t2181, tv4rhosigma319, t2183;
  double t2186, t2189, t2198, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44;
  double tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412;
  double tv4sigma413, t2201, t2212, tv4sigma414;

  gga_x_bkl_params *params;

  assert(p->params != NULL);
  params = (gga_x_bkl_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t28 = params->gamma * params->kappa;
  t30 = M_CBRT6;
  t31 = params->alpha * params->mu1 * t30;
  t32 = M_PI * M_PI;
  t33 = POW_1_3(t32);
  t34 = t33 * t33;
  t35 = 0.1e1 / t34;
  t36 = t35 * sigma[0];
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t41 = 0.1e1 / t39 / t37;
  t42 = t36 * t41;
  t45 = exp(-t31 * t42 / 0.24e2);
  t47 = params->beta * params->mu1 * t30;
  t50 = exp(-t47 * t42 / 0.24e2);
  t53 = 0.1e1 + t28 * (t45 - t50);
  t57 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t25 * t26 * t53);
  t58 = rho[1] <= p->dens_threshold;
  t59 = -t16;
  t61 = my_piecewise5(t14, t11, t10, t15, t59 * t7);
  t62 = 0.1e1 + t61;
  t63 = t62 <= p->zeta_threshold;
  t64 = POW_1_3(t62);
  t66 = my_piecewise3(t63, t22, t64 * t62);
  t68 = t35 * sigma[2];
  t69 = rho[1] * rho[1];
  t70 = POW_1_3(rho[1]);
  t71 = t70 * t70;
  t73 = 0.1e1 / t71 / t69;
  t74 = t68 * t73;
  t77 = exp(-t31 * t74 / 0.24e2);
  t80 = exp(-t47 * t74 / 0.24e2);
  t83 = 0.1e1 + t28 * (t77 - t80);
  t87 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t66 * t26 * t83);
  tzk0 = t57 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t88 = t6 * t6;
  t89 = 0.1e1 / t88;
  t90 = t16 * t89;
  t92 = my_piecewise5(t10, 0, t14, 0, t7 - t90);
  t95 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92);
  t100 = t26 * t26;
  t101 = 0.1e1 / t100;
  t105 = t5 * t25 * t101 * t53 / 0.8e1;
  t106 = t5 * t25;
  t107 = t26 * params->gamma;
  t108 = t37 * rho[0];
  t110 = 0.1e1 / t39 / t108;
  t119 = params->kappa * (t31 * t36 * t110 * t45 / 0.9e1 - t47 * t36 * t110 * t50 / 0.9e1);
  t120 = t107 * t119;
  t124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t95 * t26 * t53 - t105 - 0.3e1 / 0.8e1 * t106 * t120);
  t125 = t59 * t89;
  t127 = my_piecewise5(t14, 0, t10, 0, -t7 - t125);
  t130 = my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t127);
  t138 = t5 * t66 * t101 * t83 / 0.8e1;
  t140 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t130 * t26 * t83 - t138);
  tvrho0 = t57 + t87 + t6 * (t124 + t140);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t144 = my_piecewise5(t10, 0, t14, 0, -t7 - t90);
  t147 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t144);
  t153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t147 * t26 * t53 - t105);
  t155 = my_piecewise5(t14, 0, t10, 0, t7 - t125);
  t158 = my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t155);
  t163 = t5 * t66;
  t164 = t69 * rho[1];
  t166 = 0.1e1 / t71 / t164;
  t175 = params->kappa * (t31 * t68 * t166 * t77 / 0.9e1 - t47 * t68 * t166 * t80 / 0.9e1);
  t176 = t107 * t175;
  t180 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t158 * t26 * t83 - t138 - 0.3e1 / 0.8e1 * t163 * t176);
  tvrho1 = t57 + t87 + t6 * (t153 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t183 = t35 * t41;
  t190 = params->kappa * (-t31 * t183 * t45 / 0.24e2 + t47 * t183 * t50 / 0.24e2);
  t191 = t107 * t190;
  t194 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t191);
  tvsigma0 = t6 * t194;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t195 = t35 * t73;
  t202 = params->kappa * (-t31 * t195 * t77 / 0.24e2 + t47 * t195 * t80 / 0.24e2);
  t203 = t107 * t202;
  t206 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t203);
  tvsigma2 = t6 * t206;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t209 = t23 * t23;
  t210 = 0.1e1 / t209;
  t211 = t92 * t92;
  t214 = t88 * t6;
  t215 = 0.1e1 / t214;
  t216 = t16 * t215;
  t219 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t89 + 0.2e1 * t216);
  t223 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t210 * t211 + 0.4e1 / 0.3e1 * t23 * t219);
  t230 = t5 * t95 * t101 * t53;
  t232 = t5 * t95;
  t236 = 0.1e1 / t100 / t6;
  t240 = t5 * t25 * t236 * t53 / 0.12e2;
  t241 = t101 * params->gamma;
  t242 = t241 * t119;
  t243 = t106 * t242;
  t245 = t37 * t37;
  t247 = 0.1e1 / t39 / t245;
  t252 = params->alpha * params->alpha;
  t253 = params->mu1 * params->mu1;
  t255 = t30 * t30;
  t256 = t252 * t253 * t255;
  t258 = 0.1e1 / t33 / t32;
  t259 = sigma[0] * sigma[0];
  t260 = t258 * t259;
  t263 = 0.1e1 / t38 / t245 / t108;
  t272 = params->beta * params->beta;
  t274 = t272 * t253 * t255;
  t280 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t36 * t247 * t45 + t256 * t260 * t263 * t45 / 0.81e2 + 0.11e2 / 0.27e2 * t47 * t36 * t247 * t50 - t274 * t260 * t263 * t50 / 0.81e2);
  t281 = t107 * t280;
  t285 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t223 * t26 * t53 - t230 / 0.4e1 - 0.3e1 / 0.4e1 * t232 * t120 + t240 - t243 / 0.4e1 - 0.3e1 / 0.8e1 * t106 * t281);
  t286 = t64 * t64;
  t287 = 0.1e1 / t286;
  t288 = t127 * t127;
  t291 = t59 * t215;
  t294 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t89 + 0.2e1 * t291);
  t298 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t287 * t288 + 0.4e1 / 0.3e1 * t64 * t294);
  t305 = t5 * t130 * t101 * t83;
  t310 = t5 * t66 * t236 * t83 / 0.12e2;
  t312 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t298 * t26 * t83 - t305 / 0.4e1 + t310);
  tv2rho20 = 0.2e1 * t124 + 0.2e1 * t140 + t6 * (t285 + t312);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t315 = t210 * t144;
  t319 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t216);
  t323 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t315 * t92 + 0.4e1 / 0.3e1 * t23 * t319);
  t330 = t5 * t147 * t101 * t53;
  t332 = t5 * t147;
  t338 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t323 * t26 * t53 - t330 / 0.8e1 - 0.3e1 / 0.8e1 * t332 * t120 - t230 / 0.8e1 + t240 - t243 / 0.8e1);
  t339 = t287 * t155;
  t343 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t291);
  t347 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t339 * t127 + 0.4e1 / 0.3e1 * t64 * t343);
  t354 = t5 * t158 * t101 * t83;
  t357 = t5 * t130;
  t360 = t241 * t175;
  t361 = t163 * t360;
  t364 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t347 * t26 * t83 - t354 / 0.8e1 - t305 / 0.8e1 + t310 - 0.3e1 / 0.8e1 * t357 * t176 - t361 / 0.8e1);
  tv2rho21 = t124 + t140 + t153 + t180 + t6 * (t338 + t364);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t369 = t144 * t144;
  t374 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t89 + 0.2e1 * t216);
  t378 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t210 * t369 + 0.4e1 / 0.3e1 * t23 * t374);
  t385 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t378 * t26 * t53 - t330 / 0.4e1 + t240);
  t386 = t155 * t155;
  t391 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t89 + 0.2e1 * t291);
  t395 = my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t287 * t386 + 0.4e1 / 0.3e1 * t64 * t391);
  t401 = t5 * t158;
  t405 = t69 * t69;
  t407 = 0.1e1 / t71 / t405;
  t412 = sigma[2] * sigma[2];
  t413 = t258 * t412;
  t416 = 0.1e1 / t70 / t405 / t164;
  t430 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t68 * t407 * t77 + t256 * t413 * t416 * t77 / 0.81e2 + 0.11e2 / 0.27e2 * t47 * t68 * t407 * t80 - t274 * t413 * t416 * t80 / 0.81e2);
  t431 = t107 * t430;
  t435 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t395 * t26 * t83 - t354 / 0.4e1 - 0.3e1 / 0.4e1 * t401 * t176 + t310 - t361 / 0.4e1 - 0.3e1 / 0.8e1 * t163 * t431);
  tv2rho22 = 0.2e1 * t153 + 0.2e1 * t180 + t6 * (t385 + t435);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t440 = t241 * t190;
  t442 = t106 * t440 / 0.8e1;
  t443 = t35 * t110;
  t447 = t245 * t37;
  t450 = t258 / t38 / t447;
  t451 = sigma[0] * t45;
  t458 = sigma[0] * t50;
  t463 = params->kappa * (t31 * t443 * t45 / 0.9e1 - t256 * t450 * t451 / 0.216e3 - t47 * t443 * t50 / 0.9e1 + t274 * t450 * t458 / 0.216e3);
  t464 = t107 * t463;
  t468 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t232 * t191 - t442 - 0.3e1 / 0.8e1 * t106 * t464);
  tv2rhosigma0 = t6 * t468 + t194;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t472 = t241 * t202;
  t474 = t163 * t472 / 0.8e1;
  t476 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t357 * t203 - t474);
  tv2rhosigma2 = t6 * t476 + t206;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t481 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t332 * t191 - t442);
  tv2rhosigma3 = t6 * t481 + t194;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t485 = t35 * t166;
  t489 = t405 * t69;
  t492 = t258 / t70 / t489;
  t493 = sigma[2] * t77;
  t500 = sigma[2] * t80;
  t505 = params->kappa * (t31 * t485 * t77 / 0.9e1 - t256 * t492 * t493 / 0.216e3 - t47 * t485 * t80 / 0.9e1 + t274 * t492 * t500 / 0.216e3);
  t506 = t107 * t505;
  t510 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t401 * t203 - t474 - 0.3e1 / 0.8e1 * t163 * t506);
  tv2rhosigma5 = t6 * t510 + t206;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t512 = t245 * rho[0];
  t515 = t258 / t38 / t512;
  t522 = params->kappa * (t256 * t515 * t45 / 0.576e3 - t274 * t515 * t50 / 0.576e3);
  t523 = t107 * t522;
  t526 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t523);
  tv2sigma20 = t6 * t526;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t527 = t405 * rho[1];
  t530 = t258 / t70 / t527;
  t537 = params->kappa * (t256 * t530 * t77 / 0.576e3 - t274 * t530 * t80 / 0.576e3);
  t538 = t107 * t537;
  t541 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t538);
  tv2sigma25 = t6 * t541;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t545 = 0.1e1 / t209 / t19;
  t546 = t211 * t92;
  t549 = t210 * t92;
  t552 = t88 * t88;
  t553 = 0.1e1 / t552;
  t554 = t16 * t553;
  t557 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t215 - 0.6e1 * t554);
  t561 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t545 * t546 + 0.4e1 / 0.3e1 * t549 * t219 + 0.4e1 / 0.3e1 * t23 * t557);
  t568 = t5 * t223 * t101 * t53;
  t570 = t5 * t223;
  t575 = t5 * t95 * t236 * t53;
  t577 = t232 * t242;
  t582 = 0.1e1 / t100 / t88;
  t586 = 0.5e1 / 0.36e2 * t5 * t25 * t582 * t53;
  t587 = t236 * params->gamma;
  t588 = t587 * t119;
  t589 = t106 * t588;
  t591 = t241 * t280;
  t592 = t106 * t591;
  t595 = 0.1e1 / t39 / t512;
  t600 = t245 * t245;
  t602 = 0.1e1 / t38 / t600;
  t608 = t253 * params->mu1;
  t609 = t252 * params->alpha * t608;
  t610 = t32 * t32;
  t611 = 0.1e1 / t610;
  t612 = t609 * t611;
  t613 = t259 * sigma[0];
  t614 = t600 * t108;
  t615 = 0.1e1 / t614;
  t616 = t613 * t615;
  t629 = t272 * params->beta * t608;
  t630 = t629 * t611;
  t635 = params->kappa * (0.154e3 / 0.81e2 * t31 * t36 * t595 * t45 - 0.11e2 / 0.81e2 * t256 * t260 * t602 * t45 + 0.2e1 / 0.243e3 * t612 * t616 * t45 - 0.154e3 / 0.81e2 * t47 * t36 * t595 * t50 + 0.11e2 / 0.81e2 * t274 * t260 * t602 * t50 - 0.2e1 / 0.243e3 * t630 * t616 * t50);
  t636 = t107 * t635;
  t640 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t561 * t26 * t53 - 0.3e1 / 0.8e1 * t568 - 0.9e1 / 0.8e1 * t570 * t120 + t575 / 0.4e1 - 0.3e1 / 0.4e1 * t577 - 0.9e1 / 0.8e1 * t232 * t281 - t586 + t589 / 0.4e1 - 0.3e1 / 0.8e1 * t592 - 0.3e1 / 0.8e1 * t106 * t636);
  t642 = 0.1e1 / t286 / t62;
  t643 = t288 * t127;
  t646 = t287 * t127;
  t649 = t59 * t553;
  t652 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t215 - 0.6e1 * t649);
  t656 = my_piecewise3(t63, 0, -0.8e1 / 0.27e2 * t642 * t643 + 0.4e1 / 0.3e1 * t646 * t294 + 0.4e1 / 0.3e1 * t64 * t652);
  t663 = t5 * t298 * t101 * t83;
  t667 = t5 * t130 * t236 * t83;
  t672 = 0.5e1 / 0.36e2 * t5 * t66 * t582 * t83;
  t674 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t656 * t26 * t83 - 0.3e1 / 0.8e1 * t663 + t667 / 0.4e1 - t672);
  tv3rho30 = 0.3e1 * t285 + 0.3e1 * t312 + t6 * (t640 + t674);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t677 = 0.2e1 * t338;
  t678 = 0.2e1 * t364;
  t679 = t545 * t144;
  t682 = t210 * t319;
  t687 = 0.2e1 * t215;
  t688 = 0.6e1 * t554;
  t690 = my_piecewise5(t10, 0, t14, 0, t687 - t688);
  t694 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t679 * t211 + 0.8e1 / 0.9e1 * t682 * t92 + 0.4e1 / 0.9e1 * t315 * t219 + 0.4e1 / 0.3e1 * t23 * t690);
  t702 = t5 * t323 * t101 * t53 / 0.4e1;
  t703 = t5 * t323;
  t708 = t5 * t147 * t236 * t53;
  t711 = t332 * t242 / 0.4e1;
  t719 = -0.3e1 / 0.8e1 * t5 * t694 * t26 * t53 - t702 - 0.3e1 / 0.4e1 * t703 * t120 + t708 / 0.12e2 - t711 - 0.3e1 / 0.8e1 * t332 * t281 - t568 / 0.8e1 + t575 / 0.6e1 - t577 / 0.4e1 - t586 + t589 / 0.6e1 - t592 / 0.8e1;
  t720 = my_piecewise3(t1, 0, t719);
  t721 = t642 * t155;
  t724 = t287 * t343;
  t729 = 0.6e1 * t649;
  t731 = my_piecewise5(t14, 0, t10, 0, -t687 - t729);
  t735 = my_piecewise3(t63, 0, -0.8e1 / 0.27e2 * t721 * t288 + 0.8e1 / 0.9e1 * t724 * t127 + 0.4e1 / 0.9e1 * t339 * t294 + 0.4e1 / 0.3e1 * t64 * t731);
  t743 = t5 * t347 * t101 * t83 / 0.4e1;
  t746 = t5 * t158 * t236 * t83;
  t750 = t5 * t298;
  t754 = t357 * t360 / 0.4e1;
  t755 = t587 * t175;
  t756 = t163 * t755;
  t759 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t735 * t26 * t83 - t743 + t746 / 0.12e2 - t663 / 0.8e1 + t667 / 0.6e1 - t672 - 0.3e1 / 0.8e1 * t750 * t176 - t754 + t756 / 0.12e2);
  tv3rho31 = t285 + t312 + t677 + t678 + t6 * (t720 + t759);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t762 = t545 * t369;
  t767 = t210 * t374;
  t771 = my_piecewise5(t10, 0, t14, 0, -t687 - t688);
  t775 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t762 * t92 + 0.8e1 / 0.9e1 * t315 * t319 + 0.4e1 / 0.9e1 * t767 * t92 + 0.4e1 / 0.3e1 * t23 * t771);
  t782 = t5 * t378 * t101 * t53;
  t784 = t5 * t378;
  t791 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t775 * t26 * t53 - t782 / 0.8e1 - 0.3e1 / 0.8e1 * t784 * t120 - t702 + t708 / 0.6e1 - t711 + t575 / 0.12e2 - t586 + t589 / 0.12e2);
  t792 = t642 * t386;
  t797 = t287 * t391;
  t801 = my_piecewise5(t14, 0, t10, 0, t687 - t729);
  t805 = my_piecewise3(t63, 0, -0.8e1 / 0.27e2 * t792 * t127 + 0.8e1 / 0.9e1 * t339 * t343 + 0.4e1 / 0.9e1 * t797 * t127 + 0.4e1 / 0.3e1 * t64 * t801);
  t812 = t5 * t395 * t101 * t83;
  t815 = t5 * t347;
  t818 = t401 * t360;
  t824 = t241 * t430;
  t825 = t163 * t824;
  t827 = -0.3e1 / 0.8e1 * t5 * t805 * t26 * t83 - t812 / 0.8e1 - t743 + t746 / 0.6e1 - 0.3e1 / 0.4e1 * t815 * t176 - t818 / 0.4e1 + t667 / 0.12e2 - t672 - t754 + t756 / 0.6e1 - 0.3e1 / 0.8e1 * t357 * t431 - t825 / 0.8e1;
  t828 = my_piecewise3(t58, 0, t827);
  tv3rho32 = t677 + t678 + t385 + t435 + t6 * (t791 + t828);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t833 = t369 * t144;
  t840 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t215 - 0.6e1 * t554);
  t844 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t545 * t833 + 0.4e1 / 0.3e1 * t315 * t374 + 0.4e1 / 0.3e1 * t23 * t840);
  t852 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t844 * t26 * t53 - 0.3e1 / 0.8e1 * t782 + t708 / 0.4e1 - t586);
  t853 = t386 * t155;
  t860 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t215 - 0.6e1 * t649);
  t864 = my_piecewise3(t63, 0, -0.8e1 / 0.27e2 * t642 * t853 + 0.4e1 / 0.3e1 * t339 * t391 + 0.4e1 / 0.3e1 * t64 * t860);
  t870 = t5 * t395;
  t880 = 0.1e1 / t71 / t527;
  t885 = t405 * t405;
  t887 = 0.1e1 / t70 / t885;
  t892 = t412 * sigma[2];
  t893 = t885 * t164;
  t894 = 0.1e1 / t893;
  t895 = t892 * t894;
  t911 = params->kappa * (0.154e3 / 0.81e2 * t31 * t68 * t880 * t77 - 0.11e2 / 0.81e2 * t256 * t413 * t887 * t77 + 0.2e1 / 0.243e3 * t612 * t895 * t77 - 0.154e3 / 0.81e2 * t47 * t68 * t880 * t80 + 0.11e2 / 0.81e2 * t274 * t413 * t887 * t80 - 0.2e1 / 0.243e3 * t630 * t895 * t80);
  t912 = t107 * t911;
  t916 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t864 * t26 * t83 - 0.3e1 / 0.8e1 * t812 - 0.9e1 / 0.8e1 * t870 * t176 + t746 / 0.4e1 - 0.3e1 / 0.4e1 * t818 - 0.9e1 / 0.8e1 * t401 * t431 - t672 + t756 / 0.4e1 - 0.3e1 / 0.8e1 * t825 - 0.3e1 / 0.8e1 * t163 * t912);
  tv3rho33 = 0.3e1 * t385 + 0.3e1 * t435 + t6 * (t852 + t916);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t922 = t232 * t440;
  t926 = t587 * t190;
  t928 = t106 * t926 / 0.12e2;
  t929 = t241 * t463;
  t930 = t106 * t929;
  t932 = t35 * t247;
  t936 = t258 * t263;
  t940 = t600 * t37;
  t941 = 0.1e1 / t940;
  t942 = t941 * t259;
  t956 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t932 * t45 + t256 * t936 * t451 / 0.24e2 - t612 * t942 * t45 / 0.324e3 + 0.11e2 / 0.27e2 * t47 * t932 * t50 - t274 * t936 * t458 / 0.24e2 + t630 * t942 * t50 / 0.324e3);
  t957 = t107 * t956;
  t961 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t570 * t191 - t922 / 0.4e1 - 0.3e1 / 0.4e1 * t232 * t464 + t928 - t930 / 0.4e1 - 0.3e1 / 0.8e1 * t106 * t957);
  tv3rho2sigma0 = t6 * t961 + 0.2e1 * t468;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t966 = t357 * t472;
  t968 = t587 * t202;
  t970 = t163 * t968 / 0.12e2;
  t972 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t750 * t203 - t966 / 0.4e1 + t970);
  tv3rho2sigma2 = t6 * t972 + 0.2e1 * t476;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t976 = t332 * t440;
  t983 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t703 * t191 - t976 / 0.8e1 - 0.3e1 / 0.8e1 * t332 * t464 - t922 / 0.8e1 + t928 - t930 / 0.8e1);
  tv3rho2sigma3 = t6 * t983 + t468 + t481;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t987 = t401 * t472;
  t992 = t241 * t505;
  t993 = t163 * t992;
  t996 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t815 * t203 - t987 / 0.8e1 - t966 / 0.8e1 + t970 - 0.3e1 / 0.8e1 * t357 * t506 - t993 / 0.8e1);
  tv3rho2sigma5 = t6 * t996 + t476 + t510;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1003 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t784 * t191 - t976 / 0.4e1 + t928);
  tv3rho2sigma6 = t6 * t1003 + 0.2e1 * t481;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1012 = t35 * t407;
  t1016 = t258 * t416;
  t1020 = t885 * t69;
  t1021 = 0.1e1 / t1020;
  t1022 = t1021 * t412;
  t1036 = params->kappa * (-0.11e2 / 0.27e2 * t31 * t1012 * t77 + t256 * t1016 * t493 / 0.24e2 - t612 * t1022 * t77 / 0.324e3 + 0.11e2 / 0.27e2 * t47 * t1012 * t80 - t274 * t1016 * t500 / 0.24e2 + t630 * t1022 * t80 / 0.324e3);
  t1037 = t107 * t1036;
  t1041 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t870 * t203 - t987 / 0.4e1 - 0.3e1 / 0.4e1 * t401 * t506 + t970 - t993 / 0.4e1 - 0.3e1 / 0.8e1 * t163 * t1037);
  tv3rho2sigma8 = t6 * t1041 + 0.2e1 * t510;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1045 = t241 * t522;
  t1047 = t106 * t1045 / 0.8e1;
  t1051 = t600 * rho[0];
  t1052 = 0.1e1 / t1051;
  t1053 = t1052 * sigma[0];
  t1064 = params->kappa * (-t256 * t450 * t45 / 0.108e3 + t612 * t1053 * t45 / 0.864e3 + t274 * t450 * t50 / 0.108e3 - t630 * t1053 * t50 / 0.864e3);
  t1065 = t107 * t1064;
  t1069 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t232 * t523 - t1047 - 0.3e1 / 0.8e1 * t106 * t1065);
  tv3rhosigma20 = t6 * t1069 + t526;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1073 = t241 * t537;
  t1075 = t163 * t1073 / 0.8e1;
  t1077 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t357 * t538 - t1075);
  tv3rhosigma25 = t6 * t1077 + t541;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1082 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t332 * t523 - t1047);
  tv3rhosigma26 = t6 * t1082 + t526;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1089 = t885 * rho[1];
  t1090 = 0.1e1 / t1089;
  t1091 = t1090 * sigma[2];
  t1102 = params->kappa * (-t256 * t492 * t77 / 0.108e3 + t612 * t1091 * t77 / 0.864e3 + t274 * t492 * t80 / 0.108e3 - t630 * t1091 * t80 / 0.864e3);
  t1103 = t107 * t1102;
  t1107 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t401 * t538 - t1075 - 0.3e1 / 0.8e1 * t163 * t1103);
  tv3rhosigma211 = t6 * t1107 + t541;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1110 = t611 / t600;
  t1117 = params->kappa * (-t609 * t1110 * t45 / 0.2304e4 + t629 * t1110 * t50 / 0.2304e4);
  t1118 = t107 * t1117;
  t1121 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t1118);
  tv3sigma30 = t6 * t1121;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1123 = t611 / t885;
  t1130 = params->kappa * (-t609 * t1123 * t77 / 0.2304e4 + t629 * t1123 * t80 / 0.2304e4);
  t1131 = t107 * t1130;
  t1134 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t1131);
  tv3sigma39 = t6 * t1134;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1138 = t106 * t241 * t635;
  t1141 = 0.1e1 / t39 / t447;
  t1147 = 0.1e1 / t38 / t1051;
  t1152 = t600 * t245;
  t1154 = t613 / t1152;
  t1158 = t252 * t252;
  t1159 = t253 * t253;
  t1160 = t1158 * t1159;
  t1161 = t259 * t259;
  t1162 = t611 * t1161;
  t1167 = 0.1e1 / t39 / t600 / t447 * t30;
  t1168 = t35 * t45;
  t1183 = t272 * t272;
  t1184 = t1183 * t1159;
  t1186 = t35 * t50;
  t1195 = t5 * t561;
  t1198 = t570 * t242;
  t1202 = t232 * t588;
  t1203 = t232 * t591;
  t1207 = t582 * params->gamma;
  t1209 = t106 * t1207 * t119;
  t1212 = t106 * t587 * t280;
  t1216 = t5 * t561 * t101 * t53;
  t1220 = t5 * t223 * t236 * t53;
  t1224 = t5 * t95 * t582 * t53;
  t1227 = 0.1e1 / t100 / t214;
  t1231 = 0.1e2 / 0.27e2 * t5 * t25 * t1227 * t53;
  t1232 = t19 * t19;
  t1234 = 0.1e1 / t209 / t1232;
  t1235 = t211 * t211;
  t1241 = t219 * t219;
  t1247 = 0.1e1 / t552 / t6;
  t1248 = t16 * t1247;
  t1251 = my_piecewise5(t10, 0, t14, 0, -0.24e2 * t553 + 0.24e2 * t1248);
  t1255 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1234 * t1235 - 0.16e2 / 0.9e1 * t545 * t211 * t219 + 0.4e1 / 0.3e1 * t210 * t1241 + 0.16e2 / 0.9e1 * t549 * t557 + 0.4e1 / 0.3e1 * t23 * t1251);
  t1260 = -t1138 / 0.2e1 - 0.3e1 / 0.8e1 * t106 * t107 * params->kappa * (-0.2618e4 / 0.243e3 * t31 * t36 * t1141 * t45 + 0.979e3 / 0.729e3 * t256 * t260 * t1147 * t45 - 0.44e2 / 0.243e3 * t612 * t1154 * t45 + 0.2e1 / 0.2187e4 * t1160 * t1162 * t1167 * t1168 + 0.2618e4 / 0.243e3 * t47 * t36 * t1141 * t50 - 0.979e3 / 0.729e3 * t274 * t260 * t1147 * t50 + 0.44e2 / 0.243e3 * t630 * t1154 * t50 - 0.2e1 / 0.2187e4 * t1184 * t1162 * t1167 * t1186) - 0.3e1 / 0.2e1 * t1195 * t120 - 0.3e1 / 0.2e1 * t1198 - 0.9e1 / 0.4e1 * t570 * t281 + t1202 - 0.3e1 / 0.2e1 * t1203 - 0.3e1 / 0.2e1 * t232 * t636 - 0.5e1 / 0.9e1 * t1209 + t1212 / 0.2e1 - t1216 / 0.2e1 + t1220 / 0.2e1 - 0.5e1 / 0.9e1 * t1224 + t1231 - 0.3e1 / 0.8e1 * t5 * t1255 * t26 * t53;
  t1261 = my_piecewise3(t1, 0, t1260);
  t1262 = t62 * t62;
  t1264 = 0.1e1 / t286 / t1262;
  t1265 = t288 * t288;
  t1271 = t294 * t294;
  t1276 = t59 * t1247;
  t1279 = my_piecewise5(t14, 0, t10, 0, 0.24e2 * t553 + 0.24e2 * t1276);
  t1283 = my_piecewise3(t63, 0, 0.4e2 / 0.81e2 * t1264 * t1265 - 0.16e2 / 0.9e1 * t642 * t288 * t294 + 0.4e1 / 0.3e1 * t287 * t1271 + 0.16e2 / 0.9e1 * t646 * t652 + 0.4e1 / 0.3e1 * t64 * t1279);
  t1290 = t5 * t656 * t101 * t83;
  t1294 = t5 * t298 * t236 * t83;
  t1298 = t5 * t130 * t582 * t83;
  t1303 = 0.1e2 / 0.27e2 * t5 * t66 * t1227 * t83;
  t1305 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t5 * t1283 * t26 * t83 - t1290 / 0.2e1 + t1294 / 0.2e1 - 0.5e1 / 0.9e1 * t1298 + t1303);
  tv4rho40 = 0.4e1 * t640 + 0.4e1 * t674 + t6 * (t1261 + t1305);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1310 = t5 * t694;
  t1313 = t703 * t242;
  t1317 = t332 * t588;
  t1318 = t1317 / 0.4e1;
  t1319 = t332 * t591;
  t1331 = t5 * t694 * t101 * t53;
  t1335 = t5 * t323 * t236 * t53;
  t1336 = t1335 / 0.4e1;
  t1339 = t5 * t147 * t582 * t53;
  t1360 = 0.12e2 * t553;
  t1361 = 0.24e2 * t1248;
  t1363 = my_piecewise5(t10, 0, t14, 0, -t1360 + t1361);
  t1367 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1234 * t144 * t546 - 0.8e1 / 0.9e1 * t545 * t319 * t211 - 0.8e1 / 0.9e1 * t679 * t92 * t219 + 0.4e1 / 0.3e1 * t210 * t690 * t92 + 0.4e1 / 0.3e1 * t682 * t219 + 0.4e1 / 0.9e1 * t315 * t557 + 0.4e1 / 0.3e1 * t23 * t1363);
  t1372 = -0.9e1 / 0.8e1 * t1310 * t120 - 0.3e1 / 0.4e1 * t1313 - 0.9e1 / 0.8e1 * t703 * t281 + t1318 - 0.3e1 / 0.8e1 * t1319 - 0.3e1 / 0.8e1 * t332 * t636 - t1138 / 0.8e1 - 0.3e1 / 0.8e1 * t1198 + t1202 / 0.2e1 - 0.3e1 / 0.8e1 * t1203 - 0.5e1 / 0.12e2 * t1209 + t1212 / 0.4e1 - 0.3e1 / 0.8e1 * t1331 + t1336 - 0.5e1 / 0.36e2 * t1339 - t1216 / 0.8e1 + t1220 / 0.4e1 - 0.5e1 / 0.12e2 * t1224 + t1231 - 0.3e1 / 0.8e1 * t5 * t1367 * t26 * t53;
  t1373 = my_piecewise3(t1, 0, t1372);
  t1390 = 0.24e2 * t1276;
  t1392 = my_piecewise5(t14, 0, t10, 0, t1360 + t1390);
  t1396 = my_piecewise3(t63, 0, 0.4e2 / 0.81e2 * t1264 * t155 * t643 - 0.8e1 / 0.9e1 * t642 * t343 * t288 - 0.8e1 / 0.9e1 * t721 * t127 * t294 + 0.4e1 / 0.3e1 * t287 * t731 * t127 + 0.4e1 / 0.3e1 * t724 * t294 + 0.4e1 / 0.9e1 * t339 * t652 + 0.4e1 / 0.3e1 * t64 * t1392);
  t1403 = t5 * t735 * t101 * t83;
  t1407 = t5 * t347 * t236 * t83;
  t1408 = t1407 / 0.4e1;
  t1411 = t5 * t158 * t582 * t83;
  t1416 = t5 * t656;
  t1419 = t750 * t360;
  t1421 = t357 * t755;
  t1422 = t1421 / 0.4e1;
  t1424 = t163 * t1207 * t175;
  t1426 = -0.3e1 / 0.8e1 * t5 * t1396 * t26 * t83 - 0.3e1 / 0.8e1 * t1403 + t1408 - 0.5e1 / 0.36e2 * t1411 - t1290 / 0.8e1 + t1294 / 0.4e1 - 0.5e1 / 0.12e2 * t1298 + t1303 - 0.3e1 / 0.8e1 * t1416 * t176 - 0.3e1 / 0.8e1 * t1419 + t1422 - 0.5e1 / 0.36e2 * t1424;
  t1427 = my_piecewise3(t58, 0, t1426);
  tv4rho41 = t640 + t674 + 0.3e1 * t720 + 0.3e1 * t759 + t6 * (t1373 + t1427);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1434 = t5 * t775;
  t1437 = t784 * t242;
  t1449 = t5 * t775 * t101 * t53;
  t1453 = t5 * t378 * t236 * t53;
  t1468 = t319 * t319;
  t1481 = my_piecewise5(t10, 0, t14, 0, t1361);
  t1485 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1234 * t369 * t211 - 0.32e2 / 0.27e2 * t679 * t92 * t319 - 0.8e1 / 0.27e2 * t762 * t219 + 0.8e1 / 0.9e1 * t210 * t1468 + 0.8e1 / 0.9e1 * t315 * t690 - 0.8e1 / 0.27e2 * t545 * t374 * t211 + 0.8e1 / 0.9e1 * t210 * t771 * t92 + 0.4e1 / 0.9e1 * t767 * t219 + 0.4e1 / 0.3e1 * t23 * t1481);
  t1490 = -0.3e1 / 0.4e1 * t1434 * t120 - t1437 / 0.4e1 - 0.3e1 / 0.8e1 * t784 * t281 - t1313 / 0.2e1 + t1317 / 0.3e1 - t1319 / 0.4e1 + t1202 / 0.6e1 - 0.5e1 / 0.18e2 * t1209 + t1212 / 0.12e2 - t1449 / 0.4e1 + t1453 / 0.12e2 - t1331 / 0.4e1 + t1335 / 0.3e1 - 0.5e1 / 0.18e2 * t1339 + t1220 / 0.12e2 - 0.5e1 / 0.18e2 * t1224 + t1231 - 0.3e1 / 0.8e1 * t5 * t1485 * t26 * t53;
  t1491 = my_piecewise3(t1, 0, t1490);
  t1500 = t343 * t343;
  t1513 = my_piecewise5(t14, 0, t10, 0, t1390);
  t1517 = my_piecewise3(t63, 0, 0.4e2 / 0.81e2 * t1264 * t386 * t288 - 0.32e2 / 0.27e2 * t721 * t127 * t343 - 0.8e1 / 0.27e2 * t792 * t294 + 0.8e1 / 0.9e1 * t287 * t1500 + 0.8e1 / 0.9e1 * t339 * t731 - 0.8e1 / 0.27e2 * t642 * t391 * t288 + 0.8e1 / 0.9e1 * t287 * t801 * t127 + 0.4e1 / 0.9e1 * t797 * t294 + 0.4e1 / 0.3e1 * t64 * t1513);
  t1524 = t5 * t805 * t101 * t83;
  t1528 = t5 * t395 * t236 * t83;
  t1533 = t5 * t735;
  t1536 = t815 * t360;
  t1538 = t401 * t755;
  t1547 = t357 * t824;
  t1550 = t163 * t587 * t430;
  t1552 = -0.3e1 / 0.8e1 * t5 * t1517 * t26 * t83 - t1524 / 0.4e1 + t1528 / 0.12e2 - t1403 / 0.4e1 + t1407 / 0.3e1 - 0.5e1 / 0.18e2 * t1411 - 0.3e1 / 0.4e1 * t1533 * t176 - t1536 / 0.2e1 + t1538 / 0.6e1 + t1294 / 0.12e2 - 0.5e1 / 0.18e2 * t1298 + t1303 - t1419 / 0.4e1 + t1421 / 0.3e1 - 0.5e1 / 0.18e2 * t1424 - 0.3e1 / 0.8e1 * t750 * t431 - t1547 / 0.4e1 + t1550 / 0.12e2;
  t1553 = my_piecewise3(t58, 0, t1552);
  tv4rho42 = 0.2e1 * t720 + 0.2e1 * t759 + 0.2e1 * t791 + 0.2e1 * t828 + t6 * (t1491 + t1553);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1574 = my_piecewise5(t10, 0, t14, 0, t1360 + t1361);
  t1578 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1234 * t833 * t92 - 0.8e1 / 0.9e1 * t762 * t319 - 0.8e1 / 0.9e1 * t679 * t374 * t92 + 0.4e1 / 0.3e1 * t682 * t374 + 0.4e1 / 0.3e1 * t315 * t771 + 0.4e1 / 0.9e1 * t210 * t840 * t92 + 0.4e1 / 0.3e1 * t23 * t1574);
  t1585 = t5 * t844 * t101 * t53;
  t1587 = t5 * t844;
  t1596 = -0.3e1 / 0.8e1 * t5 * t1578 * t26 * t53 - t1585 / 0.8e1 - 0.3e1 / 0.8e1 * t1587 * t120 - 0.3e1 / 0.8e1 * t1449 + t1453 / 0.4e1 - 0.3e1 / 0.8e1 * t1437 + t1336 - 0.5e1 / 0.12e2 * t1339 + t1318 - 0.5e1 / 0.36e2 * t1224 + t1231 - 0.5e1 / 0.36e2 * t1209;
  t1597 = my_piecewise3(t1, 0, t1596);
  t1614 = my_piecewise5(t14, 0, t10, 0, -t1360 + t1390);
  t1618 = my_piecewise3(t63, 0, 0.4e2 / 0.81e2 * t1264 * t853 * t127 - 0.8e1 / 0.9e1 * t792 * t343 - 0.8e1 / 0.9e1 * t721 * t391 * t127 + 0.4e1 / 0.3e1 * t724 * t391 + 0.4e1 / 0.3e1 * t339 * t801 + 0.4e1 / 0.9e1 * t287 * t860 * t127 + 0.4e1 / 0.3e1 * t64 * t1614);
  t1625 = t5 * t864 * t101 * t83;
  t1629 = t5 * t805;
  t1632 = t870 * t360;
  t1639 = t401 * t824;
  t1648 = t163 * t241 * t911;
  t1650 = -0.3e1 / 0.8e1 * t5 * t1618 * t26 * t83 - t1625 / 0.8e1 - 0.3e1 / 0.8e1 * t1524 + t1528 / 0.4e1 - 0.9e1 / 0.8e1 * t1629 * t176 - 0.3e1 / 0.8e1 * t1632 + t1408 - 0.5e1 / 0.12e2 * t1411 - 0.3e1 / 0.4e1 * t1536 + t1538 / 0.2e1 - 0.9e1 / 0.8e1 * t815 * t431 - 0.3e1 / 0.8e1 * t1639 - 0.5e1 / 0.36e2 * t1298 + t1303 + t1422 - 0.5e1 / 0.12e2 * t1424 - 0.3e1 / 0.8e1 * t1547 + t1550 / 0.4e1 - 0.3e1 / 0.8e1 * t357 * t912 - t1648 / 0.8e1;
  t1651 = my_piecewise3(t58, 0, t1650);
  tv4rho43 = 0.3e1 * t791 + 0.3e1 * t828 + t852 + t916 + t6 * (t1597 + t1651);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1656 = t369 * t369;
  t1661 = t374 * t374;
  t1668 = my_piecewise5(t10, 0, t14, 0, 0.24e2 * t553 + 0.24e2 * t1248);
  t1672 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1234 * t1656 - 0.16e2 / 0.9e1 * t762 * t374 + 0.4e1 / 0.3e1 * t210 * t1661 + 0.16e2 / 0.9e1 * t315 * t840 + 0.4e1 / 0.3e1 * t23 * t1668);
  t1681 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1672 * t26 * t53 - t1585 / 0.2e1 + t1453 / 0.2e1 - 0.5e1 / 0.9e1 * t1339 + t1231);
  t1691 = 0.1e1 / t71 / t489;
  t1697 = 0.1e1 / t70 / t1089;
  t1702 = t885 * t405;
  t1704 = t892 / t1702;
  t1708 = t412 * t412;
  t1709 = t611 * t1708;
  t1714 = 0.1e1 / t71 / t885 / t489 * t30;
  t1715 = t35 * t77;
  t1731 = t35 * t80;
  t1740 = t5 * t864;
  t1747 = t386 * t386;
  t1752 = t391 * t391;
  t1759 = my_piecewise5(t14, 0, t10, 0, -0.24e2 * t553 + 0.24e2 * t1276);
  t1763 = my_piecewise3(t63, 0, 0.4e2 / 0.81e2 * t1264 * t1747 - 0.16e2 / 0.9e1 * t792 * t391 + 0.4e1 / 0.3e1 * t287 * t1752 + 0.16e2 / 0.9e1 * t339 * t860 + 0.4e1 / 0.3e1 * t64 * t1759);
  t1768 = -t1625 / 0.2e1 + t1538 + t1550 / 0.2e1 - 0.3e1 / 0.2e1 * t1632 - 0.3e1 / 0.2e1 * t1639 - t1648 / 0.2e1 - 0.5e1 / 0.9e1 * t1424 - 0.3e1 / 0.2e1 * t401 * t912 - 0.3e1 / 0.8e1 * t163 * t107 * params->kappa * (-0.2618e4 / 0.243e3 * t31 * t68 * t1691 * t77 + 0.979e3 / 0.729e3 * t256 * t413 * t1697 * t77 - 0.44e2 / 0.243e3 * t612 * t1704 * t77 + 0.2e1 / 0.2187e4 * t1160 * t1709 * t1714 * t1715 + 0.2618e4 / 0.243e3 * t47 * t68 * t1691 * t80 - 0.979e3 / 0.729e3 * t274 * t413 * t1697 * t80 + 0.44e2 / 0.243e3 * t630 * t1704 * t80 - 0.2e1 / 0.2187e4 * t1184 * t1709 * t1714 * t1731) - 0.3e1 / 0.2e1 * t1740 * t176 - 0.9e1 / 0.4e1 * t870 * t431 - 0.5e1 / 0.9e1 * t1411 + t1528 / 0.2e1 + t1303 - 0.3e1 / 0.8e1 * t5 * t1763 * t26 * t83;
  t1769 = my_piecewise3(t58, 0, t1768);
  tv4rho44 = 0.4e1 * t852 + 0.4e1 * t916 + t6 * (t1681 + t1769);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1775 = t570 * t440;
  t1779 = t232 * t926;
  t1781 = t232 * t929;
  t1787 = 0.5e1 / 0.36e2 * t106 * t1207 * t190;
  t1789 = t106 * t587 * t463;
  t1792 = t106 * t241 * t956;
  t1794 = t35 * t595;
  t1798 = t258 * t602;
  t1802 = t615 * t259;
  t1809 = t611 / t39 / t600 / t512;
  t1811 = t613 * t30;
  t1834 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t1195 * t191 - 0.3e1 / 0.8e1 * t1775 - 0.9e1 / 0.8e1 * t570 * t464 + t1779 / 0.4e1 - 0.3e1 / 0.4e1 * t1781 - 0.9e1 / 0.8e1 * t232 * t957 - t1787 + t1789 / 0.4e1 - 0.3e1 / 0.8e1 * t1792 - 0.3e1 / 0.8e1 * t106 * t107 * params->kappa * (0.154e3 / 0.81e2 * t31 * t1794 * t45 - 0.341e3 / 0.972e3 * t256 * t1798 * t451 + 0.19e2 / 0.324e3 * t612 * t1802 * t45 - t1160 * t1809 * t1811 * t1168 / 0.2916e4 - 0.154e3 / 0.81e2 * t47 * t1794 * t50 + 0.341e3 / 0.972e3 * t274 * t1798 * t458 - 0.19e2 / 0.324e3 * t630 * t1802 * t50 + t1184 * t1809 * t1811 * t1186 / 0.2916e4));
  tv4rho3sigma0 = t6 * t1834 + 0.3e1 * t961;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t1839 = t750 * t472;
  t1841 = t357 * t968;
  t1845 = 0.5e1 / 0.36e2 * t163 * t1207 * t202;
  t1847 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t1416 * t203 - 0.3e1 / 0.8e1 * t1839 + t1841 / 0.4e1 - t1845);
  tv4rho3sigma2 = t6 * t1847 + 0.3e1 * t972;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1849 = 0.2e1 * t983;
  t1853 = t703 * t440 / 0.4e1;
  t1856 = t332 * t926;
  t1859 = t332 * t929 / 0.4e1;
  t1867 = -0.3e1 / 0.8e1 * t1310 * t191 - t1853 - 0.3e1 / 0.4e1 * t703 * t464 + t1856 / 0.12e2 - t1859 - 0.3e1 / 0.8e1 * t332 * t957 - t1775 / 0.8e1 + t1779 / 0.6e1 - t1781 / 0.4e1 - t1787 + t1789 / 0.6e1 - t1792 / 0.8e1;
  t1868 = my_piecewise3(t1, 0, t1867);
  tv4rho3sigma3 = t6 * t1868 + t1849 + t961;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t1870 = 0.2e1 * t996;
  t1874 = t815 * t472 / 0.4e1;
  t1875 = t401 * t968;
  t1882 = t357 * t992 / 0.4e1;
  t1884 = t163 * t587 * t505;
  t1887 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t1533 * t203 - t1874 + t1875 / 0.12e2 - t1839 / 0.8e1 + t1841 / 0.6e1 - t1845 - 0.3e1 / 0.8e1 * t750 * t506 - t1882 + t1884 / 0.12e2);
  tv4rho3sigma5 = t6 * t1887 + t1870 + t972;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t1891 = t784 * t440;
  t1899 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t1434 * t191 - t1891 / 0.8e1 - 0.3e1 / 0.8e1 * t784 * t464 - t1853 + t1856 / 0.6e1 - t1859 + t1779 / 0.12e2 - t1787 + t1789 / 0.12e2);
  tv4rho3sigma6 = t6 * t1899 + t1003 + t1849;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t1903 = t870 * t472;
  t1908 = t401 * t992;
  t1915 = t163 * t241 * t1036;
  t1917 = -0.3e1 / 0.8e1 * t1629 * t203 - t1903 / 0.8e1 - t1874 + t1875 / 0.6e1 - 0.3e1 / 0.4e1 * t815 * t506 - t1908 / 0.4e1 + t1841 / 0.12e2 - t1845 - t1882 + t1884 / 0.6e1 - 0.3e1 / 0.8e1 * t357 * t1037 - t1915 / 0.8e1;
  t1918 = my_piecewise3(t58, 0, t1917);
  tv4rho3sigma8 = t6 * t1918 + t1041 + t1870;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t1926 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t1587 * t191 - 0.3e1 / 0.8e1 * t1891 + t1856 / 0.4e1 - t1787);
  tv4rho3sigma9 = t6 * t1926 + 0.3e1 * t1003;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t1940 = t35 * t880;
  t1944 = t258 * t887;
  t1948 = t894 * t412;
  t1955 = t611 / t71 / t885 / t527;
  t1957 = t892 * t30;
  t1980 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t1740 * t203 - 0.3e1 / 0.8e1 * t1903 - 0.9e1 / 0.8e1 * t870 * t506 + t1875 / 0.4e1 - 0.3e1 / 0.4e1 * t1908 - 0.9e1 / 0.8e1 * t401 * t1037 - t1845 + t1884 / 0.4e1 - 0.3e1 / 0.8e1 * t1915 - 0.3e1 / 0.8e1 * t163 * t107 * params->kappa * (0.154e3 / 0.81e2 * t31 * t1940 * t77 - 0.341e3 / 0.972e3 * t256 * t1944 * t493 + 0.19e2 / 0.324e3 * t612 * t1948 * t77 - t1160 * t1955 * t1957 * t1715 / 0.2916e4 - 0.154e3 / 0.81e2 * t47 * t1940 * t80 + 0.341e3 / 0.972e3 * t274 * t1944 * t500 - 0.19e2 / 0.324e3 * t630 * t1948 * t80 + t1184 * t1955 * t1957 * t1731 / 0.2916e4));
  tv4rho3sigma11 = t6 * t1980 + 0.3e1 * t1041;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t1985 = t232 * t1045;
  t1991 = t106 * t587 * t522 / 0.12e2;
  t1993 = t106 * t241 * t1064;
  t1998 = t941 * sigma[0];
  t2004 = t611 / t39 / t1152;
  t2006 = t259 * t30;
  t2026 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t570 * t523 - t1985 / 0.4e1 - 0.3e1 / 0.4e1 * t232 * t1065 + t1991 - t1993 / 0.4e1 - 0.3e1 / 0.8e1 * t106 * t107 * params->kappa * (0.19e2 / 0.324e3 * t256 * t936 * t45 - 0.43e2 / 0.2592e4 * t612 * t1998 * t45 + t1160 * t2004 * t2006 * t1168 / 0.7776e4 - 0.19e2 / 0.324e3 * t274 * t936 * t50 + 0.43e2 / 0.2592e4 * t630 * t1998 * t50 - t1184 * t2004 * t2006 * t1186 / 0.7776e4));
  tv4rho2sigma20 = t6 * t2026 + 0.2e1 * t1069;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2031 = t357 * t1073;
  t2035 = t163 * t587 * t537 / 0.12e2;
  t2037 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t750 * t538 - t2031 / 0.4e1 + t2035);
  tv4rho2sigma25 = t6 * t2037 + 0.2e1 * t1077;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2041 = t332 * t1045;
  t2048 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t703 * t523 - t2041 / 0.8e1 - 0.3e1 / 0.8e1 * t332 * t1065 - t1985 / 0.8e1 + t1991 - t1993 / 0.8e1);
  tv4rho2sigma26 = t6 * t2048 + t1069 + t1082;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2052 = t401 * t1073;
  t2058 = t163 * t241 * t1102;
  t2061 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t815 * t538 - t2052 / 0.8e1 - t2031 / 0.8e1 + t2035 - 0.3e1 / 0.8e1 * t357 * t1103 - t2058 / 0.8e1);
  tv4rho2sigma211 = t6 * t2061 + t1077 + t1107;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2068 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t784 * t523 - t2041 / 0.4e1 + t1991);
  tv4rho2sigma212 = t6 * t2068 + 0.2e1 * t1082;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2080 = t1021 * sigma[2];
  t2086 = t611 / t71 / t1702;
  t2088 = t412 * t30;
  t2108 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t870 * t538 - t2052 / 0.4e1 - 0.3e1 / 0.4e1 * t401 * t1103 + t2035 - t2058 / 0.4e1 - 0.3e1 / 0.8e1 * t163 * t107 * params->kappa * (0.19e2 / 0.324e3 * t256 * t1016 * t77 - 0.43e2 / 0.2592e4 * t612 * t2080 * t77 + t1160 * t2086 * t2088 * t1715 / 0.7776e4 - 0.19e2 / 0.324e3 * t274 * t1016 * t80 + 0.43e2 / 0.2592e4 * t630 * t2080 * t80 - t1184 * t2086 * t2088 * t1731 / 0.7776e4));
  tv4rho2sigma217 = t6 * t2108 + 0.2e1 * t1107;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2114 = t106 * t241 * t1117 / 0.8e1;
  t2115 = t611 * t1052;
  t2121 = t611 / t39 / t614;
  t2123 = t30 * t35;
  t2140 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t232 * t1118 - t2114 - 0.3e1 / 0.8e1 * t106 * t107 * params->kappa * (t609 * t2115 * t45 / 0.288e3 - t1160 * t2121 * t2123 * t451 / 0.20736e5 - t629 * t2115 * t50 / 0.288e3 + t1184 * t2121 * t2123 * t458 / 0.20736e5));
  tv4rhosigma30 = t6 * t2140 + t1121;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2146 = t163 * t241 * t1130 / 0.8e1;
  t2148 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t357 * t1131 - t2146);
  tv4rhosigma39 = t6 * t2148 + t1134;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t332 * t1118 - t2114);
  tv4rhosigma310 = t6 * t2153 + t1121;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2157 = t611 * t1090;
  t2163 = t611 / t71 / t893;
  t2181 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t401 * t1131 - t2146 - 0.3e1 / 0.8e1 * t163 * t107 * params->kappa * (t609 * t2157 * t77 / 0.288e3 - t1160 * t2163 * t2123 * t493 / 0.20736e5 - t629 * t2157 * t80 / 0.288e3 + t1184 * t2163 * t2123 * t500 / 0.20736e5));
  tv4rhosigma319 = t6 * t2181 + t1134;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2183 = t1160 * t611;
  t2186 = 0.1e1 / t39 / t940 * t30;
  t2189 = t1184 * t611;
  t2198 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t106 * t107 * params->kappa * (t2183 * t2186 * t1168 / 0.55296e5 - t2189 * t2186 * t1186 / 0.55296e5));
  tv4sigma40 = t6 * t2198;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2201 = 0.1e1 / t71 / t1020 * t30;
  t2212 = my_piecewise3(t58, 0, -0.3e1 / 0.8e1 * t163 * t107 * params->kappa * (t2183 * t2201 * t1715 / 0.55296e5 - t2189 * t2201 * t1731 / 0.55296e5));
  tv4sigma414 = t6 * t2212;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

