// ./tests/catch2-tests [section] -s


/////////////////////// Qt includes
#include <QDebug>
#include <QString>
#include <QDir>


/////////////////////// IsoSpec
#include <IsoSpec++/isoSpec++.h>
#include <IsoSpec++/element_tables.h>


/////////////////////// Catch2 includes
#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>


/////////////////////// libXpertMassCore includes
#include <libXpertMass/PolChemDefSpec.hpp>


/////////////////////// Local includes
#include "tests-config.h"
#include "TestUtils.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{


SCENARIO("PolChemDefSpec specifying a polymer chemistry definition",
         "[PolChemDefSpec]")
{
  PolChemDefSpec pol_chem_def_spec;

  QString test_data_dir =
    QString("%1/polymer-chemistry-definitions").arg(TESTS_INPUT_DIR);

  QString pol_chem_def_name = "protein-1-letter.xml";

  QString pol_chem_def_relative_file_path =
    "protein-1-letter/protein-1-letter.xml";

  QString pol_chem_def_absolute_file_path =
    QString("%1/%2").arg(test_data_dir).arg(pol_chem_def_relative_file_path);

  GIVEN("Constructing an empty PolChemDefSpec")
  {

    THEN("The member data are empty")
    {
      REQUIRE(pol_chem_def_spec.getName().toStdString() == "");
      REQUIRE(pol_chem_def_spec.getFilePath().toStdString() == "");
    }
  }

  AND_GIVEN("Set name and file path")
  {
    pol_chem_def_spec.setName(pol_chem_def_name);
    pol_chem_def_spec.setFilePath(pol_chem_def_relative_file_path);

    THEN("The name and file path are set to the member data")
    {
      REQUIRE(pol_chem_def_spec.getName().toStdString() ==
              pol_chem_def_name.toStdString());
      REQUIRE(pol_chem_def_spec.getFilePath().toStdString() ==
              pol_chem_def_relative_file_path.toStdString());
    }
  }
}


} // namespace libXpertMassCore
} // namespace MsXpS
