
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileObsPlottingAttributes.h
    \brief Definition of ObsPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef ObsPlottingAttributes_H
#define ObsPlottingAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class ObsPlottingAttributes 
{
public:
//  --  constructor
    ObsPlottingAttributes();
    
//  --  destructor
    virtual ~ObsPlottingAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ObsPlottingAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double apart_;
	double size_;
	double ring_size_;
	bool present_ww_visible_;
	bool pressure_visible_;
	bool upper_air_visible_;
	bool pressure_tendency_visible_;
	bool station_ring_visible_;
	bool temperature_visible_;
	bool thickness_visible_;
	bool height_visible_;
	bool identifier_visible_;
	bool cloud_visible_;
	bool low_;
	bool medium_;
	bool high_;
	bool dewpoint_visible_;
	bool sea_temperature_visible_;
	bool waves_visible_;
	bool past_ww_visible_;
	bool time_plot_visible_;
	bool visibility_visible_;
	bool wind_visible_;
	bool wind_projected_;
	unique_ptr<Colour> colour_;
	unique_ptr<Colour> present_ww_colour_;
	unique_ptr<Colour> pressure_colour_;
	unique_ptr<Colour> upper_air_colour_;
	unique_ptr<Colour> pressure_tendency_colour_;
	unique_ptr<Colour> station_ring_colour_;
	unique_ptr<Colour> temperature_colour_;
	unique_ptr<Colour> thickness_colour_;
	unique_ptr<Colour> height_colour_;
	unique_ptr<Colour> identifier_colour_;
	unique_ptr<Colour> low_colour_;
	unique_ptr<Colour> medium_colour_;
	unique_ptr<Colour> high_colour_;
	unique_ptr<Colour> dewpoint_colour_;
	unique_ptr<Colour> sea_temperature_colour_;
	unique_ptr<Colour> waves_colour_;
	unique_ptr<Colour> past_ww_colour_;
	unique_ptr<Colour> time_plot_colour_;
	unique_ptr<Colour> visibility_colour_;
	unique_ptr<Colour> wind_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const ObsPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

