/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QVariant>
#include <QTreeView>
#include <QMainWindow>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "../nongui/globals.hpp"


namespace MsXpS
{

namespace MassXpert
{


enum
{
  MZ_CALC_LEVEL_COLUMN,
  MZ_CALC_MONO_COLUMN,
  MZ_CALC_AVG_COLUMN,
  MZ_CALC_TOTAL_COLUMNS
};


class MzCalculationTreeViewItem
{
  public:
  MzCalculationTreeViewItem(const QList<QVariant> &data,
                            MzCalculationTreeViewItem *parent = 0);

  ~MzCalculationTreeViewItem();

  MzCalculationTreeViewItem *parent();

  void appendChild(MzCalculationTreeViewItem *item);
  void insertChild(int index, MzCalculationTreeViewItem *item);

  MzCalculationTreeViewItem *child(int row);
  MzCalculationTreeViewItem *takeChild(int row);
  const QList<MzCalculationTreeViewItem *> &childItems();

  int childCount() const;
  int columnCount() const;

  QVariant data(int column) const;
  bool setData(int column, const QVariant &value);

  int row() const;

  void setIon(IonSPtr ion_sp);
  IonSPtr getIon();

  private:
  QList<MzCalculationTreeViewItem *> m_childItemsList;
  QList<QVariant> m_itemData;
  MzCalculationTreeViewItem *mp_parentItem;
  IonSPtr msp_ion = nullptr;
};


} // namespace MassXpert
} // namespace MsXpS
