/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// Qt includes
#include <QString>
#include <QMap>


/////////////////////// Local includes
#include "globals.hpp"


namespace MsXpS
{
namespace MassXpert
{


class ConfigSetting
{
  public:
  QString m_title;
  QString m_applicationName;

  // Is the key for user or system config settings (UserType::USER or
  // UserType::SYSTEM)?
  UserType m_userType;

  // The key is a string like dataDir or polChemDefsDir or docDir...
  QString m_key;

  // The value can be bool, int, double or QString.
  QVariant m_value;

  QString m_comment;
  QChar m_prefixDelimiter = gConfigKeyStringPrefixDelimiter;

  ConfigSetting(const QString &application_name);
  ConfigSetting(const ConfigSetting &other);
  ConfigSetting &operator=(const ConfigSetting &other);
  ~ConfigSetting();

  QString toString() const;
};

typedef std::shared_ptr<ConfigSetting> ConfigSettingSPtr;
typedef std::shared_ptr<const ConfigSetting> ConfigSettingCstSPtr;

} // namespace MassXpert
} // namespace MsXpS
