/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.messaging.MessageHandler;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.Log;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.chefproject.core.Calendar;
import org.chefproject.core.CalendarEvent;
import org.chefproject.core.Site;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.CalendarService;
import org.chefproject.service.SiteService;
import org.chefproject.util.CalendarEventVector;
import org.chefproject.util.CalendarUtil;
import org.chefproject.util.Time;
import org.chefproject.util.TimeBreakdown;
import org.chefproject.util.TimeRange;
import org.chefproject.util.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PrintFileGenerator {
    private static final String DAY_VIEW_XLST_FILENAME = "schedule.xsl";
    private static final String LIST_VIEW_XLST_FILENAME = "schlist.xsl";
    private static final String MONTH_VIEW_XLST_FILENAME = "schedulemm.xsl";
    private static final String WEEK_VIEW_XLST_FILENAME = "schedule.xsl";
    private static final String XSLT_BASE_DIRECTORY = "xslt";
    private static final String PDF_MIME_TYPE = "application/pdf";
    private static long MILLISECONDS_IN_DAY;
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_MINUTE = 60000L;
    private static final long MINIMUM_EVENT_LENGTH_IN_MSECONDS = 1740000L;
    private static final int SCHEDULE_INTERVAL_IN_MINUTES = 15;
    private static final int MAX_OVERLAPPING_COLUMNS = 7;
    private static final int TIMESLOT_FOR_OVERLAP_DETECTION_IN_MINUTES = 10;
    public static final int UNKNOWN_VIEW = -1;
    public static final int DAY_VIEW = 0;
    public static final int WEEK_VIEW = 2;
    public static final int MONTH_VIEW = 3;
    public static final int LIST_VIEW = 5;
    public static final String PRINT_REQUEST_NAME = "/PrintFileGeneration";
    private static final String PRINTING_REQUEST_NAME = "PrintFileGeneration";
    public static final String TIME_RANGE_PARAMETER_NAME = "timeRange";
    private static final String DAILY_START_TIME_PARAMETER_NAME = "dailyStartTime";
    private static final String USER_NAME_PARAMETER_NAME = "user";
    private static final String CALENDAR_PARAMETER_BASE_NAME = "calendar";
    private static final String SCHEDULE_TYPE_PARAMETER_NAME = "scheduleType";
    private static final String COLUMN_NODE_NAME = "col";
    private static final String EVENT_NODE_NAME = "event";
    private static final String FACULTY_EVENT_ATTRIBUTE_NAME = "Faculty";
    private static final String FACULTY_NODE = "faculty";
    private static final String FROM_ATTRIBUTE_STRING = "from";
    private static final String GROUP_NODE = "grp";
    private static final String LIST_DATE_ATTRIBUTE_NAME = "dt";
    private static final String LIST_DAY_OF_WEEK_ATTRIBUTE_NAME = "dayofweek";
    private static final String LIST_NODE_NAME = "list";
    private static final String MONTH_NODE_NAME = "month";
    private static final String MAX_CONCURRENT_EVENTS_NAME = "maxConcurrentEvents";
    private static final String PLACE_NODE = "place";
    private static final String ROW_NODE_NAME = "row";
    private static final String SCHEDULE_NODE = "schedule";
    private static final String START_DAY_WEEK_ATTRIBUTE_NAME = "startdayweek";
    private static final String START_TIME_ATTRIBUTE_NAME = "start-time";
    private static final String SUB_EVENT_NODE_NAME = "subEvent";
    private static final String TITLE_NODE = "title";
    private static final String TO_ATTRIBUTE_STRING = "to";
    private static final String TYPE_NODE = "type";
    private static final String UID_NODE = "uid";
    private static final String HOUR_MINUTE_SEPARATOR = ":";

    private static String dumpTimeRange(TimeRange timeRange) {
        String returnString = "";
        if (timeRange != null) {
            returnString = timeRange.firstTime().toStringLocalFull() + " - " + timeRange.lastTime().toStringLocalFull();
        }
        return returnString;
    }

    private static void dumpGeneratedXML(ServletContext servletContext, Document document) {
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        FileOutputStream out = null;
        XMLSerializer serial = null;
        try {
            out = new FileOutputStream(servletContext.getRealPath("output.xml"));
            serial = new XMLSerializer(out, format);
        }
        catch (FileNotFoundException e) {
            Log.debug("chef", "PrintFileGeneration.dumpGeneratedXML(): " + e);
        }
        try {
            serial.serialize(document);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Log.debug("chef", "PrintFileGeneration.dumpGeneratedXML(): " + e);
        }
    }

    private static void generatePDF(Document doc, String xslFileName, OutputStream streamOut) {
        Driver driver = new Driver();
        ConsoleLogger logger = new ConsoleLogger(3);
        MessageHandler.setScreenLogger((Logger)logger);
        driver.setLogger((Logger)logger);
        driver.setOutputStream(streamOut);
        driver.setRenderer(1);
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslFileName));
        }
        catch (TransformerException e) {
            Log.debug("chef", "PrintFileGeneration.generatePDF(): " + e);
            return;
        }
        DOMSource x = new DOMSource(doc);
        try {
            transformer.transform(x, new SAXResult(driver.getContentHandler()));
        }
        catch (TransformerException e1) {
            Log.debug("chef", "PrintFileGeneration.generatePDF(): " + e1);
            return;
        }
    }

    private static TimeRange getFullDayTimeRangeFromYMD(int year, int month, int day) {
        return new TimeRange(new Time("local", year, month, day, 0, 0, 0, 0), new Time("local", year, month, day, 23, 59, 59, 999));
    }

    private static List makeListViewTimeRangeList(TimeRange timeRange, List calendarReferenceList) {
        int DEFAULT_INITIAL_HASH_CAPACITY = 150;
        ArrayList<TimeRange> listOfDays = new ArrayList<TimeRange>();
        CalendarEventVector calendarEventVector = CalendarService.getEvents(calendarReferenceList, timeRange);
        Iterator itEvents = calendarEventVector.iterator();
        HashMap<String, String> datesSeenSoFar = new HashMap<String, String>(150);
        while (itEvents.hasNext()) {
            CalendarEvent event = (CalendarEvent)itEvents.next();
            ArrayList timeRangeList = PrintFileGenerator.splitTimeRangeIntoListOfSingleDayTimeRanges(event.getRange(), null);
            Iterator itDatesInRange = timeRangeList.iterator();
            while (itDatesInRange.hasNext()) {
                TimeRange curDay = (TimeRange)itDatesInRange.next();
                String curDate = curDay.firstTime().toStringLocalDate();
                if (datesSeenSoFar.containsKey(curDate)) continue;
                TimeBreakdown startBreakDown = curDay.firstTime().breakdownLocal();
                listOfDays.add(PrintFileGenerator.getFullDayTimeRangeFromYMD(startBreakDown.year, startBreakDown.month, startBreakDown.day));
                datesSeenSoFar.put(curDate, "");
            }
        }
        return listOfDays;
    }

    /*
     * Unable to fully structure code
     */
    private static void generateXMLDocument(int scheduleType, Document doc, TimeRange timeRange, TimeRange dailyTimeRange, List calendarReferenceList, String userID) {
        block16: {
            timeRangeList = null;
            actualTimeRange = null;
            topLevelMaxConcurrentEvents = null;
            switch (scheduleType) {
                case 2: {
                    actualTimeRange = timeRange;
                    timeRangeList = PrintFileGenerator.getTimeRangeListForWeek(actualTimeRange, calendarReferenceList, dailyTimeRange, true);
                    break;
                }
                case 3: {
                    actualTimeRange = PrintFileGenerator.shrinkTimeRangeToCurrentMonth(timeRange);
                    timeRangeList = PrintFileGenerator.splitTimeRangeIntoListOfSingleDayTimeRanges(actualTimeRange, null);
                    break;
                }
                case 5: {
                    actualTimeRange = timeRange;
                    timeRangeList = PrintFileGenerator.makeListViewTimeRangeList(actualTimeRange, calendarReferenceList);
                    break;
                }
                case 0: {
                    actualTimeRange = timeRange;
                    timeRangeList = PrintFileGenerator.splitTimeRangeIntoListOfSingleDayTimeRanges(actualTimeRange, dailyTimeRange);
                    break;
                }
                default: {
                    Log.debug("chef", "PrintFileGeneration.generateXMLDocument(): bad scheduleType parameter = " + scheduleType);
                }
            }
            if (timeRangeList == null) break block16;
            root = doc.createElement("schedule");
            if (userID != null) {
                PrintFileGenerator.writeStringNodeToDom(doc, root, "uid", userID);
            }
            topLevelMaxConcurrentEvents = PrintFileGenerator.writeStringNodeToDom(doc, root, "maxConcurrentEvents", "1");
            PrintFileGenerator.writeStringNodeToDom(doc, root, "start-time", PrintFileGenerator.getTimeString(dailyTimeRange.firstTime()));
            doc.appendChild(root);
            if (scheduleType == 3) {
                monthCalendar = new CalendarUtil();
                breakDown = actualTimeRange.firstTime().breakdownLocal();
                monthCalendar.setDay(breakDown.getYear(), breakDown.getMonth(), breakDown.getDay());
                firstDayOfMonth = monthCalendar.getFirstDayOfMonth(breakDown.getMonth() - 1);
                monthElement = doc.createElement("month");
                monthElement.setAttribute("startdayweek", Integer.toString(firstDayOfMonth));
                root.appendChild(monthElement);
            }
            itList = timeRangeList.iterator();
            maxNumberOfColumnsPerRow = 1;
            while (itList.hasNext()) {
                block17: {
                    currentTimeRange = (TimeRange)itList.next();
                    maxConcurrentEventsOverListNode = 1;
                    calendarEventVector = CalendarService.getEvents(calendarReferenceList, currentTimeRange);
                    if (scheduleType == 5 && calendarEventVector.size() == 0) continue;
                    eventList = doc.createElement("list");
                    eventList.setAttribute("dt", PrintFileGenerator.getDateFromTime(currentTimeRange.firstTime()));
                    eventList.setAttribute("maxConcurrentEvents", Integer.toString(maxConcurrentEventsOverListNode));
                    cal = new CalendarUtil();
                    date = currentTimeRange.firstTime();
                    breakdown = date.breakdownLocal();
                    cal.setDay(breakdown.year, breakdown.month, breakdown.day);
                    eventList.setAttribute("dayofweek", Integer.toString(cal.getDay_Of_Week() - 1));
                    root.appendChild(eventList);
                    itEvent = calendarEventVector.iterator();
                    if (scheduleType != 0 && scheduleType != 2) ** GOTO lbl100
                    layoutTable = new SingleDayLayoutTable(currentTimeRange, 7, 15);
                    while (itEvent.hasNext()) {
                        event = (CalendarEvent)itEvent.next();
                        layoutTable.addEvent(event);
                    }
                    layoutRows = layoutTable.getLayoutRows();
                    rowIterator = layoutRows.iterator();
                    while (rowIterator.hasNext()) {
                        layoutRow = (LayoutRow)rowIterator.next();
                        rowTimeRange = layoutRow.getRowTimeRange();
                        if (maxNumberOfColumnsPerRow < layoutRow.size()) {
                            maxNumberOfColumnsPerRow = layoutRow.size();
                        }
                        if (maxConcurrentEventsOverListNode < layoutRow.size()) {
                            maxConcurrentEventsOverListNode = layoutRow.size();
                        }
                        eventNode = doc.createElement("event");
                        eventList.appendChild(eventNode);
                        eventNode.setAttribute("from", PrintFileGenerator.getTimeString(rowTimeRange.firstTime()));
                        eventNode.setAttribute("to", PrintFileGenerator.getTimeString(PrintFileGenerator.performEndMinuteKludge(rowTimeRange.lastTime().breakdownLocal())));
                        rowNode = doc.createElement("row");
                        rowNode.setAttribute("maxConcurrentEvents", Integer.toString(layoutRow.size()));
                        eventNode.appendChild(rowNode);
                        layoutRowIterator = layoutRow.iterator();
                        while (layoutRowIterator.hasNext()) {
                            columnNode = doc.createElement("col");
                            rowNode.appendChild(columnNode);
                            columnList = (List)layoutRowIterator.next();
                            columnListIterator = columnList.iterator();
                            while (columnListIterator.hasNext()) {
                                event = (CalendarEvent)columnListIterator.next();
                                PrintFileGenerator.generateXMLEvent(doc, columnNode, event, "subEvent", rowTimeRange, true, false, false);
                            }
                        }
                    }
                    break block17;
lbl-1000:
                    // 1 sources

                    {
                        event = (CalendarEvent)itEvent.next();
                        PrintFileGenerator.generateXMLEvent(doc, eventList, event, "event", currentTimeRange, false, false, scheduleType == 5);
lbl100:
                        // 2 sources

                        ** while (itEvent.hasNext())
                    }
                }
                eventList.setAttribute("maxConcurrentEvents", Integer.toString(maxConcurrentEventsOverListNode));
            }
            topLevelMaxConcurrentEvents.getFirstChild().setNodeValue(Integer.toString(maxNumberOfColumnsPerRow));
        }
    }

    private static TimeRange trimTimeRange(TimeRange containingRange, TimeRange rangeToTrim) {
        long containingRangeStartTime = containingRange.firstTime().getTime();
        long containingRangeEndTime = containingRange.lastTime().getTime();
        long rangeToTrimStartTime = rangeToTrim.firstTime().getTime();
        long rangeToTrimEndTime = rangeToTrim.lastTime().getTime();
        long trimmedStartTime = 0L;
        long trimmedEndTime = 0L;
        trimmedStartTime = Math.min(Math.max(containingRangeStartTime, rangeToTrimStartTime), containingRangeEndTime);
        trimmedEndTime = Math.max(Math.min(containingRangeEndTime, rangeToTrimEndTime), rangeToTrimStartTime);
        return new TimeRange(new Time(trimmedStartTime), new Time(trimmedEndTime), true, false);
    }

    private static TimeRange roundRangeToMinimumTimeInterval(TimeRange timeRange) {
        TimeRange roundedTimeRange = timeRange;
        if (timeRange.duration() < 1740000L) {
            roundedTimeRange = new TimeRange(timeRange.firstTime().getTime(), 1740000L);
        }
        return roundedTimeRange;
    }

    private static void generateXMLEvent(Document doc, Element parent, CalendarEvent event, String eventNodeName, TimeRange containingTimeRange, boolean forceMinimumTime, boolean hideGroupIfNoSpace, boolean performEndTimeKludge) {
        Element eventElement = doc.createElement(eventNodeName);
        TimeRange trimmedTimeRange = PrintFileGenerator.trimTimeRange(containingTimeRange, event.getRange());
        if (forceMinimumTime) {
            trimmedTimeRange = PrintFileGenerator.roundRangeToMinimumTimeInterval(trimmedTimeRange);
        }
        eventElement.setAttribute(FROM_ATTRIBUTE_STRING, PrintFileGenerator.getTimeString(trimmedTimeRange.firstTime()));
        Time endTime = null;
        endTime = performEndTimeKludge ? PrintFileGenerator.performEndMinuteKludge(trimmedTimeRange.lastTime().breakdownLocal()) : trimmedTimeRange.lastTime();
        eventElement.setAttribute(TO_ATTRIBUTE_STRING, PrintFileGenerator.getTimeString(endTime));
        if (!hideGroupIfNoSpace || trimmedTimeRange.duration() > 1740000L) {
            PrintFileGenerator.writeStringNodeToDom(doc, eventElement, GROUP_NODE, PrintFileGenerator.getSiteName(event));
        }
        PrintFileGenerator.writeStringNodeToDom(doc, eventElement, TITLE_NODE, event.getDisplayName());
        PrintFileGenerator.writeStringNodeToDom(doc, eventElement, TYPE_NODE, event.getType());
        PrintFileGenerator.writeStringNodeToDom(doc, eventElement, PLACE_NODE, event.getLocation());
        PrintFileGenerator.writeStringNodeToDom(doc, eventElement, FACULTY_NODE, event.getField(FACULTY_EVENT_ATTRIBUTE_NAME));
        parent.appendChild(eventElement);
    }

    public static String getAccessUrl() {
        return PrintFileGenerator.getServerUrl() + "/access";
    }

    private static List getCalendarListFromParameters(Properties parameters) {
        int curParameterNumber = 0;
        ArrayList<String> calendarList = new ArrayList<String>();
        String calendarReference = null;
        do {
            if ((calendarReference = (String)parameters.get(CALENDAR_PARAMETER_BASE_NAME + curParameterNumber++)) == null) continue;
            calendarList.add(calendarReference);
        } while (calendarReference != null);
        return calendarList;
    }

    private static String getCalendarListParameters(List calendars) {
        Iterator it = calendars.iterator();
        int calendarNumber = 0;
        StringBuffer parameters = new StringBuffer();
        boolean firstTime = true;
        while (it.hasNext()) {
            String calendarReference = (String)it.next();
            if (!firstTime) {
                parameters.append("&");
            } else {
                firstTime = false;
            }
            parameters.append(CALENDAR_PARAMETER_BASE_NAME + calendarNumber++ + "=" + Validator.escapeHtml(calendarReference));
        }
        return parameters.toString();
    }

    private static TimeRange getDailyStartTimeFromParameters(Properties parameters) {
        return PrintFileGenerator.getTimeRangeParameterByName(parameters, DAILY_START_TIME_PARAMETER_NAME);
    }

    private static String getDateFromTime(Time time) {
        TimeBreakdown timeBreakdown = time.breakdownLocal();
        return timeBreakdown.month + "/" + timeBreakdown.day + "/" + timeBreakdown.year;
    }

    private static int getScheduleTypeFromParameterList(Properties parameters) {
        int scheduleType = -1;
        String scheduleTypeString = (String)parameters.get(SCHEDULE_TYPE_PARAMETER_NAME);
        scheduleType = Integer.parseInt(scheduleTypeString);
        return scheduleType;
    }

    private static String getServerName() {
        return PrintFileGenerator.getString("server.name", "localhost");
    }

    private static String getServerUrl() {
        String port = PrintFileGenerator.getString("server.port", "");
        return PrintFileGenerator.getString("server.transport", "http") + "://" + PrintFileGenerator.getServerName() + port + "/" + PrintFileGenerator.getString("server.path.chef", "chef");
    }

    private static String getSiteName(CalendarEvent event) {
        Calendar calendar = null;
        String calendarName = "";
        try {
            calendar = CalendarService.getCalendar(event.getCalendarReference());
        }
        catch (IdUnusedException e) {
            Log.debug("chef", "PrintFileGeneration.getGroupName(): " + e);
        }
        catch (PermissionException e) {
            Log.debug("chef", "PrintFileGeneration.getGroupName(): " + e);
        }
        if (calendar != null) {
            Site site = null;
            try {
                site = SiteService.getSite(calendar.getContext());
                if (site != null) {
                    calendarName = site.getTitle();
                }
            }
            catch (IdUnusedException e1) {
                Log.debug("chef", "PrintFileGeneration.getGroupName(): " + e1);
            }
        }
        return calendarName;
    }

    private static String getString(String name, String dflt) {
        return JetspeedResources.getString((String)name, (String)dflt);
    }

    static TimeRange getTimeRangeFromParameters(Properties parameters) {
        return PrintFileGenerator.getTimeRangeParameterByName(parameters, TIME_RANGE_PARAMETER_NAME);
    }

    private static ArrayList getTimeRangeListForWeek(TimeRange timeRange, List calendarReferenceList, TimeRange dailyTimeRange, boolean skipSaturdayAndSundayIfNoEvents) {
        TimeBreakdown startBreakdown = timeRange.firstTime().breakdownLocal();
        GregorianCalendar startCalendarDate = new GregorianCalendar();
        startCalendarDate.set(startBreakdown.year, startBreakdown.month - 1, startBreakdown.day, 0, 0, 0);
        ArrayList<TimeRange> weekDayTimeRanges = new ArrayList<TimeRange>();
        int sundayDayIndex = 0;
        int saturdayDayIndex = 6;
        boolean skipSaturdayAndSunday = false;
        TimeBreakdown startBreakDown = dailyTimeRange.firstTime().breakdownLocal();
        TimeBreakdown endBreakDown = dailyTimeRange.lastTime().breakdownLocal();
        int i = sundayDayIndex;
        while (i <= saturdayDayIndex) {
            CalendarEventVector calendarEventVectorSunday;
            Time curStartTime = new Time("local", startCalendarDate.get(1), startCalendarDate.get(2) + 1, startCalendarDate.get(5), startBreakDown.getHour(), startBreakDown.getMin(), startBreakDown.getSec(), startBreakDown.getMs());
            Time curEndTime = new Time("local", startCalendarDate.get(1), startCalendarDate.get(2) + 1, startCalendarDate.get(5), endBreakDown.getHour(), endBreakDown.getMin(), endBreakDown.getSec(), endBreakDown.getMs());
            TimeRange newTimeRange = new TimeRange(curStartTime, curEndTime, true, false);
            if (skipSaturdayAndSundayIfNoEvents && i == sundayDayIndex && (calendarEventVectorSunday = CalendarService.getEvents(calendarReferenceList, newTimeRange)).isEmpty()) {
                GregorianCalendar saturdayCalendarDate = (GregorianCalendar)startCalendarDate.clone();
                saturdayCalendarDate.set(7, 7);
                Time saturdayStartTime = new Time("local", saturdayCalendarDate.get(1), saturdayCalendarDate.get(2) + 1, saturdayCalendarDate.get(5), startBreakDown.getHour(), startBreakDown.getMin(), startBreakDown.getSec(), startBreakDown.getMs());
                Time saturdayEndTime = new Time("local", saturdayCalendarDate.get(1), saturdayCalendarDate.get(2) + 1, saturdayCalendarDate.get(5), endBreakDown.getHour(), endBreakDown.getMin(), endBreakDown.getSec(), endBreakDown.getMs());
                TimeRange saturdayTimeRange = new TimeRange(saturdayStartTime, saturdayEndTime, true, false);
                CalendarEventVector calendarEventVectorSaturday = CalendarService.getEvents(calendarReferenceList, saturdayTimeRange);
                if (calendarEventVectorSaturday.isEmpty()) {
                    skipSaturdayAndSunday = true;
                }
            }
            if (i != sundayDayIndex && i != saturdayDayIndex || !skipSaturdayAndSunday) {
                weekDayTimeRanges.add(newTimeRange);
            }
            startCalendarDate.add(5, 1);
            ++i;
        }
        return weekDayTimeRanges;
    }

    private static TimeRange getTimeRangeParameterByName(Properties parameters, String name) {
        String timeRangeString = (String)parameters.get(name);
        TimeRange timeRange = null;
        try {
            timeRange = new TimeRange(timeRangeString);
        }
        catch (TimeRange.Invalid e) {
            Log.debug("chef", "PrintFileGeneration.getTimeRangeFromParameters(): " + e);
        }
        return timeRange;
    }

    private static String getTimeString(Time time) {
        TimeBreakdown timeBreakdown = time.breakdownLocal();
        DecimalFormat twoDecimalDigits = new DecimalFormat("00");
        return timeBreakdown.getHour() + HOUR_MINUTE_SEPARATOR + twoDecimalDigits.format(timeBreakdown.getMin());
    }

    private static String getXSLFileNameForScheduleType(int scheduleType, ServletContext servletContext) {
        String baseFileName = "";
        String fullPath = "";
        boolean goodScheduleType = false;
        switch (scheduleType) {
            case 2: {
                baseFileName = "schedule.xsl";
                goodScheduleType = true;
                break;
            }
            case 0: {
                baseFileName = "schedule.xsl";
                goodScheduleType = true;
                break;
            }
            case 3: {
                baseFileName = MONTH_VIEW_XLST_FILENAME;
                goodScheduleType = true;
                break;
            }
            case 5: {
                baseFileName = LIST_VIEW_XLST_FILENAME;
                goodScheduleType = true;
                break;
            }
            default: {
                Log.debug("chef", "PrintFileGeneration.getXSLFileNameForScheduleType(): unexpected scehdule type = " + scheduleType);
            }
        }
        if (goodScheduleType) {
            fullPath = servletContext.getRealPath("xslt/" + baseFileName);
        }
        return fullPath;
    }

    private static Time performEndMinuteKludge(TimeBreakdown breakDown) {
        int endMin = breakDown.min;
        int endHour = breakDown.hour;
        int tmpMinVal = endMin % 10;
        if ((tmpMinVal == 4 || tmpMinVal == 9) && ++endMin == 60) {
            endMin = 0;
            ++endHour;
        }
        return new Time("local", breakDown.year, breakDown.month, breakDown.day, endHour, endMin, breakDown.sec, breakDown.ms);
    }

    public static void printSchedule(Properties parameters, StringBuffer contentType, ServletContext servletContext, OutputStream os) {
        String userName = (String)parameters.get(USER_NAME_PARAMETER_NAME);
        List calendarReferenceList = PrintFileGenerator.getCalendarListFromParameters(parameters);
        int scheduleType = PrintFileGenerator.getScheduleTypeFromParameterList(parameters);
        TimeRange timeRange = PrintFileGenerator.getTimeRangeFromParameters(parameters);
        DocumentImpl document = new DocumentImpl();
        PrintFileGenerator.generateXMLDocument(scheduleType, document, timeRange, PrintFileGenerator.getDailyStartTimeFromParameters(parameters), calendarReferenceList, userName);
        PrintFileGenerator.generatePDF(document, PrintFileGenerator.getXSLFileNameForScheduleType(scheduleType, servletContext), os);
        if (contentType != null) {
            contentType.setLength(0);
            contentType.append(PDF_MIME_TYPE);
        }
    }

    private static TimeRange shrinkTimeRangeToCurrentMonth(TimeRange expandedTimeRange) {
        long millisecondsInWeek = 7L * MILLISECONDS_IN_DAY;
        Time startTime = expandedTimeRange.firstTime();
        Time somewhereInTheMonthTime = new Time(startTime.getTime() + 2L * millisecondsInWeek);
        TimeBreakdown somewhereInTheMonthBreakdown = somewhereInTheMonthTime.breakdownLocal();
        CalendarUtil calendar = new CalendarUtil();
        calendar.setDay(somewhereInTheMonthBreakdown.year, somewhereInTheMonthBreakdown.month, somewhereInTheMonthBreakdown.day);
        int numDaysInMonth = calendar.getNumberOfDays();
        return new TimeRange(new Time("local", somewhereInTheMonthBreakdown.year, somewhereInTheMonthBreakdown.month, 1, 0, 0, 0, 0), new Time("local", somewhereInTheMonthBreakdown.year, somewhereInTheMonthBreakdown.month, numDaysInMonth, 23, 59, 59, 999));
    }

    private static long getNumberDaysGivenTwoDates(int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay) {
        GregorianCalendar startDate = new GregorianCalendar();
        GregorianCalendar endDate = new GregorianCalendar();
        startDate.set(startYear, startMonth, startDay, 0, 0, 0);
        endDate.set(endYear, endMonth, endDay, 0, 0, 0);
        long duration = endDate.getTime().getTime() - startDate.getTime().getTime();
        return (duration + 3600000L) / 86400000L + 1L;
    }

    private static ArrayList splitTimeRangeIntoListOfSingleDayTimeRanges(TimeRange timeRange, TimeRange dailyTimeRange) {
        TimeBreakdown startBreakdown = timeRange.firstTime().breakdownLocal();
        TimeBreakdown endBreakdown = timeRange.lastTime().breakdownLocal();
        GregorianCalendar startCalendarDate = new GregorianCalendar();
        startCalendarDate.set(startBreakdown.year, startBreakdown.month - 1, startBreakdown.day, 0, 0, 0);
        long numDaysInTimeRange = PrintFileGenerator.getNumberDaysGivenTwoDates(startBreakdown.year, startBreakdown.month - 1, startBreakdown.day, endBreakdown.year, endBreakdown.month - 1, endBreakdown.day);
        ArrayList<TimeRange> splitTimeRanges = new ArrayList<TimeRange>();
        TimeBreakdown dailyStartBreakDown = null;
        TimeBreakdown dailyEndBreakDown = null;
        if (dailyTimeRange != null) {
            dailyStartBreakDown = dailyTimeRange.firstTime().breakdownLocal();
            dailyEndBreakDown = dailyTimeRange.lastTime().breakdownLocal();
        }
        long i = 0L;
        while (i < numDaysInTimeRange) {
            Time curStartTime = null;
            Time curEndTime = null;
            if (dailyTimeRange != null) {
                curStartTime = new Time("local", startCalendarDate.get(1), startCalendarDate.get(2) + 1, startCalendarDate.get(5), dailyStartBreakDown.getHour(), dailyStartBreakDown.getMin(), dailyStartBreakDown.getSec(), dailyStartBreakDown.getMs());
                curEndTime = new Time("local", startCalendarDate.get(1), startCalendarDate.get(2) + 1, startCalendarDate.get(5), dailyEndBreakDown.getHour(), dailyEndBreakDown.getMin(), dailyEndBreakDown.getSec(), dailyEndBreakDown.getMs());
                splitTimeRanges.add(new TimeRange(curStartTime, curEndTime, true, false));
            } else {
                splitTimeRanges.add(PrintFileGenerator.getFullDayTimeRangeFromYMD(startCalendarDate.get(1), startCalendarDate.get(2) + 1, startCalendarDate.get(5)));
            }
            startCalendarDate.add(5, 1);
            ++i;
        }
        return splitTimeRanges;
    }

    public static String submissionsPrintingReference(int scheduleType, List calendars, String timeRangeString, String userName, TimeRange dailyTimeRange) {
        String REFERENCE_ROOT = PRINT_REQUEST_NAME;
        return REFERENCE_ROOT + "?" + SCHEDULE_TYPE_PARAMETER_NAME + "=" + Validator.escapeHtml(new Integer(scheduleType).toString()) + "&" + PrintFileGenerator.getCalendarListParameters(calendars) + "&" + TIME_RANGE_PARAMETER_NAME + "=" + timeRangeString + "&" + Validator.escapeHtml(USER_NAME_PARAMETER_NAME) + "=" + Validator.escapeHtml(userName) + "&" + DAILY_START_TIME_PARAMETER_NAME + "=" + Validator.escapeHtml(dailyTimeRange.toString());
    }

    private static Element writeStringNodeToDom(Document doc, Element parent, String nodeName, String nodeValue) {
        if (nodeValue != null && nodeValue.length() != 0) {
            Element name = doc.createElement(nodeName);
            name.appendChild(doc.createTextNode(nodeValue));
            parent.appendChild(name);
            return name;
        }
        return null;
    }

    static {
        DAY_VIEW_XLST_FILENAME = "schedule.xsl";
        LIST_VIEW_XLST_FILENAME = LIST_VIEW_XLST_FILENAME;
        MONTH_VIEW_XLST_FILENAME = MONTH_VIEW_XLST_FILENAME;
        WEEK_VIEW_XLST_FILENAME = "schedule.xsl";
        XSLT_BASE_DIRECTORY = XSLT_BASE_DIRECTORY;
        PDF_MIME_TYPE = PDF_MIME_TYPE;
        MILLISECONDS_IN_DAY = 86400000L;
        MILLISECONDS_IN_HOUR = 3600000L;
        MILLISECONDS_IN_MINUTE = 60000L;
        MINIMUM_EVENT_LENGTH_IN_MSECONDS = 1740000L;
        SCHEDULE_INTERVAL_IN_MINUTES = 15;
        MAX_OVERLAPPING_COLUMNS = 7;
        TIMESLOT_FOR_OVERLAP_DETECTION_IN_MINUTES = 10;
        UNKNOWN_VIEW = -1;
        DAY_VIEW = 0;
        WEEK_VIEW = 2;
        MONTH_VIEW = 3;
        LIST_VIEW = 5;
        PRINT_REQUEST_NAME = PRINT_REQUEST_NAME;
        PRINTING_REQUEST_NAME = PRINTING_REQUEST_NAME;
        TIME_RANGE_PARAMETER_NAME = TIME_RANGE_PARAMETER_NAME;
        DAILY_START_TIME_PARAMETER_NAME = DAILY_START_TIME_PARAMETER_NAME;
        USER_NAME_PARAMETER_NAME = USER_NAME_PARAMETER_NAME;
        CALENDAR_PARAMETER_BASE_NAME = CALENDAR_PARAMETER_BASE_NAME;
        SCHEDULE_TYPE_PARAMETER_NAME = SCHEDULE_TYPE_PARAMETER_NAME;
        COLUMN_NODE_NAME = COLUMN_NODE_NAME;
        EVENT_NODE_NAME = EVENT_NODE_NAME;
        FACULTY_EVENT_ATTRIBUTE_NAME = FACULTY_EVENT_ATTRIBUTE_NAME;
        FACULTY_NODE = FACULTY_NODE;
        FROM_ATTRIBUTE_STRING = FROM_ATTRIBUTE_STRING;
        GROUP_NODE = GROUP_NODE;
        LIST_DATE_ATTRIBUTE_NAME = LIST_DATE_ATTRIBUTE_NAME;
        LIST_DAY_OF_WEEK_ATTRIBUTE_NAME = LIST_DAY_OF_WEEK_ATTRIBUTE_NAME;
        LIST_NODE_NAME = LIST_NODE_NAME;
        MONTH_NODE_NAME = MONTH_NODE_NAME;
        MAX_CONCURRENT_EVENTS_NAME = MAX_CONCURRENT_EVENTS_NAME;
        PLACE_NODE = PLACE_NODE;
        ROW_NODE_NAME = ROW_NODE_NAME;
        SCHEDULE_NODE = SCHEDULE_NODE;
        START_DAY_WEEK_ATTRIBUTE_NAME = START_DAY_WEEK_ATTRIBUTE_NAME;
        START_TIME_ATTRIBUTE_NAME = START_TIME_ATTRIBUTE_NAME;
        SUB_EVENT_NODE_NAME = SUB_EVENT_NODE_NAME;
        TITLE_NODE = TITLE_NODE;
        TO_ATTRIBUTE_STRING = TO_ATTRIBUTE_STRING;
        TYPE_NODE = TYPE_NODE;
        UID_NODE = UID_NODE;
        HOUR_MINUTE_SEPARATOR = HOUR_MINUTE_SEPARATOR;
    }

    static class LayoutTableCell {
        private CalendarEvent calendarEvent = null;
        private int firstCellColumn = -1;
        private int firstCellRow = -1;
        private boolean isFirstCell = false;
        private int numCellsInEvent = 0;
        private int thisCellColumn = -1;
        private int thisCellRow = -1;

        LayoutTableCell() {
        }

        public CalendarEvent getCalendarEvent() {
            return this.calendarEvent;
        }

        public int getFirstCellColumn() {
            return this.firstCellColumn;
        }

        public int getFirstCellRow() {
            return this.firstCellRow;
        }

        public int getNumCellsInEvent() {
            return this.numCellsInEvent;
        }

        public int getThisCellColumn() {
            return this.thisCellColumn;
        }

        public int getThisCellRow() {
            return this.thisCellRow;
        }

        public boolean isContinuationCell() {
            return !this.isFirstCell() && !this.isEmptyCell();
        }

        public boolean isEmptyCell() {
            return this.calendarEvent == null;
        }

        public boolean isFirstCell() {
            return this.isFirstCell;
        }

        public void setCalendarEvent(CalendarEvent event) {
            this.calendarEvent = event;
        }

        public void setFirstCell(boolean b) {
            this.isFirstCell = b;
        }

        public void setFirstCellColumn(int i) {
            this.firstCellColumn = i;
        }

        public void setFirstCellRow(int i) {
            this.firstCellRow = i;
        }

        public void setNumCellsInEvent(int i) {
            this.numCellsInEvent = i;
        }

        public void setThisCellColumn(int i) {
            this.thisCellColumn = i;
        }

        public void setThisCellRow(int i) {
            this.thisCellRow = i;
        }
    }

    private static class SingleDayLayoutTable {
        private long millisecondsPerTimeslot;
        private int numCols;
        private int numRows;
        private ArrayList rows;
        private TimeRange timeRange;

        public SingleDayLayoutTable(TimeRange timeRange, int maxNumberOverlappingEvents, int timeslotInMinutes) {
            this.timeRange = timeRange;
            this.numCols = maxNumberOverlappingEvents;
            this.millisecondsPerTimeslot = (long)timeslotInMinutes * 60000L;
            this.numRows = this.getNumberOfRowsNeeded(timeRange);
            this.rows = new ArrayList(this.numRows);
            int i = 0;
            while (i < this.numRows) {
                ArrayList<LayoutTableCell> newRow = new ArrayList<LayoutTableCell>(this.numCols);
                this.rows.add(i, newRow);
                int j = 0;
                while (j < this.numCols) {
                    newRow.add(j, new LayoutTableCell());
                    ++j;
                }
                ++i;
            }
        }

        void addEvent(CalendarEvent calendarEvent) {
            int columnNumber;
            int numRowsNeeded;
            if (calendarEvent == null) {
                return;
            }
            int startingRow = this.getStartingRow(PrintFileGenerator.roundRangeToMinimumTimeInterval(calendarEvent.getRange()));
            if (startingRow + (numRowsNeeded = this.getNumberOfRowsNeeded(PrintFileGenerator.roundRangeToMinimumTimeInterval(calendarEvent.getRange()))) >= this.getNumRows()) {
                numRowsNeeded = this.getNumRows() - startingRow;
            }
            if ((columnNumber = this.getFreeColumn(startingRow, numRowsNeeded)) != -1) {
                int i = startingRow;
                while (i < startingRow + numRowsNeeded) {
                    LayoutTableCell cell = this.getCell(i, columnNumber);
                    cell.setCalendarEvent(calendarEvent);
                    if (i == startingRow) {
                        cell.setFirstCell(true);
                    }
                    cell.setFirstCellRow(startingRow);
                    cell.setFirstCellColumn(columnNumber);
                    cell.setThisCellRow(i);
                    cell.setThisCellColumn(columnNumber);
                    cell.setNumCellsInEvent(numRowsNeeded);
                    ++i;
                }
            }
        }

        private TimeRange adjustTimeRangeToLayoutTable(TimeRange eventTimeRange) {
            Time lowerBound = null;
            Time upperBound = null;
            lowerBound = this.timeRange.firstTime().compareTo(eventTimeRange.firstTime()) > 0 ? this.timeRange.firstTime() : eventTimeRange.firstTime();
            upperBound = this.timeRange.lastTime().compareTo(eventTimeRange.lastTime()) < 0 ? this.timeRange.lastTime() : eventTimeRange.lastTime();
            return new TimeRange(lowerBound, upperBound, true, false);
        }

        private boolean cellHasOverlappingEvents(int rowNum, int colNum) {
            LayoutTableCell cell = this.getFirstCell(rowNum, colNum);
            if (cell != null && !cell.isEmptyCell()) {
                int i = cell.getFirstCellRow();
                while (i < cell.getFirstCellRow() + cell.getNumCellsInEvent()) {
                    int j = 0;
                    while (j < this.numCols) {
                        LayoutTableCell curCell = this.getCell(i, j);
                        if (curCell != null && !curCell.isEmptyCell() && curCell.getCalendarEvent() != cell.getCalendarEvent()) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return false;
        }

        private LayoutTableCell getCell(int rowNum, int colNum) {
            if (rowNum < 0 || rowNum >= this.numRows || colNum < 0 || colNum >= this.numCols) {
                return null;
            }
            ArrayList row = (ArrayList)this.rows.get(rowNum);
            return (LayoutTableCell)row.get(colNum);
        }

        private LayoutTableCell getFirstCell(int rowNum, int colNum) {
            LayoutTableCell cell = this.getCell(rowNum, colNum);
            if (cell == null || cell.isEmptyCell()) {
                return null;
            }
            return this.getCell(cell.getFirstCellRow(), cell.getFirstCellColumn());
        }

        private int getFreeColumn(int rowNum, int numberColumnsNeeded) {
            int i = 0;
            while (i < this.numCols) {
                boolean foundOccupiedCell = false;
                int j = rowNum;
                while (j < rowNum + numberColumnsNeeded) {
                    LayoutTableCell cell = this.getCell(j, i);
                    if (cell == null) {
                        return -1;
                    }
                    if (!cell.isEmptyCell()) {
                        foundOccupiedCell = true;
                        break;
                    }
                    ++j;
                }
                if (!foundOccupiedCell) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public List getLayoutRows() {
            ArrayList<LayoutRow> allRows = new ArrayList<LayoutRow>();
            int mainRowIndex = 0;
            while (mainRowIndex < this.getNumRows()) {
                if (this.isStartingRowOfGroup(mainRowIndex)) {
                    LayoutRow newRow = new LayoutRow();
                    allRows.add(newRow);
                    int numRowsInGroup = this.getNumberRowsInEventGroup(mainRowIndex);
                    newRow.setRowTimeRange(this.getTimeRangeForEventGroup(mainRowIndex, numRowsInGroup));
                    int columnIndex = 0;
                    while (columnIndex < this.getNumCols()) {
                        ArrayList<CalendarEvent> columnList = new ArrayList<CalendarEvent>();
                        boolean addedCell = false;
                        int eventGroupRowIndex = mainRowIndex;
                        while (eventGroupRowIndex < mainRowIndex + numRowsInGroup) {
                            LayoutTableCell cell = this.getCell(eventGroupRowIndex, columnIndex);
                            if (cell.isFirstCell()) {
                                columnList.add(cell.getCalendarEvent());
                                addedCell = true;
                            }
                            ++eventGroupRowIndex;
                        }
                        if (addedCell) {
                            newRow.add(columnList);
                        }
                        ++columnIndex;
                    }
                    mainRowIndex += numRowsInGroup - 1;
                }
                ++mainRowIndex;
            }
            return allRows;
        }

        private int getNumberOfRowsNeeded(TimeRange eventTimeRange) {
            TimeRange adjustedTimeRange = this.adjustTimeRangeToLayoutTable(eventTimeRange);
            return (int)Math.ceil((double)adjustedTimeRange.duration() / (double)this.millisecondsPerTimeslot);
        }

        private int getNumberRowsInEventGroup(int rowNum) {
            int numEventRows = 0;
            if (this.isStartingRowOfGroup(rowNum)) {
                ++numEventRows;
                int i = rowNum + 1;
                while (i < this.getNumRows() && !this.isEmptyRow(i) && !this.isStartingRowOfGroup(i)) {
                    ++numEventRows;
                    ++i;
                }
            }
            return numEventRows;
        }

        int getNumCols() {
            return this.numCols;
        }

        int getNumRows() {
            return this.rows.size();
        }

        private int getStartingRow(TimeRange eventTimeRange) {
            TimeRange adjustedTimeRange = this.adjustTimeRangeToLayoutTable(eventTimeRange);
            TimeRange timeRangeToStart = new TimeRange(this.timeRange.firstTime(), adjustedTimeRange.firstTime(), true, true);
            return this.getNumberOfRowsNeeded(timeRangeToStart);
        }

        TimeRange getTimeRangeForEventGroup(int rowNum, int numRowsInThisEventGroup) {
            Time firstTime = null;
            Time lastTime = null;
            int i = rowNum;
            while (i < rowNum + numRowsInThisEventGroup) {
                int j = 0;
                while (j < this.getNumCols()) {
                    LayoutTableCell cell = this.getCell(i, j);
                    CalendarEvent event = cell.getCalendarEvent();
                    if (event != null) {
                        TimeRange adjustedTimeRange = this.adjustTimeRangeToLayoutTable(PrintFileGenerator.roundRangeToMinimumTimeInterval(cell.getCalendarEvent().getRange()));
                        if (firstTime == null) {
                            firstTime = adjustedTimeRange.firstTime();
                        } else {
                            Time eventFirstTime = adjustedTimeRange.firstTime();
                            if (eventFirstTime.compareTo(firstTime) < 0) {
                                firstTime = eventFirstTime;
                            }
                        }
                        if (lastTime == null) {
                            lastTime = adjustedTimeRange.lastTime();
                        } else {
                            Time eventLastTime = adjustedTimeRange.lastTime();
                            if (eventLastTime.compareTo(lastTime) > 0) {
                                lastTime = eventLastTime;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return new TimeRange(firstTime, lastTime, true, false);
        }

        private boolean isEmptyRow(int rowNum) {
            boolean sawNonEmptyCell = false;
            int i = 0;
            while (i < this.getNumCols()) {
                LayoutTableCell cell = this.getCell(rowNum, i);
                if (!cell.isEmptyCell()) {
                    sawNonEmptyCell = true;
                    break;
                }
                ++i;
            }
            return !sawNonEmptyCell;
        }

        private boolean isStartingRowOfGroup(int rowNum) {
            boolean sawContinuationCells = false;
            boolean sawFirstCell = false;
            int i = 0;
            while (i < this.getNumCols()) {
                LayoutTableCell cell = this.getCell(rowNum, i);
                if (cell.isContinuationCell()) {
                    sawContinuationCells = true;
                }
                if (cell.isFirstCell) {
                    sawFirstCell = true;
                }
                ++i;
            }
            return !sawContinuationCells && sawFirstCell;
        }

        public boolean rowHasOverlappingEvents(int rowNum) {
            int i = 0;
            while (i < this.getNumCols()) {
                if (this.cellHasOverlappingEvents(rowNum, i)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class LayoutRow
    extends ArrayList {
        private TimeRange rowTimeRange;

        private LayoutRow() {
        }

        public TimeRange getRowTimeRange() {
            return this.rowTimeRange;
        }

        public void setRowTimeRange(TimeRange range) {
            this.rowTimeRange = range;
        }
    }
}

