# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, List, Optional, TypeVar

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer
from .._vendor import AzureReservationAPIMixinABC, _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_get_catalog_request(
    subscription_id: str,
    *,
    reserved_resource_type: Optional[str] = None,
    location: Optional[str] = None,
    publisher_id: Optional[str] = None,
    offer_id: Optional[str] = None,
    plan_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-03-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/catalogs")
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if reserved_resource_type is not None:
        _params["reservedResourceType"] = _SERIALIZER.query("reserved_resource_type", reserved_resource_type, "str")
    if location is not None:
        _params["location"] = _SERIALIZER.query("location", location, "str")
    if publisher_id is not None:
        _params["publisherId"] = _SERIALIZER.query("publisher_id", publisher_id, "str")
    if offer_id is not None:
        _params["offerId"] = _SERIALIZER.query("offer_id", offer_id, "str")
    if plan_id is not None:
        _params["planId"] = _SERIALIZER.query("plan_id", plan_id, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_applied_reservation_list_request(subscription_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-03-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/appliedReservations"
    )
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class AzureReservationAPIOperationsMixin(AzureReservationAPIMixinABC):
    @distributed_trace
    def get_catalog(
        self,
        subscription_id: str,
        reserved_resource_type: Optional[str] = None,
        location: Optional[str] = None,
        publisher_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        plan_id: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.Catalog]:
        """Get the regions and skus that are available for RI purchase for the specified Azure
        subscription.

        Get the regions and skus that are available for RI purchase for the specified Azure
        subscription.

        :param subscription_id: Id of the subscription. Required.
        :type subscription_id: str
        :param reserved_resource_type: The type of the resource for which the skus should be provided.
         Default value is None.
        :type reserved_resource_type: str
        :param location: Filters the skus based on the location specified in this parameter. This can
         be an azure region or global. Default value is None.
        :type location: str
        :param publisher_id: Publisher id used to get the third party products. Default value is None.
        :type publisher_id: str
        :param offer_id: Offer id used to get the third party products. Default value is None.
        :type offer_id: str
        :param plan_id: Plan id used to get the third party products. Default value is None.
        :type plan_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Catalog or the result of cls(response)
        :rtype: list[~azure.mgmt.reservations.models.Catalog]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))
        cls: ClsType[List[_models.Catalog]] = kwargs.pop("cls", None)

        request = build_get_catalog_request(
            subscription_id=subscription_id,
            reserved_resource_type=reserved_resource_type,
            location=location,
            publisher_id=publisher_id,
            offer_id=offer_id,
            plan_id=plan_id,
            api_version=api_version,
            template_url=self.get_catalog.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[Catalog]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_catalog.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/catalogs"}

    @distributed_trace
    def get_applied_reservation_list(self, subscription_id: str, **kwargs: Any) -> _models.AppliedReservations:
        """Get list of applicable ``Reservation``\ s.

        Get applicable ``Reservation``\ s that are applied to this subscription or a resource group
        under this subscription.

        :param subscription_id: Id of the subscription. Required.
        :type subscription_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppliedReservations or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.AppliedReservations
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-03-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))
        cls: ClsType[_models.AppliedReservations] = kwargs.pop("cls", None)

        request = build_get_applied_reservation_list_request(
            subscription_id=subscription_id,
            api_version=api_version,
            template_url=self.get_applied_reservation_list.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AppliedReservations", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_applied_reservation_list.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/appliedReservations"
    }
