# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.deviceregistry import DeviceRegistryMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDeviceRegistryMgmtNamespaceDiscoveredAssetsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DeviceRegistryMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_discovered_assets_get(self, resource_group):
        response = self.client.namespace_discovered_assets.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            discovered_asset_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_discovered_assets_begin_create_or_replace(self, resource_group):
        response = self.client.namespace_discovered_assets.begin_create_or_replace(
            resource_group_name=resource_group.name,
            namespace_name="str",
            discovered_asset_name="str",
            resource={
                "extendedLocation": {"name": "str", "type": "str"},
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "deviceRef": {"deviceName": "str", "endpointName": "str"},
                    "discoveryId": "str",
                    "version": 0,
                    "assetTypeRefs": ["str"],
                    "attributes": {"str": {}},
                    "datasets": [
                        {
                            "name": "str",
                            "dataPoints": [
                                {
                                    "dataSource": "str",
                                    "name": "str",
                                    "dataPointConfiguration": "str",
                                    "lastUpdatedOn": "2020-02-20 00:00:00",
                                    "typeRef": "str",
                                }
                            ],
                            "dataSource": "str",
                            "datasetConfiguration": "str",
                            "destinations": ["dataset_destination"],
                            "lastUpdatedOn": "2020-02-20 00:00:00",
                            "typeRef": "str",
                        }
                    ],
                    "defaultDatasetsConfiguration": "str",
                    "defaultDatasetsDestinations": ["dataset_destination"],
                    "defaultEventsConfiguration": "str",
                    "defaultEventsDestinations": ["event_destination"],
                    "defaultManagementGroupsConfiguration": "str",
                    "defaultStreamsConfiguration": "str",
                    "defaultStreamsDestinations": ["stream_destination"],
                    "description": "str",
                    "displayName": "str",
                    "documentationUri": "str",
                    "eventGroups": [
                        {
                            "name": "str",
                            "dataSource": "str",
                            "defaultDestinations": ["event_destination"],
                            "eventGroupConfiguration": "str",
                            "events": [
                                {
                                    "name": "str",
                                    "dataSource": "str",
                                    "destinations": ["event_destination"],
                                    "eventConfiguration": "str",
                                    "lastUpdatedOn": "2020-02-20 00:00:00",
                                    "typeRef": "str",
                                }
                            ],
                            "typeRef": "str",
                        }
                    ],
                    "externalAssetId": "str",
                    "hardwareRevision": "str",
                    "managementGroups": [
                        {
                            "name": "str",
                            "actions": [
                                {
                                    "name": "str",
                                    "targetUri": "str",
                                    "actionConfiguration": "str",
                                    "actionType": "str",
                                    "lastUpdatedOn": "2020-02-20 00:00:00",
                                    "timeoutInSeconds": 0,
                                    "topic": "str",
                                    "typeRef": "str",
                                }
                            ],
                            "dataSource": "str",
                            "defaultTimeoutInSeconds": 0,
                            "defaultTopic": "str",
                            "lastUpdatedOn": "2020-02-20 00:00:00",
                            "managementGroupConfiguration": "str",
                            "typeRef": "str",
                        }
                    ],
                    "manufacturer": "str",
                    "manufacturerUri": "str",
                    "model": "str",
                    "productCode": "str",
                    "provisioningState": "str",
                    "serialNumber": "str",
                    "softwareRevision": "str",
                    "streams": [
                        {
                            "name": "str",
                            "destinations": ["stream_destination"],
                            "lastUpdatedOn": "2020-02-20 00:00:00",
                            "streamConfiguration": "str",
                            "typeRef": "str",
                        }
                    ],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_discovered_assets_begin_update(self, resource_group):
        response = self.client.namespace_discovered_assets.begin_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            discovered_asset_name="str",
            properties={
                "properties": {
                    "assetTypeRefs": ["str"],
                    "attributes": {"str": {}},
                    "datasets": [
                        {
                            "name": "str",
                            "dataPoints": [
                                {
                                    "dataSource": "str",
                                    "name": "str",
                                    "dataPointConfiguration": "str",
                                    "lastUpdatedOn": "2020-02-20 00:00:00",
                                    "typeRef": "str",
                                }
                            ],
                            "dataSource": "str",
                            "datasetConfiguration": "str",
                            "destinations": ["dataset_destination"],
                            "lastUpdatedOn": "2020-02-20 00:00:00",
                            "typeRef": "str",
                        }
                    ],
                    "defaultDatasetsConfiguration": "str",
                    "defaultDatasetsDestinations": ["dataset_destination"],
                    "defaultEventsConfiguration": "str",
                    "defaultEventsDestinations": ["event_destination"],
                    "defaultManagementGroupsConfiguration": "str",
                    "defaultStreamsConfiguration": "str",
                    "defaultStreamsDestinations": ["stream_destination"],
                    "description": "str",
                    "deviceRef": {"deviceName": "str", "endpointName": "str"},
                    "discoveryId": "str",
                    "displayName": "str",
                    "documentationUri": "str",
                    "eventGroups": [
                        {
                            "name": "str",
                            "dataSource": "str",
                            "defaultDestinations": ["event_destination"],
                            "eventGroupConfiguration": "str",
                            "events": [
                                {
                                    "name": "str",
                                    "dataSource": "str",
                                    "destinations": ["event_destination"],
                                    "eventConfiguration": "str",
                                    "lastUpdatedOn": "2020-02-20 00:00:00",
                                    "typeRef": "str",
                                }
                            ],
                            "typeRef": "str",
                        }
                    ],
                    "hardwareRevision": "str",
                    "managementGroups": [
                        {
                            "name": "str",
                            "actions": [
                                {
                                    "name": "str",
                                    "targetUri": "str",
                                    "actionConfiguration": "str",
                                    "actionType": "str",
                                    "lastUpdatedOn": "2020-02-20 00:00:00",
                                    "timeoutInSeconds": 0,
                                    "topic": "str",
                                    "typeRef": "str",
                                }
                            ],
                            "dataSource": "str",
                            "defaultTimeoutInSeconds": 0,
                            "defaultTopic": "str",
                            "lastUpdatedOn": "2020-02-20 00:00:00",
                            "managementGroupConfiguration": "str",
                            "typeRef": "str",
                        }
                    ],
                    "manufacturer": "str",
                    "manufacturerUri": "str",
                    "model": "str",
                    "productCode": "str",
                    "serialNumber": "str",
                    "softwareRevision": "str",
                    "streams": [
                        {
                            "name": "str",
                            "destinations": ["stream_destination"],
                            "lastUpdatedOn": "2020-02-20 00:00:00",
                            "streamConfiguration": "str",
                            "typeRef": "str",
                        }
                    ],
                    "version": 0,
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_discovered_assets_begin_delete(self, resource_group):
        response = self.client.namespace_discovered_assets.begin_delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            discovered_asset_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_discovered_assets_list_by_resource_group(self, resource_group):
        response = self.client.namespace_discovered_assets.list_by_resource_group(
            resource_group_name=resource_group.name,
            namespace_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
