% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterPurity.R
\name{clusterPurity}
\alias{clusterPurity}
\alias{clusterPurity,ANY-method}
\alias{clusterPurity,SummarizedExperiment-method}
\alias{clusterPurity,SingleCellExperiment-method}
\title{Evaluate cluster purity}
\usage{
clusterPurity(x, ...)

\S4method{clusterPurity}{ANY}(x, ..., transposed = FALSE, subset.row = NULL)

\S4method{clusterPurity}{SummarizedExperiment}(x, ..., assay.type = "logcounts")

\S4method{clusterPurity}{SingleCellExperiment}(
  x,
  clusters = colLabels(x, onAbsence = "error"),
  ...,
  assay.type = "logcounts",
  use.dimred = NULL
)
}
\arguments{
\item{x}{A matrix-like object containing expression values for each gene (row) in each cell (column).
These dimensions can be transposed if \code{transposed=TRUE}.

Alternatively, a \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} containing such an expression matrix.
If \code{x} is a SingleCellExperiment and \code{use.dimred} is set, its \code{\link{reducedDims}} will be used instead.}

\item{...}{For the generic, arguments to pass to specific methods.

For the ANY method, arguments to pass to \code{\link{neighborPurity}}.

For the SummarizedExperiment method, arguments to pass to the ANY method.

For the SingleCellExperiment method, arguments to pass to the SummarizedExperiment method.}

\item{transposed}{A logical scalar indicating whether \code{x} is transposed (i.e., rows are cells).}

\item{subset.row}{See \code{?"\link{scran-gene-selection}"}.
Only used when \code{transposed=FALSE}.}

\item{assay.type}{A string specifying which assay values to use.}

\item{clusters}{A vector or factor of cluster IDs to pass to \code{\link{neighborPurity}}.}

\item{use.dimred}{A string specifying whether existing values in \code{reducedDims(x)} should be used.}
}
\value{
A \linkS4class{DataFrame} of purity statistics where each row corresponds to a cell in \code{x}, 
see \code{?\link{neighborPurity}} for details.
}
\description{
Determine whether cells are surrounded by neighbors that are assigned to the same cluster.
This function has now been deprecated in favor of \code{\link{neighborPurity}} from the \pkg{bluster} package.
}
\examples{
library(scuttle)
sce <- mockSCE()
sce <- logNormCounts(sce)

g <- buildSNNGraph(sce)
clusters <- igraph::cluster_walktrap(g)$membership
out <- clusterPurity(sce, clusters)
boxplot(split(out$purity, clusters))

# Mocking up a stronger example:
ngenes <- 1000
centers <- matrix(rnorm(ngenes*3), ncol=3)
clusters <- sample(1:3, ncol(sce), replace=TRUE)

y <- centers[,clusters]
y <- y + rnorm(length(y))

out2 <- clusterPurity(y, clusters)
boxplot(split(out2$purity, clusters))

}
\seealso{
\code{\link{approxSilhouette}}, for another method of evaluating cluster separation.
}
\author{
Aaron Lun
}
