% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R, R/shinywrappers.R
\name{dataTableOutput}
\alias{dataTableOutput}
\alias{renderDataTable}
\title{Table output with the JavaScript DataTables library}
\usage{
dataTableOutput(outputId)

renderDataTable(
  expr,
  options = NULL,
  searchDelay = 500,
  callback = "function(oTable) {}",
  escape = TRUE,
  env = parent.frame(),
  quoted = FALSE,
  outputArgs = list()
)
}
\arguments{
\item{outputId}{output variable to read the table from}

\item{expr}{An expression that returns a data frame or a matrix.}

\item{options}{A list of initialization options to be passed to DataTables,
or a function to return such a list.  You can find a complete list of
options at \url{https://datatables.net/reference/option/}.

Any top-level strings with class \code{"AsIs"} (as created by \code{\link[=I]{I()}}) will be
evaluated in JavaScript. This is useful when the type of the option value
is not supported in JSON, e.g., a JavaScript function, which can be
obtained by  evaluating a character string. This only applies to the
root-level elements of options list, and does not worked for lower-level
elements in the list.}

\item{searchDelay}{The delay for searching, in milliseconds (to avoid too
frequent search requests).}

\item{callback}{A JavaScript function to be applied to the DataTable object.
This is useful for DataTables plug-ins, which often require the DataTable
instance to be available.}

\item{escape}{Whether to escape HTML entities in the table: \code{TRUE} means
to escape the whole table, and \code{FALSE} means not to escape it.
Alternatively, you can specify numeric column indices or column names to
indicate which columns to escape, e.g. \code{1:5} (the first 5 columns),
\code{c(1, 3, 4)}, or \code{c(-1, -3)} (all columns except the first and
third), or \code{c('Species', 'Sepal.Length')}.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{expr} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{dataTableOutput()} when \code{renderDataTable()} is used
in an interactive R Markdown document.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} Please use
\href{https://rstudio.github.io/DT/shiny.html}{\code{DT::renderDataTable()}}.
(Shiny 0.11.1)

Makes a reactive version of the given function that returns a data frame (or
matrix), which will be rendered with the \href{https://datatables.net}{DataTables}
library. Paging, searching, filtering, and sorting can be done on the R side
using Shiny as the server infrastructure.

This function only provides the server-side version of DataTables (using R
to process the data object on the server side). There is a separate
\href{https://github.com/rstudio/DT}{DT} that allows you to create both
server-side and client-side DataTables, and supports additional features.
Learn more at \url{https://rstudio.github.io/DT/shiny.html}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  # pass a callback function to DataTables using I()
  shinyApp(
    ui = fluidPage(
      fluidRow(
        column(12,
          dataTableOutput('table')
        )
      )
    ),
    server = function(input, output) {
      output$table <- renderDataTable(iris,
        options = list(
          pageLength = 5,
          initComplete = I("function(settings, json) {alert('Done.');}")
        )
      )
    }
  )
}
}
