# 2021-10-05 Triage Log

A fairly busy week, with a relatively high percentage of PRs landing with
regressions and improvements. The overall trajectory is fairly neutral for this
week though.

Triage done by **@simulacrum**.
Revision range: [83f147b3baf21acfc367a6da1045d212cd3957e4..25ec8273855fde2d72ae877b397e054de5300e10](https://perf.rust-lang.org/?start=83f147b3baf21acfc367a6da1045d212cd3957e4&end=25ec8273855fde2d72ae877b397e054de5300e10&absolute=false&stat=instructions%3Au)

5 Regressions, 5 Improvements, 5 Mixed; 1 of them in rollups

43 comparisons made in total

#### Regressions

Don't anonymize bound region names during typeck [#89250](https://github.com/rust-lang/rust/issues/89250)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=30acf6def32a340b4bfce6e1e2638f1b05ac2cd9&end=69c1c6a173dcae20c245348f6c7d19074b6109b7&stat=instructions:u) (up to 0.6% on `full` builds of `coercions`)
- Regression seems to be real, though no regressions in cycle counts are
  reported, so this is likely an acceptable hit.

Constify ?-operator for Result and Option [#86853](https://github.com/rust-lang/rust/issues/86853)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=69c1c6a173dcae20c245348f6c7d19074b6109b7&end=c6007fdc7059c677a6c089e8d2915b264c0d1326&stat=instructions:u) (up to 0.5% on `incr-full` builds of `stm32f4`)
- This is a small regression on the stm32f4 crate, due to a number of extra
  obligations that are created, presumably due to the checks for whether ?
  operators in this crate can be const. It is likely an acceptable change for
  the time being, particularly as the const-impls functionality is still in
  nascent stages and optimizations may come down the line.
- The PR ended up temporarily reverted by
  [#89450](https://github.com/rust-lang/rust/issues/89450), though not due to
  performance reasons.

Fix read_to_end to not grow an exact size buffer [#89165](https://github.com/rust-lang/rust/issues/89165)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e737694a4d66b01308b73d4559a35b43e414faf9&end=d25de31a0eeb14ab0c8c4613496fe2d3d9a085dd&stat=instructions:u) (up to 0.7% on `full` builds of `piston-image`)
- This regression is unclear in cause, and investigation on the PR did not lead
  to a conclusion. However, the regression is fairly small and the change is
  expected to have impacts on more I/O heavy benchmarks than rustc is.
  Syscall counts were shown to improve on the PR, including for rustc, so the
  optimization seems to work in general.

Fix unsound optimization with explicit variant discriminants [#89489](https://github.com/rust-lang/rust/issues/89489)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=44593aeb1387b1be355aeaf0040d5927bd80f060&end=a4797664ba9c7d71e586122853858eeb6c153bb9&stat=instructions:u) (up to 2.3% on `full` builds of `style-servo`)
- This is an expected regression, but is clearly justified by the fix for an
  unsound optimization. We expect to reland it with appropriate changes in the
  future.

Fix clippy lints [#89405](https://github.com/rust-lang/rust/issues/89405)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a8387aef8c378a771686878062e544af4d5e2245&end=b27661eb33c74cb514dba059b47d86b6582ac1c2&stat=instructions:u) (up to 0.4% on `incr-unchanged` builds of `helloworld`)
- Likely to be painful to investigate -- changes are widely scattered across the
  codebase and in theory "no-ops".


#### Improvements

Restructure std::rt [#89011](https://github.com/rust-lang/rust/issues/89011)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=50f9f7810c975234ce4730488d32661a76a00428&end=11491938f80988c7261a1179cf71a25c379c8783&stat=instructions:u) (up to -4.0% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)
- Significant improvement for this particular incremental benchmark (due to
  avoiding inlining from particular modules and as such recompilation of some
  CGUs) and -- as noted on the PR -- also a code size improvement, particularly
  relevant for small binaries.

Remove visible path calculation from allowed deprecation lint [#89395](https://github.com/rust-lang/rust/issues/89395)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=598d89bf142823b5d84e2eb0f0f9e418ee966a4b&end=4e4942dfa66667c0addfff8e0882a59b035d45ca&stat=instructions:u) (up to -10.9% on `incr-patched: minor change` builds of `tokio-webpush-simple`)
- Excellent improvement in multiple benchmarks, though unlikely to be terribly
  representative. Most of these benchmarks have -A deprecated passed by the
  perf.rlo runtime currently (since we do not meaningfully update benchmarks
  over time, we build up deprecation warnings).


Avoid nondeterminism in trimmed_def_paths [#89408](https://github.com/rust-lang/rust/issues/89408)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b27661eb33c74cb514dba059b47d86b6582ac1c2&end=edebf77e0090195bf80c0d8cda821e1bf9d03053&stat=instructions:u) (up to -2.0% on `incr-unchanged` builds of `webrender-wrench`)
- Fixes a regression introduced in
  [#83343](https://github.com/rust-lang/rust/pull/83343), not a standalone
  improvement.


Rollup of 14 pull requests [#89512](https://github.com/rust-lang/rust/issues/89512)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d25de31a0eeb14ab0c8c4613496fe2d3d9a085dd&end=44593aeb1387b1be355aeaf0040d5927bd80f060&stat=instructions:u) (up to -1.4% on `incr-patched: static str 6144` builds of `issue-46449`)
- Unclear cause, but unlikely to receive much investigation as it's an
  improvement in a rollup -- we prioritize regressions.

Deriving: Include bound generic params in type parameters for where clause [#89341](https://github.com/rust-lang/rust/issues/89341)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d14731cb3ced8318d7fc83cbe838f0e7f2fb3b40&end=f03eb6bef8ced8a243858b819e013b9caf83d757&stat=instructions:u) (up to -0.4% on `incr-unchanged` builds of `helloworld`)


#### Mixed

Add more tracing instrumentation [#89048](https://github.com/rust-lang/rust/issues/89048)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1d71ba862309d59df710078a845c8772ffb22aba&end=8f8092cc32ec171becef8ceacec7dbb06c5d7d7e&stat=instructions:u) (up to -1.6% on `full` builds of `keccak`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1d71ba862309d59df710078a845c8772ffb22aba&end=8f8092cc32ec171becef8ceacec7dbb06c5d7d7e&stat=instructions:u) (up to 12.0% on `full` builds of `ctfe-stress-4`)
- Regression is mitigated by
  [#89363](https://github.com/rust-lang/rust/pull/89363), which just barely
  missed being included in this report.


Add an intermediate representation to exhaustiveness checking [#88950](https://github.com/rust-lang/rust/issues/88950)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8f8092cc32ec171becef8ceacec7dbb06c5d7d7e&end=6df1d82869d06b88ff413e63a1e8efbb311e3b5c&stat=instructions:u) (up to -2.6% on `full` builds of `unicode_normalization`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=8f8092cc32ec171becef8ceacec7dbb06c5d7d7e&end=6df1d82869d06b88ff413e63a1e8efbb311e3b5c&stat=instructions:u) (up to 2.9% on `full` builds of `match-stress-enum`)
- Code quality improvements mitigate the regressions, which are largely limited
  to a stress test.


Rollup of 6 pull requests [#89435](https://github.com/rust-lang/rust/issues/89435)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ed937594d3912ced11f6f35a90bb8bf591909d2a&end=b6057bf7b7ee7c58e6a39ead02eaa13b75f908c2&stat=instructions:u) (up to -0.3% on `incr-unchanged` builds of `helloworld`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ed937594d3912ced11f6f35a90bb8bf591909d2a&end=b6057bf7b7ee7c58e6a39ead02eaa13b75f908c2&stat=instructions:u) (up to 0.8% on `incr-unchanged` builds of `externs`)
- Unclear cause for the regression. Hasn't been investigated yet.


Rework HIR API to make invocations of the hir_crate query harder. [#88880](https://github.com/rust-lang/rust/issues/88880)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b6057bf7b7ee7c58e6a39ead02eaa13b75f908c2&end=c02371c442f811878ab3a0f5a813402b6dfd45d2&stat=instructions:u) (up to -0.4% on `incr-unchanged` builds of `helloworld`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=b6057bf7b7ee7c58e6a39ead02eaa13b75f908c2&end=c02371c442f811878ab3a0f5a813402b6dfd45d2&stat=instructions:u) (up to 0.2% on `full` builds of `many-assoc-items`)
- Regressions are smaller than improvements. Original perf run didn't return
  regressions at all. Tagged for investigation.

resolve: Cache module loading for all foreign modules [#89239](https://github.com/rust-lang/rust/issues/89239)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=edebf77e0090195bf80c0d8cda821e1bf9d03053&end=d14731cb3ced8318d7fc83cbe838f0e7f2fb3b40&stat=instructions:u) (up to 0.8% on `incr-unchanged` builds of `tokio-webpush-simple`)
- From the PR: This corrects behaviour for macros 2.0 and avoids an ICE, so a
  0.8% regression seems acceptable.

#### Untriaged Pull Requests

Investigation work continues, and we're down to 22 from 28 untriaged PRs week
over week.

- [#89435 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89435)
- [#89363 Fix performance regression with #[instrument]](https://github.com/rust-lang/rust/pull/89363)
- [#89263 Suggest both of immutable and mutable trait implementations](https://github.com/rust-lang/rust/pull/89263)
- [#89165 Fix read_to_end to not grow an exact size buffer](https://github.com/rust-lang/rust/pull/89165)
- [#89125 Don't use projection cache or candidate cache in intercrate mode](https://github.com/rust-lang/rust/pull/89125)
- [#89103 Migrate in-tree crates to 2021](https://github.com/rust-lang/rust/pull/89103)
- [#89047 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89047)
- [#89030 Introduce `Rvalue::ShallowInitBox`](https://github.com/rust-lang/rust/pull/89030)
- [#88945 Remove concept of 'completion' from the projection cache](https://github.com/rust-lang/rust/pull/88945)
- [#88824 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/88824)
- [#88804 Revise never type fallback algorithm](https://github.com/rust-lang/rust/pull/88804)
- [#88719 Point at argument instead of call for their obligations](https://github.com/rust-lang/rust/pull/88719)
- [#88703 Gather module items after lowering.](https://github.com/rust-lang/rust/pull/88703)
- [#88627 Do not preallocate HirIds](https://github.com/rust-lang/rust/pull/88627)
- [#88575 Querify `FnAbi::of_{fn_ptr,instance}` as `fn_abi_of_{fn_ptr,instance}`.](https://github.com/rust-lang/rust/pull/88575)
- [#88308 Morph `layout_raw` query into `layout_of`.](https://github.com/rust-lang/rust/pull/88308)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)
- [#87688 Introduce `let...else`](https://github.com/rust-lang/rust/pull/87688)
- [#87064 Support `#[track_caller]` on closures and generators](https://github.com/rust-lang/rust/pull/87064)
- [#83698 Use undef for uninitialized bytes in constants](https://github.com/rust-lang/rust/pull/83698)
- [#83302 Get piece unchecked in `write`](https://github.com/rust-lang/rust/pull/83302)
- [#80522 Split rustc_mir](https://github.com/rust-lang/rust/pull/80522)
