/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.visitor.ClassCollector;
import proguard.optimize.info.NoSideEffectClassMarker;
import proguard.optimize.info.SideEffectClassFilter;

public class SideEffectClassChecker {
    public static boolean mayHaveSideEffects(Clazz clazz, Clazz clazz2, Member member) {
        return ((member.getAccessFlags() & 8) != 0 || member.getName(clazz2).equals("<init>")) && SideEffectClassChecker.mayHaveSideEffects(clazz, clazz2);
    }

    public static boolean mayHaveSideEffects(Clazz clazz, Clazz clazz2) {
        return !NoSideEffectClassMarker.hasNoSideEffects(clazz2) && !clazz.extendsOrImplements(clazz2) && !SideEffectClassChecker.sideEffectSuperClasses(clazz).containsAll(SideEffectClassChecker.sideEffectSuperClasses(clazz2));
    }

    private static Set sideEffectSuperClasses(Clazz clazz) {
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new SideEffectClassFilter(new ClassCollector(hashSet)));
        return hashSet;
    }
}

