      SUBROUTINE SAXIF2 (IOPT,IPART,BRANCH,EIGEN)
C
C     THIS ROUTINE CALCULATES FLUID VELOCITIES DUE TO HARMONIC
C     PRESSURES IN AN AXISYMMETRIC FLUID
C
C     THE OPTIONS FOR IOPT ARE
C         IOPT    ELEMENT
C           0     CAXIF2
C           1     CAXIF3
C           2     CAXIF4
C     IPART-  FIRST = 1,   SECOND = 2
C     BRANCH-  SDR2 PROCESS CODE WORD
C
      INTEGER         SIL       ,BRANCH
      DIMENSION       EIGEN(3)
      COMMON /CONDAS/ CONSTS(5)
      COMMON /ZZZZZZ/ ZZ(1)
      COMMON /SDR2X4/ DUMY(35)  ,IVEC
      COMMON /SDR2X7/ IDE       ,SIL(4)   ,SV(95)    ,ID1      ,
     1                VELR(11)  ,ID2      ,VELI(11)
      EQUIVALENCE     (CONSTS(2),TWOPI)
C
C
      IF (IPART .EQ. 2) GO TO 20
      DO 10 I = 1,11
      VELR(I) = 0.0
   10 VELI(I) = 0.0
   20 X = 1.0
      Y = 0.0
      IF (BRANCH .EQ. 2) X = SQRT(ABS(EIGEN(2)))
      IF (BRANCH .EQ. 5) X = TWOPI*EIGEN(1)
      IF (X .NE. 0.0) X = 1.0/X
      IF (BRANCH .NE. 9) GO TO 30
      EM = EIGEN(2)**2 + EIGEN(3)**2
      IF (EM .EQ. 0.0) GO TO 30
      X = EIGEN(2)/EM
      Y =-EIGEN(3)/EM
   30 IF (IPART .NE. 2) GO TO 40
      EM = X
      X  =-Y
      Y  = EM
   40 ID1= IDE
      ID2= IDE
      KC = IOPT + 2
      KR = 3 + 2*KC
      IF (IOPT .EQ. 0) KR = 6
      DO 80 I = 1,KC
      K = IVEC + SIL(I) - 1
      IF (X .EQ. 0.0) GO TO 65
C
      DO 60 J = 1,KR
      IJ = KC*(J-1) + I
      VELR(J) = SV(IJ)*ZZ(K)*X + VELR(J)
   60 CONTINUE
   65 CONTINUE
      IF (Y .EQ. 0.0) GO TO 80
C
      DO 70 J = 1,KR
      IJ = KC*(J-1) + I
      VELI(J) = SV(IJ)*ZZ(K)*Y + VELI(J)
   70 CONTINUE
   80 CONTINUE
      RETURN
      END
