use strict;
use warnings;

package Footprintless::App;
$Footprintless::App::VERSION = '1.01';
# ABSTRACT: The base application class for fpl
# PODNAME: Footprintless::App

use App::Cmd::Setup -app;

sub footprintless {
    my ($self) = @_;

    if ( !defined( $self->{footprintless} ) ) {
        require Footprintless;
        $self->{footprintless} = Footprintless->new();
    }

    return $self->{footprintless};
}

1;

__END__

=pod

=head1 NAME

Footprintless::App - The base application class for fpl

=head1 VERSION

version 1.01

=head1 METHODS

=head2 footprintless()

Returns the instance of C<Footprintless> for this instance of the app.

=head1 AUTHOR

Lucas Theisen <lucastheisen@pastdev.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Lucas Theisen.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Footprintless|Footprintless>

=item *

L<App::Cmd|App::Cmd>

=item *

L<Footprintless|Footprintless>

=back

=cut
