#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
8c82a43a PERL-803 Fix Kerberos authentication
0b3d40eb PERL-803 Make kerberos test configurable from env vars
cf7bc0d0 PERL-844 Bump IO::Socket::IP prereq to 0.32
6fa53042 PERL-832 Skip threaded cursor test on Windows with SASL
425a2317 PERL-770 Prevent short reads from throwing a protocol error
0ae4745f PERL-800 CI: Stop testing 2.4 on Evergreen
37508847 PERL-828 Stop sending maxAwaitTimeMS if not set
ac887869 PERL-825 Fix insert_many exception for unack'd writes
c2f9e545 (shadowcat/maint-v1.x) PERL-798 Update Tutorial.pod to fix typos
803e068a PERL-796 Improve resolution of GridFS uploadDate
3928f760 PERL-795 Document GridFS uniqueness constraints

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
