/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.ber;

import com.vizdom.ber.BerInteger;
import com.vizdom.ber.BerModule;
import com.vizdom.ber.BerNull;
import com.vizdom.ber.BerOctetString;
import com.vizdom.ber.BerSequence;
import com.vizdom.util.Debug;
import com.vizdom.util.UnreachableCodeException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BerIdentifier {
    private static final int gTAG_CLASS_MASK = 192;
    private static final int gFORM_MASK = 32;
    private static final int gTAG_NUMBER_MASK = 31;
    private final int mTagClass;
    private final int mForm;
    private final int mTagNumber;
    private final long mEncodedOctets;

    static BerIdentifier gReadIdentifier(InputStream anIn) throws IOException {
        int octet = anIn.read();
        if (octet == -1) {
            return null;
        }
        int tagClass = octet & 0xC0;
        int form = octet & 0x20;
        int tagNumber = octet & 0x1F;
        long encodedOctets = octet;
        if (tagNumber == 31) {
            tagNumber = 0;
            do {
                if ((octet = anIn.read()) == -1) {
                    throw new EOFException();
                }
                tagNumber = tagNumber << 7 | octet & 0x7F;
                encodedOctets = encodedOctets << 8 | (long)(octet & 0xFF);
            } while ((octet & 0x80) == 128);
        }
        if (tagClass == 0) {
            switch (tagNumber) {
                case 0: {
                    return BerModule.gEND_OF_CONTENTS_IDENTIFIER;
                }
                case 2: {
                    return BerInteger.gIDENTIFIER;
                }
                case 4: {
                    return BerOctetString.gIDENTIFIER;
                }
                case 5: {
                    return BerNull.gIDENTIFIER;
                }
                case 16: {
                    return BerSequence.gIDENTIFIER;
                }
            }
            throw new UnreachableCodeException(tagNumber);
        }
        long reversedOctets = 0L;
        while (encodedOctets != 0L) {
            reversedOctets <<= 8;
            reversedOctets |= encodedOctets & 0xFFL;
            encodedOctets >>>= 8;
        }
        return new BerIdentifier(tagClass, form, tagNumber, reversedOctets);
    }

    BerIdentifier(int aForm, int aTagNumber) {
        this.mTagClass = 0;
        this.mForm = aForm;
        this.mTagNumber = aTagNumber;
        this.mEncodedOctets = 0 | aForm | aTagNumber;
    }

    public BerIdentifier(int aTagClass, int aForm, int aTagNumber) {
        Debug.assertTrue(aTagClass != 0 && (aTagClass & 0xFFFFFF3F) == 0);
        Debug.assertTrue((aForm & 0xFFFFFFDF) == 0);
        this.mTagClass = aTagClass;
        this.mForm = aForm;
        this.mTagNumber = aTagNumber;
        this.mEncodedOctets = this.mEncodeOctets();
    }

    private BerIdentifier(int aTagClass, int aForm, int aTagNumber, long anEncodedOctets) {
        this.mTagClass = aTagClass;
        this.mForm = aForm;
        this.mTagNumber = aTagNumber;
        this.mEncodedOctets = anEncodedOctets;
    }

    private long mEncodeOctets() {
        int classForm = this.mTagClass | this.mForm;
        int tagNumber = this.mTagNumber;
        if (tagNumber < 31) {
            return classForm | tagNumber;
        }
        long reversedTagNumber = 0L;
        boolean isFirst = true;
        while (tagNumber != 0) {
            int octet = tagNumber & 0x7F;
            if (isFirst) {
                isFirst = false;
            } else {
                octet |= 0x80;
            }
            reversedTagNumber <<= 8;
            reversedTagNumber |= (long)octet;
            tagNumber >>>= 7;
        }
        reversedTagNumber <<= 8;
        return reversedTagNumber |= (long)(classForm | 0x1F);
    }

    void mWrite(OutputStream anOut) throws IOException {
        long encodedOctets = this.mEncodedOctets;
        int octet = (int)(encodedOctets & 0xFFL);
        anOut.write(octet);
        encodedOctets >>>= 8;
        if ((octet & 0x1F) == 31) {
            do {
                octet = (int)(encodedOctets & 0xFFL);
                anOut.write(octet);
                encodedOctets >>>= 8;
            } while ((octet & 0x80) == 128);
        }
    }

    public int getTagClass() {
        return this.mTagClass;
    }

    public int getForm() {
        return this.mForm;
    }

    public int getTagNumber() {
        return this.mTagNumber;
    }

    public boolean equals(Object anObject) {
        if (anObject == null || !(anObject instanceof BerIdentifier)) {
            return false;
        }
        long encodedOctets = ((BerIdentifier)anObject).mEncodedOctets;
        return this.mEncodedOctets == encodedOctets;
    }

    public int hashCode() {
        return (int)(this.mEncodedOctets ^ this.mEncodedOctets >> 32);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        switch (this.mTagClass) {
            case 0: {
                buffer.append("UNIVERSAL ");
                break;
            }
            case 64: {
                buffer.append("APPLICATION ");
                break;
            }
            case 128: {
                break;
            }
            case 192: {
                buffer.append("PRIVATE ");
                break;
            }
            default: {
                throw new UnreachableCodeException(this.mTagClass);
            }
        }
        buffer.append(this.mTagNumber);
        switch (this.mForm) {
            case 0: {
                buffer.append(" primitive]");
                break;
            }
            case 32: {
                buffer.append(" constructed]");
                break;
            }
            default: {
                throw new UnreachableCodeException(this.mForm);
            }
        }
        return buffer.toString();
    }
}

