/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.ber;

import com.vizdom.ber.BerBoolean;
import com.vizdom.ber.BerEnumerated;
import com.vizdom.ber.BerIdentifier;
import com.vizdom.ber.BerInteger;
import com.vizdom.ber.BerNull;
import com.vizdom.ber.BerObject;
import com.vizdom.ber.BerObjectFactory;
import com.vizdom.ber.BerOctetString;
import com.vizdom.ber.BerSequence;
import com.vizdom.util.CharacterEncoder;
import com.vizdom.util.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BerModule {
    static final BerIdentifier gEND_OF_CONTENTS_IDENTIFIER = new BerIdentifier(0, 0);
    public static final BerObject END_OF_CONTENTS = new BerObject(){

        @Override
        public BerIdentifier getIdentifier() {
            return gEND_OF_CONTENTS_IDENTIFIER;
        }

        @Override
        protected int mGetLength() {
            return 0;
        }

        @Override
        protected void mWriteContents(OutputStream anOut) {
        }

        @Override
        protected void mReadContents(InputStream anIn, BerModule aModule, BerIdentifier anIdentifier, int aLength) {
            Debug.assertTrue(aLength == 0);
        }

        @Override
        public String toString() {
            return "end-of-contents";
        }
    };
    public static final BerNull NULL = new BerNull();
    private Map<BerIdentifier, BerObjectFactory> mTiedFactories = new HashMap<BerIdentifier, BerObjectFactory>();
    private List<BerObjectFactory> mUntiedFactories = new ArrayList<BerObjectFactory>();
    private String mCharacterEncoding;

    public void registerFactory(BerObjectFactory aFactory) {
        if (aFactory == null) {
            throw new NullPointerException();
        }
        this.mUntiedFactories.add(aFactory);
    }

    public void registerFactory(BerObjectFactory aFactory, BerIdentifier anIdentifier) {
        if (aFactory == null || anIdentifier == null) {
            throw new NullPointerException();
        }
        BerObjectFactory previous = this.mTiedFactories.put(anIdentifier, aFactory);
        if (previous != null) {
            throw new IllegalStateException("Type " + anIdentifier + " is already registered with " + previous);
        }
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        CharacterEncoder.toByteArray("hello", encoding);
        this.mCharacterEncoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.mCharacterEncoding;
    }

    public BerObject readFrom(InputStream anIn) throws IOException {
        BerIdentifier identifier = BerIdentifier.gReadIdentifier(anIn);
        if (identifier == null) {
            return null;
        }
        int length = BerObject.gReadLength(anIn);
        if (identifier.getTagClass() == 0) {
            BerObject o;
            switch (identifier.getTagNumber()) {
                case 1: {
                    o = new BerBoolean();
                    break;
                }
                case 2: {
                    o = new BerInteger();
                    break;
                }
                case 4: {
                    o = new BerOctetString();
                    break;
                }
                case 5: {
                    o = NULL;
                    break;
                }
                case 10: {
                    o = new BerEnumerated();
                    break;
                }
                case 16: {
                    o = new BerSequence();
                    break;
                }
                default: {
                    throw new IOException("Unimplemented BER built-in type: " + identifier);
                }
            }
            ((BerObject)o).mReadContents(anIn, this, identifier, length);
            return o;
        }
        BerObjectFactory factory = this.mTiedFactories.get(identifier);
        if (factory == null) {
            for (int i = 0; i < this.mUntiedFactories.size(); ++i) {
                BerObjectFactory untiedFactory = this.mUntiedFactories.get(i);
                if (!untiedFactory.acceptsIdentifier(identifier)) continue;
                factory = untiedFactory;
                break;
            }
        }
        if (factory == null) {
            throw new IOException("Unrecognized BER object identifier: " + identifier);
        }
        BerObject bero = factory.createBerObject();
        bero.mReadContents(anIn, this, identifier, length);
        return bero;
    }
}

