/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.impl;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.felix.ipojo.junit4osgi.OSGiJunitRunner;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.OSGiTestSuite;
import org.apache.felix.ipojo.junit4osgi.impl.ResultPrinter;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class JunitExtender
implements OSGiJunitRunner {
    public static final String SUITE_METHODNAME = "suite";
    private Map m_suites = new HashMap();
    private ResultPrinter m_printer = new ResultPrinter(System.out);
    private LogService m_log;

    void onBundleArrival(Bundle bundle, String header) {
        String[] tss = ParseUtils.split((String)header, (String)",");
        for (int i = 0; i < tss.length; ++i) {
            try {
                if (tss[i].length() == 0) continue;
                this.m_log.log(3, "Loading " + tss[i]);
                Class clazz = bundle.loadClass(tss[i].trim());
                this.addTestSuite(bundle, clazz);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.m_log.log(1, "The test suite " + tss[i] + " is not in the bundle " + bundle.getBundleId() + " : " + e.getMessage());
            }
        }
    }

    private synchronized void addTestSuite(Bundle bundle, Class test) {
        ArrayList<Class> list = (ArrayList<Class>)this.m_suites.get(bundle);
        if (list == null) {
            list = new ArrayList<Class>();
            list.add(test);
            this.m_suites.put(bundle, list);
        } else {
            list.add(test);
        }
    }

    private synchronized void removeTestSuites(Bundle bundle) {
        List list = (List)this.m_suites.remove(bundle);
        this.m_log.log(3, "Unload test suites " + list);
    }

    void onBundleDeparture(Bundle bundle) {
        this.removeTestSuites(bundle);
    }

    public void setResultPrinter(PrintStream pw) {
        this.m_printer = new ResultPrinter(pw);
    }

    public synchronized List run() {
        ArrayList<TestResult> results = new ArrayList<TestResult>(this.m_suites.size());
        Iterator it = this.m_suites.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Bundle bundle = (Bundle)entry.getKey();
            List list = (List)this.m_suites.get(bundle);
            for (int i = 0; i < list.size(); ++i) {
                Test test = this.createTestFromClass((Class)list.get(i), bundle);
                TestResult tr = this.doRun(test);
                results.add(tr);
            }
        }
        return results;
    }

    private TestResult doRun(Test test) {
        TestResult result = new TestResult();
        result.addListener(this.m_printer);
        long startTime = System.currentTimeMillis();
        test.run(result);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        this.m_printer.print(result, runTime);
        return result;
    }

    private Test createTestFromClass(Class clazz, Bundle bundle) {
        Method suiteMethod = null;
        boolean bc = false;
        try {
            suiteMethod = clazz.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception e) {
            try {
                suiteMethod = clazz.getMethod(SUITE_METHODNAME, BundleContext.class);
                bc = true;
            }
            catch (Exception e2) {
                if (OSGiTestSuite.class.isAssignableFrom(clazz)) {
                    OSGiTestSuite ts = new OSGiTestSuite(clazz, this.getBundleContext(bundle));
                    return ts;
                }
                if (OSGiTestCase.class.isAssignableFrom(clazz)) {
                    OSGiTestSuite ts = new OSGiTestSuite(clazz, this.getBundleContext(bundle));
                    return ts;
                }
                return new TestSuite(clazz);
            }
        }
        if (!Modifier.isStatic(suiteMethod.getModifiers())) {
            this.m_log.log(1, "Suite() method must be static");
            return null;
        }
        Test test = null;
        try {
            test = bc ? (Test)suiteMethod.invoke(null, this.getBundleContext(bundle)) : (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            this.m_log.log(1, "Failed to invoke suite():" + e.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException e) {
            this.m_log.log(1, "Failed to invoke suite():" + e.toString());
            return null;
        }
        return test;
    }

    public synchronized List getTests() {
        ArrayList<Test> results = new ArrayList<Test>();
        Iterator it = this.m_suites.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Bundle bundle = (Bundle)entry.getKey();
            List list = (List)this.m_suites.get(bundle);
            for (int i = 0; i < list.size(); ++i) {
                Test test = this.createTestFromClass((Class)list.get(i), bundle);
                results.add(test);
            }
        }
        return results;
    }

    public TestResult run(Test test) {
        return this.doRun(test);
    }

    public synchronized List getTests(long bundleId) {
        Iterator it = this.m_suites.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Bundle bundle = (Bundle)entry.getKey();
            if (bundle.getBundleId() != bundleId) continue;
            ArrayList<Test> results = new ArrayList<Test>();
            List list = (List)this.m_suites.get(bundle);
            for (int i = 0; i < list.size(); ++i) {
                Test test = this.createTestFromClass((Class)list.get(i), bundle);
                results.add(test);
            }
            return results;
        }
        return null;
    }

    public synchronized List run(long bundleId) {
        Iterator it = this.m_suites.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Bundle bundle = (Bundle)entry.getKey();
            if (bundle.getBundleId() != bundleId) continue;
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            List list = (List)this.m_suites.get(bundle);
            for (int i = 0; i < list.size(); ++i) {
                Test test = this.createTestFromClass((Class)list.get(i), bundle);
                TestResult tr = this.doRun(test);
                results.add(tr);
            }
            return results;
        }
        return null;
    }

    public synchronized void stopping() {
        this.m_log.log(3, "Cleaning test suites ...");
        this.m_suites.clear();
    }

    public void starting() {
        this.m_log.log(3, "Junit Extender starting ...");
    }

    private BundleContext getBundleContext(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Method meth = null;
        try {
            meth = bundle.getClass().getMethod("getBundleContext", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (meth == null) {
            try {
                meth = bundle.getClass().getMethod("getContext", new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (meth != null) {
            if (!meth.isAccessible()) {
                meth.setAccessible(true);
            }
            try {
                return (BundleContext)meth.invoke((Object)bundle, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                this.m_log.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.m_log.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), (Throwable)e);
                return null;
            }
            catch (InvocationTargetException e) {
                this.m_log.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), (Throwable)e);
                return null;
            }
        }
        Field[] fields = bundle.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!(class$org$osgi$framework$BundleContext == null ? JunitExtender.class$("org.osgi.framework.BundleContext") : class$org$osgi$framework$BundleContext).isAssignableFrom(fields[i].getType())) continue;
            if (!fields[i].isAccessible()) {
                fields[i].setAccessible(true);
            }
            try {
                return (BundleContext)fields[i].get(bundle);
            }
            catch (IllegalArgumentException e) {
                this.m_log.log(1, "Cannot get the BundleContext by reflecting on " + fields[i].getName(), (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.m_log.log(1, "Cannot get the BundleContext by reflecting on " + fields[i].getName(), (Throwable)e);
                return null;
            }
        }
        this.m_log.log(1, "Cannot find the BundleContext for " + bundle.getSymbolicName(), null);
        return null;
    }
}

