/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.algorithms.regression.tests;

import org.apache.commons.math3.distribution.FDistribution;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.algorithms.preprocessing.MeanCenter;
import org.apache.mahout.math.algorithms.regression.RegressorModel;
import org.apache.mahout.math.drm.DrmLike;
import org.apache.mahout.math.drm.RLikeDrmOps$;
import org.apache.mahout.math.drm.package$;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.scalabindings.RLikeOps$;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class FittnessTests$ {
    public static final FittnessTests$ MODULE$;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;

    static {
        symbol$1 = Symbol$.MODULE$.apply("r2");
        symbol$2 = Symbol$.MODULE$.apply("mse");
        symbol$3 = Symbol$.MODULE$.apply("fScore");
        new FittnessTests$();
    }

    public <R extends RegressorModel<Object>, K> R CoefficientOfDetermination(R model, DrmLike<K> drmTarget, DrmLike<K> residuals) {
        double sumSquareResiduals = RLikeOps$.MODULE$.m2mOps(package$.MODULE$.drm2InCore(residuals).assign(Functions.SQUARE)).sum();
        MeanCenter mc = new MeanCenter();
        DrmLike<K> totalResiduals = mc.fitTransform(drmTarget, (Seq<Tuple2<Symbol, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        double sumSquareTotal = RLikeOps$.MODULE$.m2mOps(package$.MODULE$.drm2InCore(totalResiduals).assign(Functions.SQUARE)).sum();
        double r2 = 1.0 - sumSquareResiduals / sumSquareTotal;
        model.r2_$eq(r2);
        model.testResults().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol$1), (Object)BoxesRunTime.boxToDouble((double)r2)));
        return model;
    }

    public <R extends RegressorModel<Object>, K> R MeanSquareError(R model, DrmLike<K> residuals) {
        double mse = RLikeOps$.MODULE$.m2mOps(package$.MODULE$.drm2InCore(residuals).assign(Functions.SQUARE)).sum() / (double)residuals.nrow();
        model.mse_$eq(mse);
        model.testResults().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol$2), (Object)BoxesRunTime.boxToDouble((double)mse)));
        return model;
    }

    public <R extends RegressorModel<Object>, K> R calculateResidualSumOfSquares(R model, DrmLike<K> residuals) {
        if (model.rss() < 0.0) {
            Matrix ete = package$.MODULE$.drm2Checkpointed(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drm2RLikeOps(residuals).t()).$percent$times$percent(residuals)).collect();
            model.rss_$eq(RLikeOps$.MODULE$.m2mOps(ete).apply(0, 0));
        }
        return model;
    }

    public <R extends RegressorModel<Object>, K> R FTest(R model, DrmLike<K> drmTarget) {
        double targetMean = RLikeDrmOps$.MODULE$.drm2cpops(drmTarget).colMeans().get(0);
        double rssint = package$.MODULE$.drm2InCore(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drm2RLikeOps(RLikeDrmOps$.MODULE$.drm2RLikeOps(drmTarget).$minus(targetMean)).t()).$percent$times$percent(RLikeDrmOps$.MODULE$.drm2RLikeOps(drmTarget).$minus(targetMean))).zSum();
        double fScore = (rssint - model.rss()) / (double)(model.degreesOfFreedom() - 1) / (model.rss() / (double)(model.trainingExamples() - model.degreesOfFreedom()));
        FDistribution fDist = new FDistribution((double)(model.degreesOfFreedom() - 1), (double)(model.trainingExamples() - model.degreesOfFreedom()));
        double fpval = 1.0 - fDist.cumulativeProbability(fScore);
        model.fpval_$eq(fpval);
        model.fScore_$eq(fScore);
        model.testResults().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol$3), (Object)BoxesRunTime.boxToDouble((double)fScore)));
        return model;
    }

    private FittnessTests$() {
        MODULE$ = this;
    }
}

