/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.cloud.gateway.support.ipresolver.RemoteAddressResolver;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class RemoteAddrRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private static final Log log = LogFactory.getLog(RemoteAddrRoutePredicateFactory.class);

    public RemoteAddrRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("sources");
    }

    @NotNull
    private List<IpSubnetFilterRule> convert(List<String> values) {
        ArrayList<IpSubnetFilterRule> sources = new ArrayList<IpSubnetFilterRule>();
        for (String arg : values) {
            this.addSource(sources, arg);
        }
        return sources;
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        List<IpSubnetFilterRule> sources = this.convert(config.sources);
        return exchange -> {
            InetSocketAddress remoteAddress = config.remoteAddressResolver.resolve((ServerWebExchange)exchange);
            if (remoteAddress != null && remoteAddress.getAddress() != null) {
                String hostAddress = remoteAddress.getAddress().getHostAddress();
                String host = exchange.getRequest().getURI().getHost();
                if (log.isDebugEnabled() && !hostAddress.equals(host)) {
                    log.debug((Object)("Remote addresses didn't match " + hostAddress + " != " + host));
                }
                for (IpSubnetFilterRule source : sources) {
                    if (!source.matches(remoteAddress)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    private void addSource(List<IpSubnetFilterRule> sources, String source) {
        if (!source.contains("/")) {
            source = source + "/32";
        }
        String[] ipAddressCidrPrefix = source.split("/", 2);
        String ipAddress = ipAddressCidrPrefix[0];
        int cidrPrefix = Integer.parseInt(ipAddressCidrPrefix[1]);
        sources.add(new IpSubnetFilterRule(ipAddress, cidrPrefix, IpFilterRuleType.ACCEPT));
    }

    @Validated
    public static class Config {
        @NotEmpty
        private List<String> sources = new ArrayList<String>();
        @NotNull
        private RemoteAddressResolver remoteAddressResolver = new RemoteAddressResolver(){};

        public List<String> getSources() {
            return this.sources;
        }

        public Config setSources(List<String> sources) {
            this.sources = sources;
            return this;
        }

        public Config setSources(String ... sources) {
            this.sources = Arrays.asList(sources);
            return this;
        }

        public Config setRemoteAddressResolver(RemoteAddressResolver remoteAddressResolver) {
            this.remoteAddressResolver = remoteAddressResolver;
            return this;
        }
    }
}

