/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.Part;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupport;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupportImpl;
import org.apache.servicecomb.foundation.vertx.http.DownloadUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.stream.PumpFromPart;

public class StandardHttpServletResponseEx
extends HttpServletResponseWrapper
implements HttpServletResponseEx {
    private BodyBufferSupport bodyBuffer = new BodyBufferSupportImpl();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Response.StatusType statusType;

    public StandardHttpServletResponseEx(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void setBodyBuffer(Buffer bodyBuffer) {
        this.bodyBuffer.setBodyBuffer(bodyBuffer);
    }

    @Override
    public Buffer getBodyBuffer() {
        return this.bodyBuffer.getBodyBuffer();
    }

    @Override
    public byte[] getBodyBytes() {
        return this.bodyBuffer.getBodyBytes();
    }

    @Override
    public int getBodyBytesLength() {
        return this.bodyBuffer.getBodyBytesLength();
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        this.statusType = new HttpStatus(sc, sm);
    }

    public int getStatus() {
        return this.statusType.getStatusCode();
    }

    @Override
    public Response.StatusType getStatusType() {
        return this.statusType;
    }

    public void flushBuffer() throws IOException {
        byte[] bytes = this.getBodyBytes();
        if (bytes != null) {
            this.getOutputStream().write(bytes, 0, this.getBodyBytesLength());
        }
        super.flushBuffer();
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public CompletableFuture<Void> sendPart(Part part) {
        ServletOutputStream outputStream;
        DownloadUtils.prepareDownloadHeader(this, part);
        try {
            outputStream = this.getOutputStream();
        }
        catch (IOException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
        Context context = Vertx.currentContext();
        return new PumpFromPart(context, part).toOutputStream((OutputStream)outputStream, false);
    }
}

