/*
 This file is part of GNUnet.
  (C) 2012, 2013 Christian Grothoff (and other contributing authors)

  GNUnet is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 3, or (at your
  option) any later version.

  GNUnet is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNUnet; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
 */

package org.gnunet.voting.messages;


import org.gnunet.construct.NestedMessage;
import org.gnunet.construct.UInt32;
import org.gnunet.construct.UnionCase;
import org.gnunet.construct.ZeroTerminatedString;
import org.gnunet.util.AbsoluteTimeMessage;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.crypto.EddsaSignature;

@UnionCase(42010)
public class SubmitFailureMessage implements GnunetMessage.Body {
    public static class SignedAuthorityTime {
        @NestedMessage
        public EddsaSignature signature;
        @UInt32
        public int purpose;
        @NestedMessage
        public AbsoluteTimeMessage time;
    }

    @ZeroTerminatedString
    public String reason;

    @NestedMessage(optional = true)
    public SignedAuthorityTime signedAuthorityTime;
}
