# -*- Python -*-

valid_interpolator_settings = (
    (  1, 0x00),
    (  2, 0x01),
    (  3, 0x02),
    (  4, 0x11),
    (  5, 0x04),
    (  6, 0x05),
    (  7, 0x06),
    (  8, 0x13),
    (  9, 0x08),
    ( 10, 0x09),
    ( 11, 0x0a),
    ( 12, 0x15),
    ( 13, 0x0c),
    ( 14, 0x0d),
    ( 15, 0x0e),
    ( 16, 0x33),
    ( 18, 0x18),
    ( 20, 0x19),
    ( 21, 0x26),
    ( 22, 0x1a),
    ( 24, 0x35),
    ( 25, 0x44),
    ( 26, 0x1c),
    ( 27, 0x28),
    ( 28, 0x1d),
    ( 30, 0x1e),
    ( 32, 0x37),
    ( 33, 0x2a),
    ( 35, 0x46),
    ( 36, 0x55),
    ( 39, 0x2c),
    ( 40, 0x39),
    ( 42, 0x56),
    ( 44, 0x3a),
    ( 45, 0x2e),
    ( 48, 0x57),
    ( 49, 0x66),
    ( 50, 0x49),
    ( 52, 0x3c),
    ( 54, 0x58),
    ( 55, 0x4a),
    ( 56, 0x3d),
    ( 60, 0x59),
    ( 63, 0x68),
    ( 64, 0x77),
    ( 65, 0x4c),
    ( 66, 0x5a),
    ( 70, 0x69),
    ( 72, 0x5b),
    ( 75, 0x4e),
    ( 77, 0x6a),
    ( 78, 0x5c),
    ( 80, 0x79),
    ( 81, 0x88),
    ( 84, 0x5d),
    ( 88, 0x7a),
    ( 90, 0x5e),
    ( 91, 0x6c),
    ( 96, 0x7b),
    ( 98, 0x6d),
    ( 99, 0x8a),
    (100, 0x99),
    (104, 0x7c),
    (105, 0x6e),
    (108, 0x8b),
    (110, 0x9a),
    (112, 0x7d),
    (117, 0x8c),
    (120, 0x9b),
    (121, 0xaa),
    (126, 0x8d),
    (128, 0x7f),
    (130, 0x9c),
    (132, 0xab),
    (135, 0x8e),
    (140, 0x9d),
    (143, 0xac),
    (144, 0xbb),
    (150, 0x9e),
    (154, 0xad),
    (156, 0xbc),
    (160, 0x9f),
    (165, 0xae),
    (168, 0xbd),
    (169, 0xcc),
    (176, 0xaf),
    (180, 0xbe),
    (182, 0xcd),
    (192, 0xbf),
    (195, 0xce),
    (196, 0xdd),
    (208, 0xcf),
    (210, 0xde),
    (224, 0xdf),
    (225, 0xee),
    (240, 0xef),
    (256, 0xff))

# (ratio, regval) = get_closest_ratio (target_ratio)

def get_closest_ratio (target_ratio):
    best = valid_interpolator_settings[0]
    min_delta = abs (target_ratio - best[0])
    for t in valid_interpolator_settings[1:]:
        new_delta = abs (target_ratio - t[0])
        if new_delta < min_delta:
            min_delta = new_delta
            best = t

    return best

