#! /usr/bin/env python
#
# Copyright (C) 2001,2002 Python Software Foundation

# Standard distutils setup.py install script for the `mimelib' library, a next
# generation MIME library for Python.  To install into your existing Python
# distribution, run the following at the command line:
#
# % python setup.py install

import sys
from os.path import basename

from distutils.core import setup
from distutils.command.install_lib import install_lib


class EmailInstall(install_lib):
    def byte_compile(self, files):
        # For Python 2.1.x do not byte compile the _compat22.py file since
        # that will most definitely fail.  Any newer Python can compile
        # everything.
        major, minor = sys.version_info[0:2]
        if major == 2 and minor == 1:
            files = [f for f in files if basename(f) <> '_compat22.py']
        return install_lib.byte_compile(self, files)


import email
setup(name='email',
      version=email.__version__,
      description='Standalone email package from Python 2.2/2.3',
      author='Barry Warsaw',
      author_email='barry@zope.com',
      url='http://sf.net/projects/mimelib',
      packages=['email'],
      # Because we need to selectively byte-compile
      cmdclass={'install_lib': EmailInstall},
      )
