/* swi_common.h -  Posix package decoding
   Copyright (C) 2005  James H. Lowe, Jr.  <jhlowe@acm.org>
   All Rights Reserved.

   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef swi_base_h_200501
#define swi_base_h_200501

#include "swuser_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "shcmd.h"
#include "swlib.h"
#include "swutilname.h"
#include "uxfio.h"
#include "strob.h"
#include "swvarfs.h"
#include "hllist.h"
#include "defer.h"
#include "porinode.h"
#include "ahs.h"
#include "taru.h"
#include "taruib.h"
#include "uinfile.h"
#include "swheader.h"
#include "swheaderline.h"
#include "sw.h"
#include "swicol.h"
#include "swi_common.h"

typedef struct {
	unsigned char id_startM;  /* Always SWI_BASE_ID_BEGIN */
	char type_idM;	
	int is_activeM;		
	char * tagM;
	time_t create_timeM;
	time_t mod_timeM;
	int header_indexM;	/* index in the global INDEX file       */
	SWHEADER  * global_indexM;	/* Global INDEX access object	*/
	unsigned char id_endM; /* Always SWI_BASE_ID_END */
} SWI_BASE;

#define SWI_BASE_ID_BEGIN	85	 /* Sanity id */ 
#define SWI_BASE_ID_END		170	 /* Sanity id */

void swi_base_init(SWI_BASE * base, int type, SWHEADER * index, SWPATH_EX * current);
void swi_base_assert(SWI_BASE * base);
void swi_base_set_is_active(SWI_BASE * base, int n);
int swi_base_update(void * vbase, void * user_);

#endif
