/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupFrame;
import org.openoffice.setup.Util.DialogFocusTraversalPolicy;

public class HelpDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JEditorPane editorPane;
    private JScrollPane editorScrollPane;
    private String helpFileName;
    private String helpFileString;

    public HelpDialog(SetupFrame setupFrame) {
        super(setupFrame.getDialog());
        InstallData data = InstallData.getInstance();
        this.helpFileString = setupFrame.getCurrentPanel().getHelpFileName();
        this.helpFileName = ResourceManager.getFileName(this.helpFileString);
        String helpTitle = ResourceManager.getString("String_Help");
        this.setTitle(helpTitle);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        toppanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        if (data.useRtl()) {
            toppanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new FlowLayout());
        buttonpanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        if (data.useRtl()) {
            buttonpanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.editorPane = this.createEditorPane();
        this.editorScrollPane = new JScrollPane(this.editorPane);
        this.editorScrollPane.setPreferredSize(new Dimension(250, 145));
        this.editorScrollPane.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        if (data.useRtl()) {
            this.editorScrollPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        String okString = ResourceManager.getString("String_OK");
        this.okButton = new JButton(okString);
        this.okButton.setEnabled(true);
        this.okButton.addActionListener(this);
        if (data.useRtl()) {
            this.okButton.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        JSeparator separator = new JSeparator();
        buttonpanel.add(this.okButton);
        this.getContentPane().add((Component)toppanel, "North");
        this.getContentPane().add((Component)this.editorScrollPane, "Center");
        this.getContentPane().add((Component)buttonpanel, "South");
        DialogFocusTraversalPolicy policy = new DialogFocusTraversalPolicy(new JComponent[]{this.okButton, this.editorScrollPane});
        this.setFocusTraversalPolicy(policy);
        this.setFocusCycleRoot(true);
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        InstallData data = InstallData.getInstance();
        File htmlDirectory = data.getInfoRoot("html");
        if (htmlDirectory != null) {
            File htmlFile = new File(htmlDirectory, this.helpFileName);
            if (!htmlFile.exists()) {
                System.err.println("Couldn't find file: " + htmlFile.toString());
            }
            try {
                editorPane.setContentType("text/html;charset=utf-8");
                editorPane.setPage(htmlFile.toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Attempted to read a bad URL");
            }
        } else {
            System.err.println("Did not find html directory");
        }
        return editorPane;
    }

    public void actionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

