/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.MenuItemCheckIconFactory;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    protected PropertyChangeListener propertyChangeListener;
    Handler handler;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static final String MAX_ARROW_ICON_WIDTH = "maxArrowIconWidth";
    static final String MAX_CHECK_ICON_WIDTH = "maxCheckIconWidth";
    static final String MAX_ICON_WIDTH = "maxIconWidth";
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static final Object MAX_ICON_OFFSET = new Object();
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("doClick"));
        BasicLookAndFeel.installAudioActionMap(lazyActionMap);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Object object;
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        if (this.acceleratorFont == null) {
            this.acceleratorFont = UIManager.getFont("MenuItem.font");
        }
        if ((object = UIManager.get(this.getPropertyPrefix() + ".opaque")) != null) {
            LookAndFeel.installProperty(this.menuItem, "opaque", object);
        } else {
            LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.TRUE);
        }
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        }
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", new Integer(4));
        this.defaultTextIconGap = this.menuItem.getIconTextGap();
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        LookAndFeel.installProperty(this.menuItem, "borderPainted", UIManager.getBoolean(string + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(string + ".checkIcon");
            MenuItemCheckIconFactory menuItemCheckIconFactory = (MenuItemCheckIconFactory)UIManager.get(string + ".checkIconFactory");
            if (menuItemCheckIconFactory != null && menuItemCheckIconFactory.isCompatible(this.checkIcon, string)) {
                this.checkIcon = menuItemCheckIconFactory.getIcon(this.menuItem);
            }
        }
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        this.installLazyActionMap();
        this.updateAcceleratorBinding();
    }

    void installLazyActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, BasicMenuItemUI.class, this.getPropertyPrefix() + ".actionMap");
    }

    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        JComponent jComponent2 = this.getMenuItemParent(this.menuItem);
        if (jComponent2 != null) {
            jComponent2.putClientProperty(MAX_CHECK_ICON_WIDTH, null);
            jComponent2.putClientProperty(MAX_ARROW_ICON_WIDTH, null);
            jComponent2.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent2.putClientProperty(MAX_TEXT_WIDTH, null);
            jComponent2.putClientProperty(MAX_ICON_WIDTH, null);
            jComponent2.putClientProperty(MAX_ICON_OFFSET, null);
            jComponent2.putClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        LookAndFeel.installProperty(this.menuItem, "borderPainted", this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return this.getHandler();
    }

    Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    InputMap createInputMap(int n) {
        if (n == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        InputMap inputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (inputMap != null) {
            inputMap.clear();
        }
        if (keyStroke != null) {
            if (inputMap == null) {
                inputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, inputMap);
            }
            inputMap.put(keyStroke, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    private JComponent getMenuItemParent(JMenuItem jMenuItem) {
        Container container = jMenuItem.getParent();
        if (!(!(container instanceof JComponent) || jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu())) {
            return (JComponent)container;
        }
        return null;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Insets insets;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = null;
        MenuItemCheckIconFactory menuItemCheckIconFactory = (MenuItemCheckIconFactory)UIManager.get(this.getPropertyPrefix() + ".checkIconFactory");
        if (!this.useCheckAndArrow() || menuItemCheckIconFactory == null || !menuItemCheckIconFactory.isCompatible(icon, this.getPropertyPrefix())) {
            icon3 = jMenuItem.getIcon();
        }
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n2;
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n3);
                string2 = string2 + this.acceleratorDelimiter;
            }
            string2 = (n2 = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n2) : string2 + keyStroke.getKeyChar();
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n, n);
        Rectangle rectangle = iconRect.union(textRect);
        BasicMenuItemUI.r.height = this.max(rectangle.height, BasicMenuItemUI.checkIconRect.height, BasicMenuItemUI.arrowIconRect.height, BasicMenuItemUI.acceleratorRect.height);
        BasicMenuItemUI.r.width = n;
        JComponent jComponent2 = this.getMenuItemParent(this.menuItem);
        this.addMaxWidth(jComponent2, MAX_ICON_WIDTH, BasicMenuItemUI.iconRect.width, n, false);
        this.addMaxWidth(jComponent2, MAX_TEXT_WIDTH, BasicMenuItemUI.textRect.width, n, false);
        this.addMaxWidth(jComponent2, MAX_ACC_WIDTH, BasicMenuItemUI.acceleratorRect.width, n, false);
        if (this.useCheckAndArrow()) {
            this.addMaxWidth(jComponent2, MAX_CHECK_ICON_WIDTH, BasicMenuItemUI.checkIconRect.width, n, true);
            this.addMaxWidth(jComponent2, MAX_ARROW_ICON_WIDTH, BasicMenuItemUI.arrowIconRect.width, n, false);
        }
        if ((insets = jMenuItem.getInsets()) != null) {
            BasicMenuItemUI.r.width += insets.left + insets.right;
            BasicMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (BasicMenuItemUI.r.width % 2 == 0) {
            ++BasicMenuItemUI.r.width;
        }
        if (BasicMenuItemUI.r.height % 2 == 0 && Boolean.TRUE != UIManager.get(this.getPropertyPrefix() + ".evenHeight")) {
            ++BasicMenuItemUI.r.height;
        }
        return r.getSize();
    }

    private int max(int ... nArray) {
        int n = Integer.MIN_VALUE;
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private void addMaxWidth(JComponent jComponent, String string, int n, int n2, boolean bl) {
        Integer n3 = null;
        if (jComponent != null) {
            n3 = (Integer)jComponent.getClientProperty(string);
        }
        if (n3 == null) {
            n3 = 0;
        }
        if (n > n3) {
            n3 = n;
            if (jComponent != null) {
                jComponent.putClientProperty(string, n3);
            }
        }
        if (n3 > 0) {
            BasicMenuItemUI.r.width += n2;
            BasicMenuItemUI.r.width += n3.intValue();
        } else if (bl) {
            BasicMenuItemUI.r.width += n2;
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n2 = jMenuItem.getWidth();
        int n3 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n2, n3);
        BasicMenuItemUI.viewRect.x += insets.left;
        BasicMenuItemUI.viewRect.y += insets.top;
        BasicMenuItemUI.viewRect.width -= insets.right + BasicMenuItemUI.viewRect.x;
        BasicMenuItemUI.viewRect.height -= insets.bottom + BasicMenuItemUI.viewRect.y;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font2);
        FontMetrics fontMetrics2 = SwingUtilities2.getFontMetrics(jComponent, graphics, this.acceleratorFont);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n4;
            int n5 = keyStroke.getModifiers();
            if (n5 > 0) {
                string = KeyEvent.getKeyModifiersText(n5);
                string = string + this.acceleratorDelimiter;
            }
            string = (n4 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n4) : string + keyStroke.getKeyChar();
        }
        Icon icon3 = null;
        MenuItemCheckIconFactory menuItemCheckIconFactory = (MenuItemCheckIconFactory)UIManager.get(this.getPropertyPrefix() + ".checkIconFactory");
        if (!this.useCheckAndArrow() || menuItemCheckIconFactory == null || !menuItemCheckIconFactory.isCompatible(icon, this.getPropertyPrefix())) {
            icon3 = jMenuItem.getIcon();
        }
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n);
        this.paintBackground(graphics, jMenuItem, color);
        Color color3 = graphics.getColor();
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color3);
            }
            if (this.useCheckAndArrow()) {
                icon.paintIcon(jComponent, graphics, BasicMenuItemUI.checkIconRect.x, BasicMenuItemUI.checkIconRect.y);
            }
            graphics.setColor(color3);
        }
        if (icon3 != null) {
            if (!buttonModel.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
                if (icon3 == null) {
                    icon3 = jMenuItem.getIcon();
                }
            } else {
                icon3 = jMenuItem.getIcon();
            }
            if (icon3 != null) {
                icon3.paintIcon(jComponent, graphics, BasicMenuItemUI.iconRect.x, BasicMenuItemUI.iconRect.y);
                graphics.setColor(color3);
            }
        }
        if (string2 != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, jMenuItem, textRect, string2);
            }
        }
        if (string != null && !string.equals("")) {
            int n6 = 0;
            JComponent jComponent2 = this.getMenuItemParent(this.menuItem);
            if (jComponent2 != null) {
                Integer n7 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
                int n8 = n7 != null ? n7 : BasicMenuItemUI.acceleratorRect.width;
                n6 = n8 - BasicMenuItemUI.acceleratorRect.width;
            }
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    SwingUtilities2.drawString((JComponent)jMenuItem, graphics, string, BasicMenuItemUI.acceleratorRect.x - n6, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    SwingUtilities2.drawString((JComponent)jMenuItem, graphics, string, BasicMenuItemUI.acceleratorRect.x - n6, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    SwingUtilities2.drawString((JComponent)jMenuItem, graphics, string, BasicMenuItemUI.acceleratorRect.x - n6 - 1, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                SwingUtilities2.drawString((JComponent)jMenuItem, graphics, string, BasicMenuItemUI.acceleratorRect.x - n6, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.useCheckAndArrow()) {
                icon2.paintIcon(jComponent, graphics, BasicMenuItemUI.arrowIconRect.x, BasicMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        if (jMenuItem.isOpaque()) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
            graphics.setColor(color2);
        } else if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color2);
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jMenuItem, graphics);
        int n = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(jMenuItem.getBackground().brighter());
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        } else {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities2.stringWidth(this.menuItem, fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        JComponent jComponent = this.getMenuItemParent(this.menuItem);
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        int n7 = n6;
        Object object = UIManager.get(this.getPropertyPrefix() + ".checkIconOffset");
        if (object instanceof Integer) {
            n7 = (Integer)object;
        }
        if (BasicGraphicsUtils.isLeftToRight(this.menuItem)) {
            int n8 = 0;
            Object object2 = UIManager.get(this.getPropertyPrefix() + ".minimumTextOffset");
            if (object2 instanceof Integer) {
                n8 = (Integer)object2;
            }
            rectangle3.x += n6;
            rectangle2.x += n6;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - rectangle4.width;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + n7;
                if (icon == null || icon2 != null) {
                    rectangle2.x += n6 + rectangle5.width;
                }
                rectangle3.x += n6 + rectangle5.width;
                rectangle3.x = Math.max(rectangle3.x, n8);
                rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
            }
            if (jComponent != null) {
                Integer n9 = (Integer)jComponent.getClientProperty(MAX_ICON_OFFSET);
                Integer n10 = (Integer)jComponent.getClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET);
                int n11 = n9 == null ? 0 : n9;
                int n12 = rectangle3.x - rectangle.x;
                int n13 = n10 == null ? 0 : n10;
                if (n12 > n13) {
                    jComponent.putClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, new Integer(n12));
                } else {
                    rectangle3.x = n13 + rectangle.x;
                }
                if (icon != null) {
                    if (n4 == 11 || n4 == 4) {
                        int n14 = rectangle2.x - rectangle.x;
                        if (n14 > n11) {
                            jComponent.putClientProperty(MAX_ICON_OFFSET, new Integer(n14));
                        } else {
                            rectangle2.x = n11 + rectangle.x;
                        }
                    } else {
                        rectangle2.x = n4 == 10 || n4 == 2 ? rectangle3.x + rectangle3.width + n6 : Math.max(rectangle3.x + rectangle3.width / 2 - rectangle2.width / 2, n11 + rectangle.x);
                    }
                }
            }
        } else {
            rectangle3.x -= n6;
            rectangle2.x -= n6;
            rectangle4.x = rectangle.x + rectangle6.width + n6;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + rectangle.width - n7 - rectangle5.width;
                if (icon == null || icon2 != null) {
                    rectangle2.x -= n6 + rectangle5.width;
                }
                rectangle3.x -= n6 + rectangle5.width;
                rectangle6.x = rectangle.x + n6;
            }
            if (jComponent != null) {
                Integer n15 = (Integer)jComponent.getClientProperty(MAX_ICON_OFFSET);
                Integer n16 = (Integer)jComponent.getClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET);
                int n17 = n15 == null ? 0 : n15;
                int n18 = rectangle.x + rectangle.width - rectangle3.x - rectangle3.width;
                int n19 = n16 == null ? 0 : n16;
                if (n18 > n19) {
                    jComponent.putClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET, new Integer(n18));
                } else {
                    rectangle3.x = rectangle.x + rectangle.width - n19 - rectangle3.width;
                }
                int n20 = 0;
                if (icon != null) {
                    if (n4 == 11 || n4 == 2) {
                        n20 = rectangle.x + rectangle.width - rectangle2.x - rectangle2.width;
                        if (n20 > n17) {
                            jComponent.putClientProperty(MAX_ICON_OFFSET, new Integer(n20));
                        } else {
                            rectangle2.x = rectangle.x + rectangle.width - n17 - rectangle2.width;
                        }
                    } else if (n4 == 10 || n4 == 4) {
                        rectangle2.x = rectangle3.x - n6 - rectangle2.width;
                    } else {
                        rectangle2.x = rectangle3.x + rectangle3.width / 2 - rectangle2.width / 2;
                        if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width - n17) {
                            rectangle2.x = rectangle2.x = rectangle.x + rectangle.width - n17 - rectangle2.width;
                        }
                    }
                }
            }
        }
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        if (this.useCheckAndArrow()) {
            rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
            rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    private boolean useCheckAndArrow() {
        boolean bl = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2;
            for (n2 = menuElementArray2.length - 1; n2 >= 0 && menuElementArray2[n2].getComponent() != container; --n2) {
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (!this.isInternalFrameSystemMenu()) {
            BasicLookAndFeel.playSound(this.menuItem, this.getPropertyPrefix() + ".commandSound");
        }
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String string = this.menuItem.getActionCommand();
        return string == "Close" || string == "Minimize" || string == "Restore" || string == "Maximize";
    }

    private static class Actions
    extends UIAction {
        private static final String CLICK = "doClick";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    class Handler
    implements MenuDragMouseListener,
    MouseInputListener,
    PropertyChangeListener {
        Handler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                menuSelectionManager.setSelectedPath(BasicMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1 && menuElementArray[menuElementArray.length - 1] == BasicMenuItemUI.this.menuItem) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n2 = menuElementArray.length - 1;
                    for (int i = 0; i < n2; ++i) {
                        menuElementArray2[i] = menuElementArray[i];
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "labelFor" || string == "displayedMnemonic" || string == "accelerator") {
                BasicMenuItemUI.this.updateAcceleratorBinding();
            } else if (string == "text" || "font" == string || "foreground" == string) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            } else if (string == "iconTextGap") {
                BasicMenuItemUI.this.defaultTextIconGap = ((Number)propertyChangeEvent.getNewValue()).intValue();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseClicked(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseReleased(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseEntered(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseExited(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseMoved(mouseEvent);
        }
    }
}

