/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.image.FetcherInfo;
import sun.awt.image.ImageFetchable;

class ImageFetcher
extends Thread {
    static final int HIGH_PRIORITY = 8;
    static final int LOW_PRIORITY = 3;
    static final int ANIM_PRIORITY = 2;
    static final int TIMEOUT = 5000;

    private ImageFetcher(ThreadGroup threadGroup, int n) {
        super(threadGroup, "Image Fetcher " + n);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(ImageFetchable imageFetchable) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            if (!fetcherInfo.waitList.contains(imageFetchable)) {
                fetcherInfo.waitList.addElement(imageFetchable);
                if (fetcherInfo.numWaiting == 0 && fetcherInfo.numFetchers < fetcherInfo.fetchers.length) {
                    ImageFetcher.createFetchers(fetcherInfo);
                }
                fetcherInfo.waitList.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ImageFetchable imageFetchable) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            if (fetcherInfo.waitList.contains(imageFetchable)) {
                fetcherInfo.waitList.removeElement(imageFetchable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFetcher(Thread thread) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            for (int i = 0; i < fetcherInfo.fetchers.length; ++i) {
                if (fetcherInfo.fetchers[i] != thread) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean amFetcher() {
        return ImageFetcher.isFetcher(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageFetchable nextImage() {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            ImageFetchable imageFetchable = null;
            long l = System.currentTimeMillis() + 5000L;
            while (imageFetchable == null) {
                while (fetcherInfo.waitList.size() == 0) {
                    long l2 = System.currentTimeMillis();
                    if (l2 >= l) {
                        return null;
                    }
                    try {
                        ++fetcherInfo.numWaiting;
                        fetcherInfo.waitList.wait(l - l2);
                    }
                    catch (InterruptedException interruptedException) {
                        ImageFetchable imageFetchable2 = null;
                        return imageFetchable2;
                    }
                    finally {
                        --fetcherInfo.numWaiting;
                    }
                }
                imageFetchable = (ImageFetchable)fetcherInfo.waitList.elementAt(0);
                fetcherInfo.waitList.removeElement(imageFetchable);
            }
            return imageFetchable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vector vector;
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        try {
            this.fetchloop();
            vector = fetcherInfo.waitList;
        }
        catch (Exception exception) {
            Vector vector2;
            try {
                exception.printStackTrace();
                vector2 = fetcherInfo.waitList;
            }
            catch (Throwable throwable) {
                Vector vector3 = fetcherInfo.waitList;
                synchronized (vector3) {
                    Thread thread = Thread.currentThread();
                    for (int i = 0; i < fetcherInfo.fetchers.length; ++i) {
                        if (fetcherInfo.fetchers[i] != thread) continue;
                        fetcherInfo.fetchers[i] = null;
                        --fetcherInfo.numFetchers;
                    }
                }
                throw throwable;
            }
            synchronized (vector2) {
                Thread thread = Thread.currentThread();
                for (int i = 0; i < fetcherInfo.fetchers.length; ++i) {
                    if (fetcherInfo.fetchers[i] != thread) continue;
                    fetcherInfo.fetchers[i] = null;
                    --fetcherInfo.numFetchers;
                }
            }
        }
        synchronized (vector) {
            Thread thread = Thread.currentThread();
            for (int i = 0; i < fetcherInfo.fetchers.length; ++i) {
                if (fetcherInfo.fetchers[i] != thread) continue;
                fetcherInfo.fetchers[i] = null;
                --fetcherInfo.numFetchers;
            }
        }
    }

    private void fetchloop() {
        Thread thread = Thread.currentThread();
        while (ImageFetcher.isFetcher(thread)) {
            thread.interrupted();
            thread.setPriority(8);
            ImageFetchable imageFetchable = ImageFetcher.nextImage();
            if (imageFetchable == null) {
                return;
            }
            try {
                imageFetchable.doFetch();
            }
            catch (Exception exception) {
                System.err.println("Uncaught error fetching image:");
                exception.printStackTrace();
            }
            ImageFetcher.stoppingAnimation(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startingAnimation() {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Thread thread = Thread.currentThread();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            for (int i = 0; i < fetcherInfo.fetchers.length; ++i) {
                if (fetcherInfo.fetchers[i] != thread) continue;
                fetcherInfo.fetchers[i] = null;
                --fetcherInfo.numFetchers;
                thread.setName("Image Animator " + i);
                if (fetcherInfo.waitList.size() > fetcherInfo.numWaiting) {
                    ImageFetcher.createFetchers(fetcherInfo);
                }
                return;
            }
        }
        thread.setPriority(2);
        thread.setName("Image Animator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stoppingAnimation(Thread thread) {
        FetcherInfo fetcherInfo = FetcherInfo.getFetcherInfo();
        Vector vector = fetcherInfo.waitList;
        synchronized (vector) {
            int n = -1;
            for (int i = 0; i < fetcherInfo.fetchers.length; ++i) {
                if (fetcherInfo.fetchers[i] == thread) {
                    return;
                }
                if (fetcherInfo.fetchers[i] != null) continue;
                n = i;
            }
            if (n >= 0) {
                fetcherInfo.fetchers[n] = thread;
                ++fetcherInfo.numFetchers;
                thread.setName("Image Fetcher " + n);
                return;
            }
        }
    }

    private static void createFetchers(final FetcherInfo fetcherInfo) {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2;
        AppContext appContext = AppContext.getAppContext();
        ThreadGroup threadGroup3 = appContext.getThreadGroup();
        try {
            if (threadGroup3.getParent() != null) {
                threadGroup2 = threadGroup3;
            } else {
                threadGroup3 = Thread.currentThread().getThreadGroup();
                threadGroup = threadGroup3.getParent();
                while (threadGroup != null && threadGroup.getParent() != null) {
                    threadGroup3 = threadGroup;
                    threadGroup = threadGroup3.getParent();
                }
                threadGroup2 = threadGroup3;
            }
        }
        catch (SecurityException securityException) {
            threadGroup2 = appContext.getThreadGroup();
        }
        threadGroup = threadGroup2;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < fetcherInfo.fetchers.length; ++i) {
                    if (fetcherInfo.fetchers[i] != null) continue;
                    fetcherInfo.fetchers[i] = new ImageFetcher(threadGroup, i);
                    fetcherInfo.fetchers[i].start();
                    ++fetcherInfo.numFetchers;
                    break;
                }
                return null;
            }
        });
    }
}

