/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.InstallerHelper;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.Util.Converter;
import org.openoffice.setup.Util.ExecuteProcess;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.SystemManager;

public class LinuxHelper {
    private void getPackageNamesContent(PackageDescription packageData, Vector packageNames) {
        if (packageData.getPackageName() != null && !packageData.getPackageName().equals("")) {
            packageNames.add(packageData.getPackageName() + "=" + packageData.getFullPackageName());
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            this.getPackageNamesContent(child, packageNames);
        }
    }

    private String getPackageNameFromRpm(PackageDescription packageData, InstallData installData) {
        String rpmFileName;
        File rpmFile;
        String fullPackageName = null;
        String packagePath = installData.getPackagePath();
        if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
            File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
            packagePath = completePackageFile.getPath();
        }
        if ((rpmFile = new File(packagePath, rpmFileName = packageData.getPackageName())).exists()) {
            String rpmCommand = "rpm -qp " + rpmFile.getPath();
            String[] rpmCommandArray = new String[]{"rpm", "-qp", rpmFile.getPath()};
            Vector returnVector = new Vector();
            Vector returnErrorVector = new Vector();
            int returnValue = ExecuteProcess.executeProcessReturnVector(rpmCommandArray, returnVector, returnErrorVector);
            String returnString = (String)returnVector.get(0);
            String log = rpmCommand + "<br><b>Returns: " + returnString + "</b><br>";
            LogManager.addCommandsLogfileComment(log);
            fullPackageName = returnString;
        } else {
            System.err.println("Error: Could not find file " + rpmFile.getPath());
        }
        return fullPackageName;
    }

    private boolean checkPackageExistence(PackageDescription packageData, InstallData installData) {
        String rpmFileName;
        File rpmFile;
        boolean fileExists = false;
        String packagePath = installData.getPackagePath();
        if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
            File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
            packagePath = completePackageFile.getPath();
        }
        if ((rpmFile = new File(packagePath, rpmFileName = packageData.getPackageName())).exists()) {
            fileExists = true;
        }
        return fileExists;
    }

    private HashMap analyzeVersionString(String versionString) {
        String compareString;
        boolean errorOccured = false;
        Integer micro = null;
        Integer minor = null;
        Integer major = null;
        Integer release = null;
        String microString = null;
        String minorString = null;
        String majorString = null;
        String releaseString = null;
        int pos = versionString.lastIndexOf("_");
        if (pos > -1) {
            try {
                releaseString = versionString.substring(pos + 1, versionString.length());
                versionString = versionString.substring(0, pos);
            }
            catch (IndexOutOfBoundsException ex) {
                System.err.println("Error: Could not get substring from " + versionString);
                errorOccured = true;
            }
            try {
                int releaseInt = Integer.parseInt(releaseString);
                release = new Integer(releaseInt);
            }
            catch (NumberFormatException ex) {
                System.err.println("Error: Could not convert " + releaseString + " to integer");
                errorOccured = true;
            }
        }
        if ((pos = (compareString = versionString).lastIndexOf(".")) > -1) {
            String substring = compareString.substring(0, pos);
            if ((pos = substring.lastIndexOf(".")) == -1) {
                versionString = versionString + ".0";
            }
        } else {
            versionString = versionString + ".0.0";
        }
        pos = versionString.lastIndexOf(".");
        if (pos > -1) {
            try {
                microString = versionString.substring(pos + 1, versionString.length());
                versionString = versionString.substring(0, pos);
            }
            catch (IndexOutOfBoundsException ex) {
                System.err.println("Error: Could not get substring from " + versionString);
                errorOccured = true;
            }
            pos = versionString.lastIndexOf(".");
            if (pos > -1) {
                try {
                    minorString = versionString.substring(pos + 1, versionString.length());
                    majorString = versionString.substring(0, pos);
                }
                catch (IndexOutOfBoundsException ex) {
                    System.err.println("Error: Could not get substring from " + versionString);
                    errorOccured = true;
                }
                try {
                    int microInt = Integer.parseInt(microString);
                    int minorInt = Integer.parseInt(minorString);
                    int majorInt = Integer.parseInt(majorString);
                    micro = new Integer(microInt);
                    minor = new Integer(minorInt);
                    major = new Integer(majorInt);
                }
                catch (NumberFormatException ex) {
                    System.err.println("Error: Could not convert " + microString + "," + minorString + " or " + majorString + " to integer");
                    errorOccured = true;
                }
            }
        }
        if (errorOccured) {
            micro = null;
            minor = null;
            major = null;
            release = null;
        }
        HashMap<String, Integer> hashRpm = new HashMap<String, Integer>();
        hashRpm.put("micro", micro);
        hashRpm.put("minor", minor);
        hashRpm.put("major", major);
        hashRpm.put("release", release);
        return hashRpm;
    }

    private HashMap analyzeReleaseString(HashMap hashRpm, String releaseString) {
        try {
            int release = Integer.parseInt(releaseString);
            Integer releaseObj = new Integer(release);
            hashRpm.put("release", releaseObj);
        }
        catch (NumberFormatException ex) {
            hashRpm.put("release", null);
        }
        return hashRpm;
    }

    public int getInstalledMinor(String version) {
        String reduced;
        int minor = 0;
        int pos = version.indexOf(".");
        if (pos > -1 && (pos = (reduced = version.substring(pos + 1, version.length())).indexOf(".")) > -1) {
            reduced = reduced.substring(0, pos);
            minor = Integer.parseInt(reduced);
        }
        return minor;
    }

    private boolean compareTwoRpms(HashMap hash1, HashMap hash2) {
        boolean hash1IsOlder = false;
        if (hash1.get("major") != null && hash2.get("major") != null) {
            if ((Integer)hash1.get("major") < (Integer)hash2.get("major")) {
                hash1IsOlder = true;
            } else if (hash1.get("minor") != null && hash2.get("minor") != null) {
                if ((Integer)hash1.get("minor") < (Integer)hash2.get("minor")) {
                    hash1IsOlder = true;
                } else if (hash1.get("micro") != null && hash2.get("micro") != null) {
                    if ((Integer)hash1.get("micro") < (Integer)hash2.get("micro")) {
                        hash1IsOlder = true;
                    } else if (hash1.get("release") != null && hash2.get("release") != null && (Integer)hash1.get("release") < (Integer)hash2.get("release")) {
                        hash1IsOlder = true;
                    }
                }
            }
        }
        return hash1IsOlder;
    }

    public boolean compareVersionAndRelease(String versionString, String releaseString, PackageDescription packageData, boolean checkIfInstalledIsOlder) {
        HashMap notInstalledRpm;
        HashMap installedRpm = this.analyzeVersionString(versionString);
        if (installedRpm.get("release") == null) {
            installedRpm = this.analyzeReleaseString(installedRpm, releaseString);
        }
        if ((notInstalledRpm = this.analyzeVersionString(packageData.getPkgVersion())).get("release") == null) {
            notInstalledRpm = this.analyzeReleaseString(notInstalledRpm, packageData.getPkgRelease());
        }
        boolean firstIsOlder = false;
        firstIsOlder = checkIfInstalledIsOlder ? this.compareTwoRpms(installedRpm, notInstalledRpm) : this.compareTwoRpms(notInstalledRpm, installedRpm);
        return firstIsOlder;
    }

    public void getLinuxPackageNamesFromRpmquery(PackageDescription packageData, InstallData installData) {
        if (packageData.getPackageName() != null && !packageData.getPackageName().equals("")) {
            boolean rpmExists = this.checkPackageExistence(packageData, installData);
            if (rpmExists) {
                if (packageData.getFullPackageName() == null || packageData.getFullPackageName().equals("")) {
                    String fullPackageName = this.getPackageNameFromRpm(packageData, installData);
                    if (fullPackageName != null) {
                        packageData.setFullPackageName(fullPackageName);
                    } else {
                        System.err.println("Error: Linux package name not defined in xpd file and could not be determined: " + packageData.getPackageName());
                    }
                }
                packageData.setPkgExists(true);
            } else {
                packageData.setPkgExists(false);
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            this.getLinuxPackageNamesFromRpmquery(child, installData);
        }
    }

    public String getLinuxDatabasePath(InstallData data) {
        String installDir;
        String databasePath = null;
        String databaseDir = installDir = data.getInstallDir();
        String linuxDatabaseName = ".RPM_OFFICE_DATABASE";
        File databaseFile = new File(databaseDir, linuxDatabaseName);
        databasePath = databaseFile.getPath();
        return databasePath;
    }

    public void investigateDebian(InstallData data) {
        String dpkgFile = "/usr/bin/dpkg";
        if (new File(dpkgFile).exists()) {
            data.setIsDebianSystem(true);
            String[] rpmQueryArray = new String[]{"rpm", "--help"};
            Vector returnVector = new Vector();
            Vector returnErrorVector = new Vector();
            int returnValue = ExecuteProcess.executeProcessReturnVector(rpmQueryArray, returnVector, returnErrorVector);
            for (int i = 0; i < returnVector.size(); ++i) {
                String line = (String)returnVector.get(i);
                if (line.indexOf("force-debian") <= -1) continue;
                data.setUseForceDebian(true);
            }
        }
    }

    public void getLinuxFileInfo(PackageDescription packageData) {
        InstallData data = InstallData.getInstance();
        if (packageData.pkgExists() && packageData.getFullPackageName() != null && !packageData.getFullPackageName().equals("")) {
            String longName = packageData.getFullPackageName();
            int pos = longName.lastIndexOf("-");
            if (data.isInstallationMode()) {
                packageData.setPkgRelease(longName.substring(pos + 1, longName.length()));
            }
            longName = longName.substring(0, pos);
            pos = longName.lastIndexOf("-");
            if (data.isInstallationMode()) {
                packageData.setPkgVersion(longName.substring(pos + 1, longName.length()));
            }
            packageData.setPkgRealName(longName.substring(0, pos));
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            this.getLinuxFileInfo(child);
        }
    }

    public void setFullPackageNameAtUninstall(PackageDescription packageData, HashMap packageNames) {
        if (packageData.getPackageName() != null && !packageData.getPackageName().equals("") && (packageData.getFullPackageName() == null || packageData.getFullPackageName().equals(""))) {
            String packageName = packageData.getPackageName();
            String fullPackageName = (String)packageNames.get(packageName);
            packageData.setFullPackageName(fullPackageName);
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            this.setFullPackageNameAtUninstall(child, packageNames);
        }
    }

    public String getRelocationString(PackageDescription packageData, String packageName) {
        String relocationString = null;
        if (packageData.isRelocatable()) {
            String[] rpmQueryArray = new String[]{"rpm", "-qp", "--qf", "%{PREFIXES}", packageName};
            Vector returnVector = new Vector();
            Vector returnErrorVector = new Vector();
            int returnValue = ExecuteProcess.executeProcessReturnVector(rpmQueryArray, returnVector, returnErrorVector);
            relocationString = (String)returnVector.get(0);
        }
        return relocationString;
    }

    public void createPackageNameFileAtPostinstall(InstallData data, PackageDescription packageData) {
        File destDir = new File(data.getInstallDefaultDir(), data.getProductDir());
        File uninstallDir = new File(destDir, data.getUninstallDirName());
        String fileName = "packageNames";
        File packageNamesFile = new File(uninstallDir, fileName);
        Vector packageNames = new Vector();
        this.getPackageNamesContent(packageData, packageNames);
        SystemManager.saveCharFileVector(packageNamesFile.getPath(), packageNames);
    }

    public HashMap readPackageNamesFile() {
        String fileName = "packageNames";
        InstallData data = InstallData.getInstance();
        File dir = data.getInfoRoot();
        File file = new File(dir, fileName);
        Vector fileContent = SystemManager.readCharFileVector(file.getPath());
        HashMap map = Converter.convertVectorToHashmap(fileContent);
        return map;
    }

    public void saveModulesLogFile(InstallData data) {
        if (data.logModuleStates()) {
            Vector logContent = LogManager.getModulesLogFile();
            File destDir = new File(data.getInstallDefaultDir(), data.getProductDir());
            File uninstallDir = new File(destDir, data.getUninstallDirName());
            File modulesLogFile = new File(uninstallDir, "moduleSettingsLog.txt");
            SystemManager.saveCharFileVector(modulesLogFile.getPath(), logContent);
        }
    }

    public String fixInstallationDirectory(String installDir) {
        int lastSlashPos = installDir.lastIndexOf(47);
        String sub1 = installDir.substring(0, lastSlashPos);
        String sub2 = installDir.substring(lastSlashPos);
        String fixedInstallDir = sub1 + "/" + sub2;
        return fixedInstallDir;
    }
}

