<?php

// filemanager_down.php - PHProjekt Version 3.3
// copyright    2000-2002 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther
error_reporting(0);

// list of common filetypes
$filetypes = array("gif" => "image/gif", "jpg" => "image/jpeg", "png" => "image/png", "xls" => "application/msexcel",
                   "ppt" => "application/mspowerpoint", "doc" => "application/msword", "html" => "text/html",
                   "htm" => "text/html", "rtf" => "text/rtf", "zip" => "application/zip", "mp3" => "audio/mpeg",
                   "txt" => "text/plain", "tar.gz" => "application/x-gzip");

// some security measures:
// 1. intialise the array so noone can introduce poisoned variables
$arr = array();

// include lib to fetch the sessiond data and to perform check
$path_pre="../";
$include_path = $path_pre."lib/lib.inc.php";
include_once $include_path;

// explode the array element given by the transferred number
$arr = explode("|",$file_ID[$nr]);
// build name and path
$name = $arr[0];
$path = "../".$dat_rel."/".$arr[1];
$name = ereg_replace(""," ",$name);
if (!file_exists($path)) { die("panic! specified file not found ..."); }

// 2. security measure: Prevent escaping from the attach dir
if ((ereg('/', $arr[1])) or (ereg('^\.+$', $arr[1]))) { die("You are not allowed to do this!");  }

// 3. security measure: check the permission of the user

check_permission($arr[2]);

// session_cache_limiter('public');   // suppress error messages for PHP version < 4.0.2


// encrypt string delivered?
if ($encryptstring) {
  header ("Expires: Mon, 10 Dec 2001 08:00:00 GMT");
  header ("Last-Modified: " . gmdate ("D, d M Y H:i:s") . " GMT");
  header ("Cache-Control: no-cache, must-revalidate");
  header ("Pragma: no-cache");
  header ("Content-type: application/octet-stream");
  header ("Content-disposition: attachment; filename=$name");

  // include the encryption routine
  $path_pre="../";
  $include_path = $path_pre."lib/crypt.inc.php";
  include_once $include_path;
  // first create an appropiate string:
  //1. crypt the password,
  //$encryptstring = encrypt($encryptstring, $encryptstring);
  $bytes = 65536;
  // 2: string must be longer than the content piece
  for ($i = 0; $i <= floor($bytes/strlen($encryptstring)); $i++) $pwnew .= $encryptstring;
  // open the file
  $file = fopen($path, "rb");
  while($line = fread($file, $bytes)) {
    // shift the content back ...
    $line2 = $pwnew ^ $line ;
    // output
    echo $line2;
  }
  $header_found = 1;
}

// special case pdf - often fails if you try to open it inline -> only download option :-(
elseif (eregi(".pdf",$name)) {
  header("Content-type: application/pdf");
  header( "Content-Disposition: attachment; filename=$name");
  $header_found = 1;
  readfile($path);
}


/* // *** uncomment here if you want to use the mime types
// show files with known filetype inline - not tested until now
else {
  // set headers, force the browser to avoid the cache
  header ("Expires: Mon, 12 Dec 2001 08:00:00 GMT");
  header ("Last-Modified: " . gmdate ("D, d M Y H:i:s") . " GMT");
  header ("Cache-Control: no-cache, must-revalidate");
  header ("Pragma: no-cache");

  $filetypesExt = array_keys($filetypes);

  for ( $i = 0; $i < count ($filetypesExt); $i++) {
    if ( preg_match ("/^(.*)\.$filetypesExt[$i]$/i", $name) ) {
     $key = $i;
    }
  }


  if ( isset ($key) ) {
      header("Content-type: ".$filetypes[$filetypesExt[$key]]);
      header("Content-Disposition: inline; filename=$name");
      $header_found = 1;
      readfile($path);
  }
}
*/ // *** end uncomment


if (!$header_found) {
  // set headers, force the browser to avoid the cache
  header ("Expires: Mon, 12 Dec 2001 08:00:00 GMT");
  header ("Last-Modified: " . gmdate ("D, d M Y H:i:s") . " GMT");
  header ("Cache-Control: no-cache, must-revalidate");
  header ("Pragma: no-cache");
  header("Content-type: application/octet-stream");
  header("Content-disposition: inline; filename=$name");

  // no encryption string -> deliver the normal file
  readfile($path);
}

// check permission
function check_permission($file_ID) {
  global $user_ID, $user_kurz, $user_group;

  // fetch access data from this record
  $result = db_query("select von, acc, gruppe from dateien where ID = '$file_ID'") or db_die();
  $row = db_fetch_row($result);
  // if the user is not 1. th owner or 2. a privileged person and 3. the file is not open to the group -> go to hell
  if ($row[2] <> $user_group or ($row[0] <> $user_ID and $row[1] <> 'group' and !eregi("\"$user_kurz\"",$row[1]))) {
    die("You are not allowed to do this");
  }
}
?>