<?php
session_start();
$PHPSESSID=session_id();

//---------------------------------------------
// import of get,  post, cookie and session vars
//   independent of register_globals and magic_quotes_gpc
//   all 4 combinations of this ini settings have identical results.

//   The POST section shows how to import arrays. The other sections
//   must be changed in this way if arrays are expected.

function arr_addsl(&$item,$key){$item = addslashes($item);}

if(isset($HTTP_GET_VARS)) {
  reset($HTTP_GET_VARS);
  foreach($HTTP_GET_VARS as $key=>$value) {
         if(get_magic_quotes_gpc()) $$key=$value;
         else $$key=addslashes($value);
  }
}
if(isset($HTTP_POST_VARS)) {
  reset($HTTP_POST_VARS);
  foreach($HTTP_POST_VARS as $key=>$value) {
         if(get_magic_quotes_gpc()) $$key=$value;
         else{
           if(is_array($value)) {array_walk($value,'arr_addsl'); $$key=$value;}
           else $$key=addslashes($value);
         }
  }
}
if(isset($HTTP_COOKIE_VARS)) {
  reset($HTTP_COOKIE_VARS);
  foreach($HTTP_COOKIE_VARS as $key=>$value) {
         if(get_magic_quotes_gpc()) $$key=$value;
         else $$key=addslashes($value);
  }
}
if(isset($HTTP_SESSION_VARS)) {
  reset($HTTP_SESSION_VARS);
  foreach($HTTP_SESSION_VARS as $key=>$value) {
         $$key=$value;
  }
}

//--------------------------------------------
// Import of ONLY ONE uploaded file with the static handle 'userfile'.
//  Can be later improved to handle multifile upload.
// set variable $userfile to zero in order to avoid that it will be redirected ...
$userfile = "";
if(isset($HTTP_POST_FILES['userfile'])){
  $userfile_name = $HTTP_POST_FILES['userfile']['name'];
  $userfile_type = $HTTP_POST_FILES['userfile']['type'];
  $userfile_size = $HTTP_POST_FILES['userfile']['size'];
  $userfile = $HTTP_POST_FILES['userfile']['tmp_name'];
}

//---------------------------------------------
// Import some used server/environment vars
$HTTP_USER_AGENT = getenv("HTTP_USER_AGENT");
$PHP_SELF = $HTTP_SERVER_VARS["PHP_SELF"];

//---------------------------------------------
// Treatment for runtime-generated data (SQL, ecec()...)
// Result independent of magic_quotes_runtime.
function quote_runtime($x){
   if(!get_magic_quotes_runtime()) {
      if(is_array($x)) array_walk($x,'arr_addsl');
      else $x = addslashes($x);
   }
   return $x;
}

//---------------------------------------------
// register session vars independent of register_globals
// function call:  reg_sess_vars(array_of_varnames);
//       example:  reg_sess_vars(array("probe","test"));
function reg_sess_vars($sess_vars){
   global $HTTP_SESSION_VARS;
   if(ini_get('register_globals')) session_register($sess_vars);
   else foreach($sess_vars as $varname)$HTTP_SESSION_VARS[$varname] = $GLOBALS[$varname];
}

//-----------------------------------------------
// unregister a session var independent of register_globals
// function call: unreg_sess_var(varname);
//       example: unreg_sess_var("probe");
function unreg_sess_var($varname){
   global $HTTP_SESSION_VARS;
   if(ini_get('register_globals')) session_unregister($varname);
   else unset($HTTP_SESSION_VARS[$varname]);
}
?>