<?php
// lib.inc.php - PHProjekt Version 3.3
// copyright    2000-2002 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther

// set error reporting
// error_reporting( E_ALL & ~E_NOTICE);
error_reporting(0);

// check whether $path_pre doesn't redirect to some outer place
if (isset($path_pre) and $path_pre <> "./" and $path_pre <> "../" and $path_pre <> "../../") { die("You are not allowed to do this"); }

// set include path.
$var_ini_set = ini_set('include_path','./');
// parse transmitted variables
$include_path = $path_pre."lib/gpcs_vars.inc.php";
include_once $include_path;

// set constant to ensure that the lib is included (especially for those who want to access a script directly)
define ("lib_included","1");

// array with available languages
$languages = array("ad","br","ct","cz","da","de","en","es","fi","fr","gr","hu","is","it","ko","nl",
                   "no","pl","pt","ro","ru","se","si","tr","tw","zh");

// fetch parameters from config.inc.php - could be placed in the PHProjekt root or two levels above = outside the webroot!
// only avoid including the config if the setup routine is active ...
if (!defined("setup_included")) {
  $config_path = $path_pre."config.inc.php";  // set config path for files in subdir
  if (is_readable("../../$config_path")) include("../../$config_path");
  elseif (is_readable("$config_path")) include("./$config_path");
  else { die("panic: config.inc.php doesn't exist!! Did you backup it after installation? ..."); }
}


// Determine OS for style sheet
$css_style = def_style();

//exclude old browsers
if (eregi("MSIE 3",$HTTP_USER_AGENT)) { die("Sorry, not for IE3!"); }

// change path if a script from a subdir is calling ...
  $lang_path = $path_pre."lang";
  $lib_path = $path_pre."lib";
  $img_path = $path_pre."img";


// language given? -> include language file
if ($langua) { include_once("$lang_path/$langua.inc.php"); }
// determine language for login and -if no language is given in the db- further on
else {
  // determine language of browser
  $langua = getenv("HTTP_ACCEPT_LANGUAGE");

  // special patch for canadian users
  if (eregi("ca",$langua)) {
    // english canadian
    if (eregi("en",$langua)) { $langua = "en"; $found = 1; }
    // french canadian
    if (eregi("fr",$langua)) { $langua = "fr"; $found = 1; }
  }
  // special patch for user with konqueROr :-)
  elseif (eregi("queror",$langua)) { $langua = "en"; $found = 1; }
  // otherwise loop over all available languages
  else {
    foreach($languages as $langua1) {
      if (eregi($langua1,$langua)) {
        $langua = $langua1; $found = 1;
      }
    }
  }
  // include the found language
  if ($found) { include_once("$lang_path/$langua.inc.php"); }
  // nothing found? -> take english
  else { $langua = "en"; include_once("$lang_path/en.inc.php"); }
}



// set charset
if     (eregi('pl|cz|hu|si',$langua)) { $lcfg="charset=iso-8859-2"; }
elseif ($langua=="ru") { $lcfg="charset=windows-1251"; }
elseif ($langua=="tw") { $lcfg = "charset=big5"; }
elseif ($langua=="zh") { $lcfg = "charset=gb2312"; }
if ($lcfg <> "") { $lang_cfg = "<meta http-equiv='Content-Type' content='text/html; $lcfg'>"; }

// set time
$dbTSnull = date("YmdHis", mktime(date("H")+$timezone,date("i"),date("s"),date("m"),date("d"),date("Y")));

// ************
// db functions
// ************

// Connect
if ( $db_type == "mysql" ) {
  $dbIDnull = "null";
  $link = mysql_connect($db_host, $db_user, $db_pass) or mysql_error();
  $conn = mysql_select_db($db_name);
}
elseif ( $db_type == "interbase" ) {
  $dbIDnull = "null";
  $db_host2 = "$db_host:$db_name";
  $link = ibase_connect($db_host2, $db_user, $db_pass);
}
elseif ( $db_type == "postgresql" ) {
  $dbIDnull = "pgnull";
  $link = pg_connect((($db_host == "") ? "" : "host=$db_host ").(($db_pass == "") ? "" : "password=$db_pass ")."dbname=$db_name user=$db_user") or pg_errormessage();
}
elseif ( $db_type == "oracle" ) {
  $dbIDnull = "null";
  $link = OCILogon($db_user, $db_pass, $db_name);
  $datestmt = OCIParse($link, "alter session set NLS_DATE_FORMAT='YYYY-MM-DD HH:MI:SS'");
  OCIExecute($datestmt);
}
elseif ( $db_type == "informix" ) {
  $dbIDnull = "0";
  if ($db_host == "") $db = $db_name; else $db = $db_name."@".$db_host;
  $link = ifx_connect($db, $db_user, $db_pass);
}

elseif ( $db_type == "ms_sql" ) {
  $dbIDnull = "msnull";
  $link = mssql_connect($db_host, $db_user, $db_pass);
  $conn = mssql_select_db($db_name);
}
if(!$link || (isset($conn) && !$conn)) die("<b>Database connection failed!</b><br>Call admin, please.");
// Query Statement
function db_query($query) {
  //mysql
  global $db_type, $link, $stmt, $counter, $f_row;
  if ($db_type == "mysql"){
    return mysql_query($query);
  }

  // interbase
  elseif($db_type == "interbase") {
    $query = ereg_replace("= ''","= '99999'",$query); // ib can't handle empty strings for integer fields
    $query = ereg_replace("=''","= '99999'",$query);
    $stmt = ibase_query($link, $query);
    if (eregi('insert|update|delete|create',$query)) {
     ibase_commit();
    }
    return $stmt;
  }

  // postgres
  elseif ($db_type == "postgresql") {
    //get name of sequence
    if    (preg_match("/INTO\s*(\w*)\s*/",$query,$matches)){$dbIDnull="nextval('" . $matches[1] . "_id_seq')"; }
    elseif(preg_match("/into\s*(\w*)\s*/",$query,$matches)){$dbIDnull="nextval('" . $matches[1] . "_id_seq')"; }
    $query=ereg_replace("pgnull", $dbIDnull,$query);
    $tmp = pg_exec($link, $query);
    $f_row[$tmp]=0;
    return($tmp);
  }

  // oracle
  elseif ($db_type == "oracle") {
    $stmt =  OCIParse($link, $query);
    OCIExecute($stmt);
    if (eregi('insert|update|delete|create',$query)) {
     $commit_stmt = OCIParse($link, 'commit');
     OCIExecute($commit_stmt);
     }
    return $stmt;
  }

  // informix
  elseif ($db_type == "informix") {
    $rid = ifx_prepare($query, $link);
    if (!ifx_do($rid)) {
      ifx_error();
    }
    return $rid;
  }

  // ms_sql
  elseif ($db_type == "ms_sql")  {
    $sPattern = 'msnull[ ]*,';
    $sNewQuery = eregi_replace($sPattern, '', $query);
    return mssql_query($sNewQuery);
  }
}

// fetch row statement
function db_fetch_row ($result) {
  global $db_type,$link,$f_row;
  if ($db_type == "mysql")    {
    return @mysql_fetch_row($result);
  }
  elseif ($db_type == "interbase") {
    return ibase_fetch_row($result);
  }
  elseif ($db_type == "postgresql") {
    if(++$f_row[$result] > pg_numrows($result)){return 0;}
    else {return pg_fetch_row($result, ($f_row[$result]-1));}
  }
  elseif ($db_type == "oracle") {
    OCIFetchInto($result, $row, OCI_RETURN_NULLS+OCI_RETURN_LOBS);
    return $row;
  }
  elseif ($db_type == "informix") {
    if ($row = ifx_fetch_row($result)) {
      $types = ifx_fieldtypes($result);
      $row = array_values($row);
    }
    return $row;
  }
  elseif ($db_type == "ms_sql")    {
    return mssql_fetch_row($result);
  }
}

// Error-Messages
function db_die() {
  global $db_type;
  if     ($db_type == "mysql") { echo mysql_error(); }
  elseif ($db_type == "postgresql") {echo pg_errormessage($link);}
  elseif ($db_type == "oracle") {echo OCIError($stmt);}
  elseif ($db_type == "informix") {echo ifx_error();}
  elseif ($db_type == "ms_sql") { echo mssql_get_last_message();}
  elseif ($db_type == "interbase") { echo ibase_errmsg();}
  die("</body></html>");

}

// safe HTML output
function html_out($outstr){
  if ($outstr <> "") return ereg_replace("'","&#39;",htmlspecialchars($outstr));
}
  // the same specialy for hidden form fields and select field option values (uev -> UrlEncodedValues)
function uev_out($outstr){return ereg_replace("'","&#39;",htmlspecialchars(urlencode($outstr)));}  #

// here we will build the iso format
function show_iso_date1($date) {
  return substr($date,0,4)."-".substr($date,4,2)."-".substr($date,6,2)." ".substr($date,8,2).":".substr($date,10,2);
}

// quotation related string treatment for arrays
  // to call with array_walk()
// function arr_addsl(&$item,$key){$item = addslashes($item);}
   // is moved to gpcs_vars.inc.php because used before loading lib.inc.php
function arr_stripsl(&$item,$key){$item = stripslashes($item);}
function arr_dequote(&$item,$key){$item = addslashes(ereg_replace('^\"|\"$','',$item));}

// change colours in list view
function tr_tag ($dblclick) {
  global $cnr, $bgcolor1, $bgcolor2, $tr_hover;
  // alternate bgcolor
  if (($cnr/2) == round($cnr/2)) { $color = "$bgcolor1"; $cnr++;}
  else { $color = "$bgcolor2"; $cnr++; }
  // highlight table rows?
  if ($tr_hover) { $tr_hover_on = "onmouseover=\"this.style.backgroundColor = '#ffffff'\" onmouseout=\"this.style.backgroundColor = '$color'\" onDblClick=\"location.href = '$dblclick'\""; }
  else { $tr_hover_on = ""; }
  // html output
  echo "<tr bgcolor=$color $tr_hover_on>\n";
}

// limit session to a certain time [minutes]
if ($session_time_limit) {
  if (!$begin) {
    $begin = time();
    reg_sess_vars(array("begin"));
  }
  else {
    $now = time();
    if (($now - $begin) > ($session_time_limit*60)) {
      session_unset();
      $indexpath = $path_pre."index.php";
      die ("<a href='$indexpath' target='_top'>$index_text5!</a>");
    }
    else {
      $begin = $now;
      reg_sess_vars(array("begin"));
    }
  }
}

// Authentication, fetch user data
// pass this check only it the constant 'avoid_auth' is set in the script
if (!defined("avoid_auth")) { include_once("$lib_path/auth.inc.php"); }


// assign help files
  // list all languages without own help files, they have to take english
  if (eregi('br|da|hu|gr|is|it|ko|no|pl|pt|ru|se',$langua)) { $doc = $path_pre."/help/en"; }
  elseif ($langua=="tw") { $doc = $path_pre."/help/zh"; }
  // assuming catalan users would like to read spanish help  :)
  elseif ($langua=="ct" or $langua == "ad") { $doc = $path_pre."help/es"; }
  // the rest gets their own help files
  else { $doc = $path_pre."help/$langua"; }
// end help files

// group string for sql queries
if ($user_group) {
  $sql_group = "(gruppe = '$user_group')";
  $sql_user_group = "(gruppe = '$user_group')";
}
// all groups available for e.g. admin root, must be true in all cases
else {
  $sql_group = "(1 = 1)";
  $sql_user_group = "(1 = 1)";
}

// this function returns the level of a subproject - useful to indent elements in a list
// parameter: table and column name, $query, $access column,order by, value of element to show as selected, name of parent column
function show_elements_of_tree($table,$name,$query,$acc,$order,$selected,$parent,$parent_ID) {
  global $indent, $user_kurz, $user_access;

  // fetch parent project
  $result = db_query("select ID,$name,$acc from $table $query and $parent = '$parent_ID' $order") or db_die();
  while ($row = db_fetch_row($result)) {

    // if the table is table projects, check whether the user is a participant of the project
    if ($table == "projekte") { if (ereg("\"$user_kurz\"",$row[2]) or ereg("c",$user_access)) { $allowed = 1; }}

    // access allowed
    if ($allowed == 1) {
      echo "<option value='$row[0]'";
      if ($row[0] == $selected) { echo " selected"; }
      echo ">";
      for ($i = 1; $i <= $indent; $i++) { echo "&nbsp;&nbsp;"; }
      echo "$row[1]</option>\n";
    }

    // look for subelements
    $indent++;
    show_elements_of_tree($table,$name,$query,$acc,$order,$selected,$parent,$row[0]);
    $indent--;
  }
}
// adds hidden fields to some forms
//   - for modules that have different forms for create and modify data
$view_param = array('up'=>$up,'sort'=>$sort,'perpage'=>$perpage,'page'=>$page,'filter'=>$filter,'keyword'=>$keyword);

function hidden_fields($hid){
  reset($hid);
  foreach($hid as $key=>$value) {
        echo "<input type=hidden name=$key value=$value>\n";
   }
}

// this function gets the OS of the browser and chooses the appropiate css file
function def_style() {
  global $HTTP_USER_AGENT, $path_pre;
  // mac platform ...
  if (eregi("mac", $HTTP_USER_AGENT)) { return $path_pre."layout/css/mac.css"; }
  // windows OS ...
  elseif (eregi("win", $HTTP_USER_AGENT)) {
    // special css for 4.x NN browsers
    if (eregi("4.7|4.6|4.5", $HTTP_USER_AGENT)) { return $path_pre."layout/css/nn4.css"; }
    // css for IE and opera
    else  { return $path_pre."layout/css/win.css"; }
  }
  // default layout - not very nice but could fit a bit at least
  else { return $path_pre."layout/css/style.css"; }
} // end find style sheet

// transmit PHPSESSID in GET-strings if needed (no cookies) only
$sid = (SID?"&".SID:"");
?>