<?php

// csv_ex.php - PHProjekt Version 3.3
// copyright    2000-2002 Albrecht Guenther  ag@phprojekt.com
// www.phprojekt.com
// Author: Albrecht Guenther, Norbert Ku:ck

$path_pre="../";
$include_path = $path_pre."lib/lib.inc.php";
include_once $include_path;

   global $HTTP_SERVER_VARS;

   if ($HTTP_SERVER_VARS['HTTPS'] !== 'on') {
      header ("Cache-Control: no-cache, must-revalidate");
      header ("Pragma: no-cache");
   } else {
      // for SSL connections you have to replace the two previous lines with
      header ("Cache-Control: must-revalidate, post-check=0,pre-check=0");
      header ("Pragma: public");
   }

   $filename = $file . ".csv";
   $contenttype = "text/csv";
   if (eregi("MSIE",$global["HTTP_USER_AGENT"])) {
      $contenttype = "application/octet-stream";
   }
  header("Content-type: $contenttype");
  header("Content-disposition: inline; filename=$filename");
  switch ($file){
    case "timecard":
       $query = "select datum, anfang, ende, out_begin, out_end from timecard where users = '$user_ID' and datum like '%-$month-%' and datum like '$year-%' order by datum";
       break;
    case "timecard_admin":
       check_admin_perm();
       $query = "select datum, anfang, ende, out_begin, out_end from timecard where users = '$pers_ID' and datum like '%-$month-%' and datum like '$year-%' order by datum";
    break;
    case "user":
       $query = "select anrede, vorname, nachname, kurz, firma, email, tel1, tel2, fax, strasse, plz, stadt, land from users where $sql_user_group";
       break;
    case "contacts":
       if ($keyword) {
          if ($filter == "all" or $filter == '') { $where = "and (nachname like '%$keyword%' or firma like '%$keyword%' or email like '%$keyword%' or stadt like '%$keyword%' or land like '%$keyword%' or kategorie like '%$keyword%' or bemerkung like '%$keyword%')"; }
          else { $where = "and $filter like '%$keyword%'"; }
       }
       $query = "select anrede, vorname, nachname, firma, email, email2, tel1, tel2, fax, mobil, strasse, plz, stadt, land, state, kategorie, bemerkung, url from contacts where (von = '$user_ID' or acc like 'a') and $sql_user_group $where";
       break;
    case "bookmarks":
         $query = "select url, bezeichnung, bemerkung from lesezeichen where gruppe = $user_group";
         break;
    case "timeproj":
         $query = "select timeproj.datum,projekte.name,timeproj.h,timeproj.m,timeproj.note from timeproj,projekte  where
                   timeproj.projekt = projekte.ID and timeproj.users = $user_ID and timeproj.datum like '$year-$month-%'
                   order by timeproj.datum asc";
         break;
    default:
         die("You are not allowed to do this!");    
  }


  $result = db_query("$query") or db_die();
  while ($row = db_fetch_row($result)) {
    for ($i=0;$i < count($row); $i++) {
      if (ereg(":{",$row[$i])) {
        $row[$i] = unserialize($row[$i]);
        $row[$i] = implode(":", $row[$i]);
      }
      // delete end of lines in data
      $row[$i] = rtrim(eregi_replace("\n|\r"," ",$row[$i]));
      // mask doublequotes in data for reimport
      $row[$i] = ereg_replace('"','""',$row[$i]);
      echo "\"$row[$i]\"";
      if ( $i < (count($row)-1) ) { echo ","; }
      else { echo "\n"; }
    }
  }

// check whether this admin has the permission to export the timecard from this user
function check_admin_perm() {
  global $user_group, $user_access, $groups, $pers_ID;

  // 1. check: is this user an admin?
  if (!ereg("a",$user_access)) { die("you are not allowed to do this!"); }

  // 2. check for the right group - only if it is a group admin
  if ($groups and $user_group > 0) {
    // loop over all groups where the mentioned user is member
    $result = db_query("select grup_ID from grup_user where user_ID = '$pers_ID'") or db_die();
    while ($row = db_fetch_row($result)) {
      // one entry matches the group of the admin? -> fine :-)
      if ($row[0] == $user_group) { $ok = 1; }
    }
    // no entry found -> die ...
    if (!$ok) { die("you are not allowed to do this!"); }
  }
}

?>
