'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XEnumDB.man,v 1.6 2005/02/11 03:02:54 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
'\" t
.TH XrmEnumerateDatabase 3X11 __vendorversion__ "XLIB FUNCTIONS"
.SH NAME
XrmEnumerateDatabase \- enumerate resource database entries
.SH SYNTAX
.TS
lw(.5i) lw(2i) lw(2.5i).
T{
\&#define
T}	T{
.ZN XrmEnumAllLevels
T}	T{
0
T}
T{
\&#define
T}	T{
.ZN XrmEnumOneLevel
T}	T{
1
T}
.TE
.HP
Bool XrmEnumerateDatabase\^(\^XrmDatabase \fIdatabase\fP\^, XrmNameList
\fIname_prefix\fP\^, XrmClassList \fIclass_prefix\fP\^, int \fImode\fP\^, Bool
(\^*\fIproc\fP\^)\^(\^)\^, XPointer \fIarg\fP\^); 
.SH ARGUMENTS
.IP \fIdatabase\fP 1i
Specifies the resource database.
.IP \fIname_prefix\fP 1i
Specifies the resource name prefix.
.IP \fIclass_prefix\fP 1i
Specifies the resource class prefix.
.IP \fImode\fP 1i
Specifies the number of levels to enumerate.
.IP \fIproc\fP 1i
Specifies the procedure that is to be called for each matching entry.
.IP \fIarg\fP 1i
Specifies the user-supplied argument that will be passed to the procedure.
.SH DESCRIPTION
The
.ZN XrmEnumerateDatabase
function calls the specified procedure for each resource in the database
that would match some completion of the given name/class resource prefix.
The order in which resources are found is implementation-dependent.
If mode is
.ZN XrmEnumOneLevel ,
a resource must match the given name/class prefix with
just a single name and class appended.  If mode is
.ZN XrmEnumAllLevels ,
the resource must match the given name/class prefix with one or more names and
classes appended.
If the procedure returns
.ZN True ,
the enumeration terminates and the function returns
.ZN True . 
If the procedure always returns
.ZN False ,
all matching resources are enumerated and the function returns
.ZN False .
.LP
The procedure is called with the following arguments:
.LP
.\" Start marker code here
.Ds 0
.TA .5i 3i
.ta .5i 3i
(*\fIproc\fP\^)(\^\fIdatabase\fP, \fIbindings\fP, \fIquarks\fP, \fItype\fP, \fIvalue\fP, \fIarg\fP\^)
	XrmDatabase *\fIdatabase\fP\^;
	XrmBindingList \fIbindings\fP\^;
	XrmQuarkList \fIquarks\fP\^;
	XrmRepresentation *\fItype\fP\^;
	XrmValue *\fIvalue\fP\^;
	XPointer \fIarg\fP\^;
.De
.\" End marker code here
.LP
The bindings and quarks lists are terminated by
.ZN NULLQUARK .
Note that pointers
to the database and type are passed, but these values should not be modified.
.LP
The procedure must not modify the database.
If Xlib has been initialized for threads, the procedure is called with
the database locked and the result of a call by the procedure to any
Xlib function using the same database is not defined.
.SH "SEE ALSO"
XrmGetResource(3X11),
XrmInitialize(3X11),
XrmPutResource(3X11)
.br
\fI\*(xL\fP
