/*
 *      SCCS:  @(#)  TestH.c Rel 1.1	    (11/28/91)
 *
 *	UniSoft Ltd., London, England
 *
 * (C) Copyright 1991 X/Open Company Limited
 *
 * All rights reserved.  No part of this source code may be reproduced,
 * stored in a retrieval system, or transmitted, in any form or by any
 * means, electronic, mechanical, photocopying, recording or otherwise,
 * except as stated in the end-user licence agreement, without the prior
 * permission of the copyright owners.
 *
 * X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
 * the UK and other countries.
 */

#include        <stdlib.h>
#include        "xtest.h"
#include        "Xlib.h"
#include        "Xutil.h"
#include        "Xresource.h"
#include        "tet_api.h"
#include        "xtestlib.h"
#include        "pixval.h"

extern char	*TestName;
extern Display	*Dsp;

int		minkc;
int		maxkc;
int		keysyms_per_keycode;

static int
test(symbol, str)
KeySym	symbol;
char	*str;
{
KeyCode	kycd;
int	mod;

	kycd = XKeysymToKeycode(Dsp, symbol);
	if(kycd == 0) {
		trace("XKeysymToKeycode() returned 0 for KeySym \"XK_%s\".", str);
		return(1);
	}

	if(kycd > maxkc || kycd < minkc) {
		report("XKeysymToKeycode() returned invalid keycode value %d for KeySym \"XK_%s\".", kycd, str);
		return(0);
	}

	for(mod = 0; mod < keysyms_per_keycode; mod++) {
		if( symbol == XKeycodeToKeysym(Dsp, kycd, mod))  {
			trace("KeySym \"XK_%s\", keycode %d, mod %d", 
								str, kycd, mod);
			return(1);
		}
	}

	report("The keycode value %d for KeySym \"XK_%s\"", kycd, str);
	report("never returns that KeySym when using XKeycodeToKeysym()");
	return(0);
}

static void
reporterr(s)
char	*s;
{
	report("Symbol XK_\"%s\" is not defined.", s);
}
#define XK_HEBREW
#include	<X11/keysymdef.h>
#undef XK_HEBREW 

kysymtcdH()
{ 
int 	pass = 0, fail = 0;

	XDisplayKeycodes(Dsp, &minkc, &maxkc);
	XGetKeyboardMapping(Dsp, (KeyCode)minkc, 1, &keysyms_per_keycode);

#ifdef XK_hebrew_doublelowline
	if(test(XK_hebrew_doublelowline, "hebrew_doublelowline") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_doublelowline");
	FAIL;
#endif

#ifdef XK_hebrew_aleph
	if(test(XK_hebrew_aleph, "hebrew_aleph") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_aleph");
	FAIL;
#endif

#ifdef XK_hebrew_bet
	if(test(XK_hebrew_bet, "hebrew_bet") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_bet");
	FAIL;
#endif

#ifdef XK_hebrew_beth
	if(test(XK_hebrew_beth, "hebrew_beth") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_beth");
	FAIL;
#endif

#ifdef XK_hebrew_gimel
	if(test(XK_hebrew_gimel, "hebrew_gimel") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_gimel");
	FAIL;
#endif

#ifdef XK_hebrew_gimmel
	if(test(XK_hebrew_gimmel, "hebrew_gimmel") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_gimmel");
	FAIL;
#endif

#ifdef XK_hebrew_dalet
	if(test(XK_hebrew_dalet, "hebrew_dalet") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_dalet");
	FAIL;
#endif

#ifdef XK_hebrew_daleth
	if(test(XK_hebrew_daleth, "hebrew_daleth") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_daleth");
	FAIL;
#endif

#ifdef XK_hebrew_he
	if(test(XK_hebrew_he, "hebrew_he") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_he");
	FAIL;
#endif

#ifdef XK_hebrew_waw
	if(test(XK_hebrew_waw, "hebrew_waw") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_waw");
	FAIL;
#endif

#ifdef XK_hebrew_zain
	if(test(XK_hebrew_zain, "hebrew_zain") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_zain");
	FAIL;
#endif

#ifdef XK_hebrew_zayin
	if(test(XK_hebrew_zayin, "hebrew_zayin") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_zayin");
	FAIL;
#endif

#ifdef XK_hebrew_chet
	if(test(XK_hebrew_chet, "hebrew_chet") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_chet");
	FAIL;
#endif

#ifdef XK_hebrew_het
	if(test(XK_hebrew_het, "hebrew_het") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_het");
	FAIL;
#endif

#ifdef XK_hebrew_tet
	if(test(XK_hebrew_tet, "hebrew_tet") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_tet");
	FAIL;
#endif

#ifdef XK_hebrew_teth
	if(test(XK_hebrew_teth, "hebrew_teth") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_teth");
	FAIL;
#endif

#ifdef XK_hebrew_yod
	if(test(XK_hebrew_yod, "hebrew_yod") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_yod");
	FAIL;
#endif

#ifdef XK_hebrew_finalkaph
	if(test(XK_hebrew_finalkaph, "hebrew_finalkaph") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_finalkaph");
	FAIL;
#endif

#ifdef XK_hebrew_kaph
	if(test(XK_hebrew_kaph, "hebrew_kaph") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_kaph");
	FAIL;
#endif

#ifdef XK_hebrew_lamed
	if(test(XK_hebrew_lamed, "hebrew_lamed") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_lamed");
	FAIL;
#endif

#ifdef XK_hebrew_finalmem
	if(test(XK_hebrew_finalmem, "hebrew_finalmem") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_finalmem");
	FAIL;
#endif

#ifdef XK_hebrew_mem
	if(test(XK_hebrew_mem, "hebrew_mem") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_mem");
	FAIL;
#endif

#ifdef XK_hebrew_finalnun
	if(test(XK_hebrew_finalnun, "hebrew_finalnun") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_finalnun");
	FAIL;
#endif

#ifdef XK_hebrew_nun
	if(test(XK_hebrew_nun, "hebrew_nun") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_nun");
	FAIL;
#endif

#ifdef XK_hebrew_samech
	if(test(XK_hebrew_samech, "hebrew_samech") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_samech");
	FAIL;
#endif

#ifdef XK_hebrew_samekh
	if(test(XK_hebrew_samekh, "hebrew_samekh") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_samekh");
	FAIL;
#endif

#ifdef XK_hebrew_ayin
	if(test(XK_hebrew_ayin, "hebrew_ayin") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_ayin");
	FAIL;
#endif

#ifdef XK_hebrew_finalpe
	if(test(XK_hebrew_finalpe, "hebrew_finalpe") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_finalpe");
	FAIL;
#endif

#ifdef XK_hebrew_pe
	if(test(XK_hebrew_pe, "hebrew_pe") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_pe");
	FAIL;
#endif

#ifdef XK_hebrew_finalzade
	if(test(XK_hebrew_finalzade, "hebrew_finalzade") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_finalzade");
	FAIL;
#endif

#ifdef XK_hebrew_finalzadi
	if(test(XK_hebrew_finalzadi, "hebrew_finalzadi") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_finalzadi");
	FAIL;
#endif

#ifdef XK_hebrew_zade
	if(test(XK_hebrew_zade, "hebrew_zade") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_zade");
	FAIL;
#endif

#ifdef XK_hebrew_zadi
	if(test(XK_hebrew_zadi, "hebrew_zadi") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_zadi");
	FAIL;
#endif

#ifdef XK_hebrew_qoph
	if(test(XK_hebrew_qoph, "hebrew_qoph") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_qoph");
	FAIL;
#endif

#ifdef XK_hebrew_kuf
	if(test(XK_hebrew_kuf, "hebrew_kuf") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_kuf");
	FAIL;
#endif

#ifdef XK_hebrew_resh
	if(test(XK_hebrew_resh, "hebrew_resh") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_resh");
	FAIL;
#endif

#ifdef XK_hebrew_shin
	if(test(XK_hebrew_shin, "hebrew_shin") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_shin");
	FAIL;
#endif

#ifdef XK_hebrew_taw
	if(test(XK_hebrew_taw, "hebrew_taw") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_taw");
	FAIL;
#endif

#ifdef XK_hebrew_taf
	if(test(XK_hebrew_taf, "hebrew_taf") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("hebrew_taf");
	FAIL;
#endif

#ifdef XK_Hebrew_switch
	if(test(XK_Hebrew_switch, "Hebrew_switch") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("Hebrew_switch");
	FAIL;
#endif

	CHECKPASS(40);
}
