/*
 *      SCCS:  @(#)  Test3.c Rel 1.1	    (11/28/91)
 *
 *	UniSoft Ltd., London, England
 *
 * (C) Copyright 1991 X/Open Company Limited
 *
 * All rights reserved.  No part of this source code may be reproduced,
 * stored in a retrieval system, or transmitted, in any form or by any
 * means, electronic, mechanical, photocopying, recording or otherwise,
 * except as stated in the end-user licence agreement, without the prior
 * permission of the copyright owners.
 *
 * X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
 * the UK and other countries.
 */

#include        <stdlib.h>
#include        "xtest.h"
#include        "Xlib.h"
#include        "Xutil.h"
#include        "Xresource.h"
#include        "tet_api.h"
#include        "xtestlib.h"
#include        "pixval.h"

extern char	*TestName;

static int
test(symbol, str)
KeySym	symbol;
char	*str;
{
KeySym	rsym;

	rsym = XStringToKeysym(str);

	if(rsym == NoSymbol) {
		report("XStringToKeysym() returned NoSymbol for string \"%s\".", str);
		return(0);
	}

	if(rsym != symbol) {
		report("XStringToKeysym() returned KeySym 0x%lx instead of 0x%lx.", (long) rsym, (long) symbol);
		return(0);
	}
	return(1);
}

static void
reporterr(s)
char	*s;
{
	report("Symbol \"%s\" is not defined.", s);
}
#define XK_LATIN3
#include	<X11/keysymdef.h>
#undef XK_LATIN3 

strtsym3()
{ 
int 	pass = 0, fail = 0;
char	*symstr;
KeySym	rsym;


#ifdef XK_Hstroke
	if(test(XK_Hstroke, "Hstroke") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Hstroke");
	FAIL;
#endif

#ifdef XK_Hcircumflex
	if(test(XK_Hcircumflex, "Hcircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Hcircumflex");
	FAIL;
#endif

#ifdef XK_Iabovedot
	if(test(XK_Iabovedot, "Iabovedot") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Iabovedot");
	FAIL;
#endif

#ifdef XK_Gbreve
	if(test(XK_Gbreve, "Gbreve") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Gbreve");
	FAIL;
#endif

#ifdef XK_Jcircumflex
	if(test(XK_Jcircumflex, "Jcircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Jcircumflex");
	FAIL;
#endif

#ifdef XK_hstroke
	if(test(XK_hstroke, "hstroke") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_hstroke");
	FAIL;
#endif

#ifdef XK_hcircumflex
	if(test(XK_hcircumflex, "hcircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_hcircumflex");
	FAIL;
#endif

#ifdef XK_idotless
	if(test(XK_idotless, "idotless") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_idotless");
	FAIL;
#endif

#ifdef XK_gbreve
	if(test(XK_gbreve, "gbreve") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_gbreve");
	FAIL;
#endif

#ifdef XK_jcircumflex
	if(test(XK_jcircumflex, "jcircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_jcircumflex");
	FAIL;
#endif

#ifdef XK_Cabovedot
	if(test(XK_Cabovedot, "Cabovedot") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Cabovedot");
	FAIL;
#endif

#ifdef XK_Ccircumflex
	if(test(XK_Ccircumflex, "Ccircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Ccircumflex");
	FAIL;
#endif

#ifdef XK_Gabovedot
	if(test(XK_Gabovedot, "Gabovedot") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Gabovedot");
	FAIL;
#endif

#ifdef XK_Gcircumflex
	if(test(XK_Gcircumflex, "Gcircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Gcircumflex");
	FAIL;
#endif

#ifdef XK_Ubreve
	if(test(XK_Ubreve, "Ubreve") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Ubreve");
	FAIL;
#endif

#ifdef XK_Scircumflex
	if(test(XK_Scircumflex, "Scircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_Scircumflex");
	FAIL;
#endif

#ifdef XK_cabovedot
	if(test(XK_cabovedot, "cabovedot") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_cabovedot");
	FAIL;
#endif

#ifdef XK_ccircumflex
	if(test(XK_ccircumflex, "ccircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_ccircumflex");
	FAIL;
#endif

#ifdef XK_gabovedot
	if(test(XK_gabovedot, "gabovedot") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_gabovedot");
	FAIL;
#endif

#ifdef XK_gcircumflex
	if(test(XK_gcircumflex, "gcircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_gcircumflex");
	FAIL;
#endif

#ifdef XK_ubreve
	if(test(XK_ubreve, "ubreve") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_ubreve");
	FAIL;
#endif

#ifdef XK_scircumflex
	if(test(XK_scircumflex, "scircumflex") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("XK_scircumflex");
	FAIL;
#endif

	CHECKPASS(22);
}
