package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStrategyProcess invokes the aegis.DescribeStrategyProcess API synchronously
// api document: https://help.aliyun.com/api/aegis/describestrategyprocess.html
func (client *Client) DescribeStrategyProcess(request *DescribeStrategyProcessRequest) (response *DescribeStrategyProcessResponse, err error) {
	response = CreateDescribeStrategyProcessResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStrategyProcessWithChan invokes the aegis.DescribeStrategyProcess API asynchronously
// api document: https://help.aliyun.com/api/aegis/describestrategyprocess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStrategyProcessWithChan(request *DescribeStrategyProcessRequest) (<-chan *DescribeStrategyProcessResponse, <-chan error) {
	responseChan := make(chan *DescribeStrategyProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStrategyProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStrategyProcessWithCallback invokes the aegis.DescribeStrategyProcess API asynchronously
// api document: https://help.aliyun.com/api/aegis/describestrategyprocess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStrategyProcessWithCallback(request *DescribeStrategyProcessRequest, callback func(response *DescribeStrategyProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStrategyProcessResponse
		var err error
		defer close(result)
		response, err = client.DescribeStrategyProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStrategyProcessRequest is the request struct for api DescribeStrategyProcess
type DescribeStrategyProcessRequest struct {
	*requests.RpcRequest
	SourceIp   string           `position:"Query" name:"SourceIp"`
	StrategyId requests.Integer `position:"Query" name:"StrategyId"`
}

// DescribeStrategyProcessResponse is the response struct for api DescribeStrategyProcess
type DescribeStrategyProcessResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	StrategyId  int    `json:"StrategyId" xml:"StrategyId"`
	ProcessRate int    `json:"ProcessRate" xml:"ProcessRate"`
	ExecStatus  int    `json:"ExecStatus" xml:"ExecStatus"`
	PassRate    string `json:"PassRate" xml:"PassRate"`
}

// CreateDescribeStrategyProcessRequest creates a request to invoke DescribeStrategyProcess API
func CreateDescribeStrategyProcessRequest() (request *DescribeStrategyProcessRequest) {
	request = &DescribeStrategyProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeStrategyProcess", "vipaegis", "openAPI")
	return
}

// CreateDescribeStrategyProcessResponse creates a response to parse from DescribeStrategyProcess response
func CreateDescribeStrategyProcessResponse() (response *DescribeStrategyProcessResponse) {
	response = &DescribeStrategyProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
