package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDnsGtmAccessMode invokes the alidns.SetDnsGtmAccessMode API synchronously
func (client *Client) SetDnsGtmAccessMode(request *SetDnsGtmAccessModeRequest) (response *SetDnsGtmAccessModeResponse, err error) {
	response = CreateSetDnsGtmAccessModeResponse()
	err = client.DoAction(request, response)
	return
}

// SetDnsGtmAccessModeWithChan invokes the alidns.SetDnsGtmAccessMode API asynchronously
func (client *Client) SetDnsGtmAccessModeWithChan(request *SetDnsGtmAccessModeRequest) (<-chan *SetDnsGtmAccessModeResponse, <-chan error) {
	responseChan := make(chan *SetDnsGtmAccessModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDnsGtmAccessMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDnsGtmAccessModeWithCallback invokes the alidns.SetDnsGtmAccessMode API asynchronously
func (client *Client) SetDnsGtmAccessModeWithCallback(request *SetDnsGtmAccessModeRequest, callback func(response *SetDnsGtmAccessModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDnsGtmAccessModeResponse
		var err error
		defer close(result)
		response, err = client.SetDnsGtmAccessMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDnsGtmAccessModeRequest is the request struct for api SetDnsGtmAccessMode
type SetDnsGtmAccessModeRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	StrategyId   string `position:"Query" name:"StrategyId"`
	Lang         string `position:"Query" name:"Lang"`
	AccessMode   string `position:"Query" name:"AccessMode"`
}

// SetDnsGtmAccessModeResponse is the response struct for api SetDnsGtmAccessMode
type SetDnsGtmAccessModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDnsGtmAccessModeRequest creates a request to invoke SetDnsGtmAccessMode API
func CreateSetDnsGtmAccessModeRequest() (request *SetDnsGtmAccessModeRequest) {
	request = &SetDnsGtmAccessModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "SetDnsGtmAccessMode", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDnsGtmAccessModeResponse creates a response to parse from SetDnsGtmAccessMode response
func CreateSetDnsGtmAccessModeResponse() (response *SetDnsGtmAccessModeResponse) {
	response = &SetDnsGtmAccessModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
