package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterState invokes the arms.GetClusterState API synchronously
func (client *Client) GetClusterState(request *GetClusterStateRequest) (response *GetClusterStateResponse, err error) {
	response = CreateGetClusterStateResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterStateWithChan invokes the arms.GetClusterState API asynchronously
func (client *Client) GetClusterStateWithChan(request *GetClusterStateRequest) (<-chan *GetClusterStateResponse, <-chan error) {
	responseChan := make(chan *GetClusterStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterStateWithCallback invokes the arms.GetClusterState API asynchronously
func (client *Client) GetClusterStateWithCallback(request *GetClusterStateRequest, callback func(response *GetClusterStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterStateResponse
		var err error
		defer close(result)
		response, err = client.GetClusterState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterStateRequest is the request struct for api GetClusterState
type GetClusterStateRequest struct {
	*requests.RpcRequest
	PuserId   string `position:"Query" name:"PuserId"`
	ClusterId string `position:"Query" name:"ClusterId"`
}

// GetClusterStateResponse is the response struct for api GetClusterState
type GetClusterStateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateGetClusterStateRequest creates a request to invoke GetClusterState API
func CreateGetClusterStateRequest() (request *GetClusterStateRequest) {
	request = &GetClusterStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetClusterState", "", "")
	request.Method = requests.POST
	return
}

// CreateGetClusterStateResponse creates a response to parse from GetClusterState response
func CreateGetClusterStateResponse() (response *GetClusterStateResponse) {
	response = &GetClusterStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
