package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPredictiveJobStatus invokes the cloudcallcenter.ListPredictiveJobStatus API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobstatus.html
func (client *Client) ListPredictiveJobStatus(request *ListPredictiveJobStatusRequest) (response *ListPredictiveJobStatusResponse, err error) {
	response = CreateListPredictiveJobStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListPredictiveJobStatusWithChan invokes the cloudcallcenter.ListPredictiveJobStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPredictiveJobStatusWithChan(request *ListPredictiveJobStatusRequest) (<-chan *ListPredictiveJobStatusResponse, <-chan error) {
	responseChan := make(chan *ListPredictiveJobStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPredictiveJobStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPredictiveJobStatusWithCallback invokes the cloudcallcenter.ListPredictiveJobStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPredictiveJobStatusWithCallback(request *ListPredictiveJobStatusRequest, callback func(response *ListPredictiveJobStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPredictiveJobStatusResponse
		var err error
		defer close(result)
		response, err = client.ListPredictiveJobStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPredictiveJobStatusRequest is the request struct for api ListPredictiveJobStatus
type ListPredictiveJobStatusRequest struct {
	*requests.RpcRequest
	TimeAlignment string           `position:"Query" name:"TimeAlignment"`
	PhoneNumber   string           `position:"Query" name:"PhoneNumber"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	ContactName   string           `position:"Query" name:"ContactName"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
	JobGroupId    string           `position:"Query" name:"JobGroupId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// ListPredictiveJobStatusResponse is the response struct for api ListPredictiveJobStatus
type ListPredictiveJobStatusResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Jobs           Jobs   `json:"Jobs" xml:"Jobs"`
}

// CreateListPredictiveJobStatusRequest creates a request to invoke ListPredictiveJobStatus API
func CreateListPredictiveJobStatusRequest() (request *ListPredictiveJobStatusRequest) {
	request = &ListPredictiveJobStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListPredictiveJobStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateListPredictiveJobStatusResponse creates a response to parse from ListPredictiveJobStatus response
func CreateListPredictiveJobStatusResponse() (response *ListPredictiveJobStatusResponse) {
	response = &ListPredictiveJobStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
