package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckEngineMetaPartition invokes the dataworks_public.CheckEngineMetaPartition API synchronously
func (client *Client) CheckEngineMetaPartition(request *CheckEngineMetaPartitionRequest) (response *CheckEngineMetaPartitionResponse, err error) {
	response = CreateCheckEngineMetaPartitionResponse()
	err = client.DoAction(request, response)
	return
}

// CheckEngineMetaPartitionWithChan invokes the dataworks_public.CheckEngineMetaPartition API asynchronously
func (client *Client) CheckEngineMetaPartitionWithChan(request *CheckEngineMetaPartitionRequest) (<-chan *CheckEngineMetaPartitionResponse, <-chan error) {
	responseChan := make(chan *CheckEngineMetaPartitionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckEngineMetaPartition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckEngineMetaPartitionWithCallback invokes the dataworks_public.CheckEngineMetaPartition API asynchronously
func (client *Client) CheckEngineMetaPartitionWithCallback(request *CheckEngineMetaPartitionRequest, callback func(response *CheckEngineMetaPartitionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckEngineMetaPartitionResponse
		var err error
		defer close(result)
		response, err = client.CheckEngineMetaPartition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckEngineMetaPartitionRequest is the request struct for api CheckEngineMetaPartition
type CheckEngineMetaPartitionRequest struct {
	*requests.RpcRequest
	DataSourceType string `position:"Query" name:"DataSourceType"`
	Partition      string `position:"Query" name:"Partition"`
	TableGuid      string `position:"Query" name:"TableGuid"`
}

// CheckEngineMetaPartitionResponse is the response struct for api CheckEngineMetaPartition
type CheckEngineMetaPartitionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCheckEngineMetaPartitionRequest creates a request to invoke CheckEngineMetaPartition API
func CreateCheckEngineMetaPartitionRequest() (request *CheckEngineMetaPartitionRequest) {
	request = &CheckEngineMetaPartitionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CheckEngineMetaPartition", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckEngineMetaPartitionResponse creates a response to parse from CheckEngineMetaPartition response
func CreateCheckEngineMetaPartitionResponse() (response *CheckEngineMetaPartitionResponse) {
	response = &CheckEngineMetaPartitionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
