package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetNodes invokes the ehpc.ResetNodes API synchronously
func (client *Client) ResetNodes(request *ResetNodesRequest) (response *ResetNodesResponse, err error) {
	response = CreateResetNodesResponse()
	err = client.DoAction(request, response)
	return
}

// ResetNodesWithChan invokes the ehpc.ResetNodes API asynchronously
func (client *Client) ResetNodesWithChan(request *ResetNodesRequest) (<-chan *ResetNodesResponse, <-chan error) {
	responseChan := make(chan *ResetNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetNodesWithCallback invokes the ehpc.ResetNodes API asynchronously
func (client *Client) ResetNodesWithCallback(request *ResetNodesRequest, callback func(response *ResetNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetNodesResponse
		var err error
		defer close(result)
		response, err = client.ResetNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetNodesRequest is the request struct for api ResetNodes
type ResetNodesRequest struct {
	*requests.RpcRequest
	Instance  *[]ResetNodesInstance `position:"Query" name:"Instance"  type:"Repeated"`
	ClusterId string                `position:"Query" name:"ClusterId"`
}

// ResetNodesInstance is a repeated param struct in ResetNodesRequest
type ResetNodesInstance struct {
	Id string `name:"Id"`
}

// ResetNodesResponse is the response struct for api ResetNodes
type ResetNodesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateResetNodesRequest creates a request to invoke ResetNodes API
func CreateResetNodesRequest() (request *ResetNodesRequest) {
	request = &ResetNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ResetNodes", "", "")
	request.Method = requests.GET
	return
}

// CreateResetNodesResponse creates a response to parse from ResetNodes response
func CreateResetNodesResponse() (response *ResetNodesResponse) {
	response = &ResetNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
