package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCommodity invokes the market.DeleteCommodity API synchronously
// api document: https://help.aliyun.com/api/market/deletecommodity.html
func (client *Client) DeleteCommodity(request *DeleteCommodityRequest) (response *DeleteCommodityResponse, err error) {
	response = CreateDeleteCommodityResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCommodityWithChan invokes the market.DeleteCommodity API asynchronously
// api document: https://help.aliyun.com/api/market/deletecommodity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCommodityWithChan(request *DeleteCommodityRequest) (<-chan *DeleteCommodityResponse, <-chan error) {
	responseChan := make(chan *DeleteCommodityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCommodity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCommodityWithCallback invokes the market.DeleteCommodity API asynchronously
// api document: https://help.aliyun.com/api/market/deletecommodity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCommodityWithCallback(request *DeleteCommodityRequest, callback func(response *DeleteCommodityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCommodityResponse
		var err error
		defer close(result)
		response, err = client.DeleteCommodity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCommodityRequest is the request struct for api DeleteCommodity
type DeleteCommodityRequest struct {
	*requests.RpcRequest
	CommodityId string `position:"Query" name:"CommodityId"`
}

// DeleteCommodityResponse is the response struct for api DeleteCommodity
type DeleteCommodityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteCommodityRequest creates a request to invoke DeleteCommodity API
func CreateDeleteCommodityRequest() (request *DeleteCommodityRequest) {
	request = &DeleteCommodityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DeleteCommodity", "yunmarket", "openAPI")
	return
}

// CreateDeleteCommodityResponse creates a response to parse from DeleteCommodity response
func CreateDeleteCommodityResponse() (response *DeleteCommodityResponse) {
	response = &DeleteCommodityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
