package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchTestCase invokes the rdc.SearchTestCase API synchronously
// api document: https://help.aliyun.com/api/rdc/searchtestcase.html
func (client *Client) SearchTestCase(request *SearchTestCaseRequest) (response *SearchTestCaseResponse, err error) {
	response = CreateSearchTestCaseResponse()
	err = client.DoAction(request, response)
	return
}

// SearchTestCaseWithChan invokes the rdc.SearchTestCase API asynchronously
// api document: https://help.aliyun.com/api/rdc/searchtestcase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchTestCaseWithChan(request *SearchTestCaseRequest) (<-chan *SearchTestCaseResponse, <-chan error) {
	responseChan := make(chan *SearchTestCaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchTestCase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchTestCaseWithCallback invokes the rdc.SearchTestCase API asynchronously
// api document: https://help.aliyun.com/api/rdc/searchtestcase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchTestCaseWithCallback(request *SearchTestCaseRequest, callback func(response *SearchTestCaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchTestCaseResponse
		var err error
		defer close(result)
		response, err = client.SearchTestCase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchTestCaseRequest is the request struct for api SearchTestCase
type SearchTestCaseRequest struct {
	*requests.RpcRequest
	UpdateDateEnd   string           `position:"Body" name:"UpdateDateEnd"`
	CorpIdentifier  string           `position:"Query" name:"CorpIdentifier"`
	CreateDateEnd   string           `position:"Body" name:"CreateDateEnd"`
	CreateDateStart string           `position:"Body" name:"CreateDateStart"`
	UpdateDateStart string           `position:"Body" name:"UpdateDateStart"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	AkProjectId     string           `position:"Body" name:"AkProjectId"`
	CaseTag         string           `position:"Body" name:"CaseTag"`
	PageNum         string           `position:"Body" name:"PageNum"`
}

// SearchTestCaseResponse is the response struct for api SearchTestCase
type SearchTestCaseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSearchTestCaseRequest creates a request to invoke SearchTestCase API
func CreateSearchTestCaseRequest() (request *SearchTestCaseRequest) {
	request = &SearchTestCaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "SearchTestCase", "rdc", "openAPI")
	return
}

// CreateSearchTestCaseResponse creates a response to parse from SearchTestCase response
func CreateSearchTestCaseResponse() (response *SearchTestCaseResponse) {
	response = &SearchTestCaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
