package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnUserQuota invokes the scdn.DescribeScdnUserQuota API synchronously
func (client *Client) DescribeScdnUserQuota(request *DescribeScdnUserQuotaRequest) (response *DescribeScdnUserQuotaResponse, err error) {
	response = CreateDescribeScdnUserQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnUserQuotaWithChan invokes the scdn.DescribeScdnUserQuota API asynchronously
func (client *Client) DescribeScdnUserQuotaWithChan(request *DescribeScdnUserQuotaRequest) (<-chan *DescribeScdnUserQuotaResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnUserQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnUserQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnUserQuotaWithCallback invokes the scdn.DescribeScdnUserQuota API asynchronously
func (client *Client) DescribeScdnUserQuotaWithCallback(request *DescribeScdnUserQuotaRequest, callback func(response *DescribeScdnUserQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnUserQuotaResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnUserQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnUserQuotaRequest is the request struct for api DescribeScdnUserQuota
type DescribeScdnUserQuotaRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeScdnUserQuotaResponse is the response struct for api DescribeScdnUserQuota
type DescribeScdnUserQuotaResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	DomainQuota      int    `json:"DomainQuota" xml:"DomainQuota"`
	RefreshUrlQuota  int    `json:"RefreshUrlQuota" xml:"RefreshUrlQuota"`
	RefreshDirQuota  int    `json:"RefreshDirQuota" xml:"RefreshDirQuota"`
	RefreshUrlRemain int    `json:"RefreshUrlRemain" xml:"RefreshUrlRemain"`
	RefreshDirRemain int    `json:"RefreshDirRemain" xml:"RefreshDirRemain"`
	PreloadQuota     int    `json:"PreloadQuota" xml:"PreloadQuota"`
	PreloadRemain    int    `json:"PreloadRemain" xml:"PreloadRemain"`
	BlockQuota       int    `json:"BlockQuota" xml:"BlockQuota"`
	BlockRemain      int    `json:"BlockRemain" xml:"BlockRemain"`
}

// CreateDescribeScdnUserQuotaRequest creates a request to invoke DescribeScdnUserQuota API
func CreateDescribeScdnUserQuotaRequest() (request *DescribeScdnUserQuotaRequest) {
	request = &DescribeScdnUserQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnUserQuota", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeScdnUserQuotaResponse creates a response to parse from DescribeScdnUserQuota response
func CreateDescribeScdnUserQuotaResponse() (response *DescribeScdnUserQuotaResponse) {
	response = &DescribeScdnUserQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
