package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActivateAllInOneGateway invokes the sgw.ActivateAllInOneGateway API synchronously
func (client *Client) ActivateAllInOneGateway(request *ActivateAllInOneGatewayRequest) (response *ActivateAllInOneGatewayResponse, err error) {
	response = CreateActivateAllInOneGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// ActivateAllInOneGatewayWithChan invokes the sgw.ActivateAllInOneGateway API asynchronously
func (client *Client) ActivateAllInOneGatewayWithChan(request *ActivateAllInOneGatewayRequest) (<-chan *ActivateAllInOneGatewayResponse, <-chan error) {
	responseChan := make(chan *ActivateAllInOneGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActivateAllInOneGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActivateAllInOneGatewayWithCallback invokes the sgw.ActivateAllInOneGateway API asynchronously
func (client *Client) ActivateAllInOneGatewayWithCallback(request *ActivateAllInOneGatewayRequest, callback func(response *ActivateAllInOneGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActivateAllInOneGatewayResponse
		var err error
		defer close(result)
		response, err = client.ActivateAllInOneGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActivateAllInOneGatewayRequest is the request struct for api ActivateAllInOneGateway
type ActivateAllInOneGatewayRequest struct {
	*requests.RpcRequest
	ClientUUID    string `position:"Query" name:"ClientUUID"`
	SerialNumber  string `position:"Query" name:"SerialNumber"`
	DeviceNumber  string `position:"Query" name:"DeviceNumber"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	Model         string `position:"Query" name:"Model"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// ActivateAllInOneGatewayResponse is the response struct for api ActivateAllInOneGateway
type ActivateAllInOneGatewayResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	GatewayId      string `json:"GatewayId" xml:"GatewayId"`
	RegionId       string `json:"RegionId" xml:"RegionId"`
	LicenseContent string `json:"LicenseContent" xml:"LicenseContent"`
}

// CreateActivateAllInOneGatewayRequest creates a request to invoke ActivateAllInOneGateway API
func CreateActivateAllInOneGatewayRequest() (request *ActivateAllInOneGatewayRequest) {
	request = &ActivateAllInOneGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ActivateAllInOneGateway", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateActivateAllInOneGatewayResponse creates a response to parse from ActivateAllInOneGateway response
func CreateActivateAllInOneGatewayResponse() (response *ActivateAllInOneGatewayResponse) {
	response = &ActivateAllInOneGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
