
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: logger.h 2338 2007-06-27 09:32:01Z mschwerin $
 *
 */

#ifndef HAVE_LOGGER_H
#define HAVE_LOGGER_H

typedef enum {
    LEVEL_FATAL = 0,
    LEVEL_ERROR = 1,
    LEVEL_WARN = 2,
    LEVEL_INFO = 3,
    LEVEL_DEBUG = 4,
    LEVEL_TODO = 5,
} logger_level_t;

void logger_init (const char *filename);
void logger_free (void);

void _log (logger_level_t level, const char *file, int line,
           const char *format, ...);

#ifdef DEBUG
#define debug(...) _log(LEVEL_DEBUG, __FILE__, __LINE__, __VA_ARGS__)
#define todo(...) _log(LEVEL_TODO, __FILE__, __LINE__, __VA_ARGS__)
#else
#define debug(...) ;
#define todo(...) _log(LEVEL_TODO, __FILE__, __LINE__, __VA_ARGS__)
#endif

#define log(level,...)  _log(level, __FILE__, __LINE__, __VA_ARGS__)
#define info(...)       _log(LEVEL_INFO, __FILE__, __LINE__, __VA_ARGS__)
#define warn(...)       _log(LEVEL_WARN, __FILE__, __LINE__, __VA_ARGS__)
#define error(...)      _log(LEVEL_ERROR, __FILE__, __LINE__, __VA_ARGS__)
#define fatal(...)      _log(LEVEL_FATAL, __FILE__, __LINE__, __VA_ARGS__)

#endif /* HAVE_LOGGER_H */
